/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.g;

public abstract class MultiLevelSkipListReader
implements Closeable {
    protected int maxNumberOfSkipLevels;
    private int numberOfSkipLevels;
    private int numberOfLevelsToBuffer = 1;
    private int docCount;
    private IndexInput[] skipStream;
    private long[] skipPointer;
    private int[] skipInterval;
    private int[] numSkipped;
    protected int[] skipDoc;
    private int lastDoc;
    private long[] childPointer;
    private long lastChildPointer;
    private boolean inputIsBuffered;
    private final int skipMultiplier;

    protected MultiLevelSkipListReader(IndexInput indexInput, int n2, int n3, int n4) {
        this.skipStream = new IndexInput[n2];
        this.skipPointer = new long[n2];
        this.childPointer = new long[n2];
        this.numSkipped = new int[n2];
        this.maxNumberOfSkipLevels = n2;
        this.skipInterval = new int[n2];
        this.skipMultiplier = n4;
        this.skipStream[0] = indexInput;
        this.inputIsBuffered = indexInput instanceof BufferedIndexInput;
        this.skipInterval[0] = n3;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.skipInterval[i2] = this.skipInterval[i2 - 1] * n4;
        }
        this.skipDoc = new int[n2];
    }

    protected MultiLevelSkipListReader(IndexInput indexInput, int n2, int n3) {
        this(indexInput, n2, n3, n3);
    }

    public int getDoc() {
        return this.lastDoc;
    }

    public int skipTo(int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < this.numberOfSkipLevels - 1 && n2 > this.skipDoc[n3 + 1]; ++n3) {
        }
        while (n3 >= 0) {
            if (n2 > this.skipDoc[n3]) {
                if (this.loadNextSkip(n3)) continue;
                continue;
            }
            if (n3 > 0 && this.lastChildPointer > this.skipStream[n3 - 1].getFilePointer()) {
                this.seekChild(n3 - 1);
            }
            --n3;
        }
        return this.numSkipped[0] - this.skipInterval[0] - 1;
    }

    private boolean loadNextSkip(int n2) throws IOException {
        this.setLastSkipData(n2);
        int n3 = n2;
        this.numSkipped[n3] = this.numSkipped[n3] + this.skipInterval[n2];
        if (this.numSkipped[n2] > this.docCount) {
            this.skipDoc[n2] = Integer.MAX_VALUE;
            if (this.numberOfSkipLevels > n2) {
                this.numberOfSkipLevels = n2;
            }
            return false;
        }
        int n4 = n2;
        this.skipDoc[n4] = this.skipDoc[n4] + this.readSkipData(n2, this.skipStream[n2]);
        if (n2 != 0) {
            this.childPointer[n2] = this.skipStream[n2].readVLong() + this.skipPointer[n2 - 1];
        }
        return true;
    }

    protected void seekChild(int n2) throws IOException {
        this.skipStream[n2].seek(this.lastChildPointer);
        this.numSkipped[n2] = this.numSkipped[n2 + 1] - this.skipInterval[n2 + 1];
        this.skipDoc[n2] = this.lastDoc;
        if (n2 > 0) {
            this.childPointer[n2] = this.skipStream[n2].readVLong() + this.skipPointer[n2 - 1];
        }
    }

    @Override
    public void close() throws IOException {
        for (int i2 = 1; i2 < this.skipStream.length; ++i2) {
            if (this.skipStream[i2] == null) continue;
            this.skipStream[i2].close();
        }
    }

    public void init(long l2, int n2) throws IOException {
        this.skipPointer[0] = l2;
        this.docCount = n2;
        assert (l2 >= 0L && l2 <= this.skipStream[0].length()) : "invalid skip pointer: " + l2 + ", length=" + this.skipStream[0].length();
        Arrays.fill(this.skipDoc, 0);
        Arrays.fill(this.numSkipped, 0);
        Arrays.fill(this.childPointer, 0L);
        for (int i2 = 1; i2 < this.numberOfSkipLevels; ++i2) {
            this.skipStream[i2] = null;
        }
        this.loadSkipLevels();
    }

    private void loadSkipLevels() throws IOException {
        this.numberOfSkipLevels = this.docCount <= this.skipInterval[0] ? 1 : 1 + g.a((long)(this.docCount / this.skipInterval[0]), this.skipMultiplier);
        if (this.numberOfSkipLevels > this.maxNumberOfSkipLevels) {
            this.numberOfSkipLevels = this.maxNumberOfSkipLevels;
        }
        this.skipStream[0].seek(this.skipPointer[0]);
        int n2 = this.numberOfLevelsToBuffer;
        for (int i2 = this.numberOfSkipLevels - 1; i2 > 0; --i2) {
            long l2 = this.skipStream[0].readVLong();
            this.skipPointer[i2] = this.skipStream[0].getFilePointer();
            if (n2 > 0) {
                this.skipStream[i2] = new SkipBuffer(this.skipStream[0], (int)l2);
                --n2;
                continue;
            }
            this.skipStream[i2] = this.skipStream[0].clone();
            if (this.inputIsBuffered && l2 < 1024L) {
                ((BufferedIndexInput)this.skipStream[i2]).setBufferSize(Math.max(8, (int)l2));
            }
            this.skipStream[0].seek(this.skipStream[0].getFilePointer() + l2);
        }
        this.skipPointer[0] = this.skipStream[0].getFilePointer();
    }

    protected abstract int readSkipData(int var1, IndexInput var2) throws IOException;

    protected void setLastSkipData(int n2) {
        this.lastDoc = this.skipDoc[n2];
        this.lastChildPointer = this.childPointer[n2];
    }

    private static final class SkipBuffer
    extends IndexInput {
        private byte[] data;
        private long pointer;
        private int pos;

        SkipBuffer(IndexInput indexInput, int n2) throws IOException {
            super("SkipBuffer on " + indexInput);
            this.data = new byte[n2];
            this.pointer = indexInput.getFilePointer();
            indexInput.readBytes(this.data, 0, n2);
        }

        @Override
        public void close() {
            this.data = null;
        }

        @Override
        public long getFilePointer() {
            return this.pointer + (long)this.pos;
        }

        @Override
        public long length() {
            return this.data.length;
        }

        @Override
        public byte readByte() {
            return this.data[this.pos++];
        }

        @Override
        public void readBytes(byte[] byArray, int n2, int n3) {
            System.arraycopy(this.data, this.pos, byArray, n2, n3);
            this.pos += n3;
        }

        @Override
        public void seek(long l2) {
            this.pos = (int)(l2 - this.pointer);
        }

        @Override
        public IndexInput slice(String string, long l2, long l3) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

