/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

class AutoPrefixTermsWriter {
    final List<PrefixTerm> prefixes = new ArrayList<PrefixTerm>();
    private final int minItemsInPrefix;
    private final int maxItemsInPrefix;
    private final BytesRefBuilder lastTerm = new BytesRefBuilder();
    private int[] prefixStarts = new int[8];
    private List<Object> pending = new ArrayList<Object>();

    static String brToString(BytesRef bytesRef) {
        try {
            return bytesRef.utf8ToString() + " " + bytesRef;
        }
        catch (Throwable throwable) {
            return bytesRef.toString();
        }
    }

    public AutoPrefixTermsWriter(Terms terms, int n2, int n3) throws IOException {
        BytesRef bytesRef;
        this.minItemsInPrefix = n2;
        this.maxItemsInPrefix = n3;
        TermsEnum termsEnum = terms.iterator();
        while ((bytesRef = termsEnum.next()) != null) {
            this.pushTerm(bytesRef);
        }
        if (this.pending.size() > 1) {
            this.pushTerm(BlockTreeTermsWriter.EMPTY_BYTES_REF);
            while (this.pending.size() >= n2) {
                this.savePrefixes(0, this.pending.size());
            }
        }
        Collections.sort(this.prefixes);
    }

    private void pushTerm(BytesRef bytesRef) throws IOException {
        int n2;
        int n3;
        int n4 = Math.min(this.lastTerm.length(), bytesRef.length);
        for (n3 = 0; n3 < n4 && this.lastTerm.byteAt(n3) == bytesRef.bytes[bytesRef.offset + n3]; ++n3) {
        }
        for (n2 = this.lastTerm.length() - 1; n2 >= n3; --n2) {
            int n5 = this.pending.size() - this.prefixStarts[n2];
            while (n5 >= this.minItemsInPrefix) {
                this.savePrefixes(n2 + 1, n5);
                n5 = this.pending.size() - this.prefixStarts[n2];
            }
        }
        if (this.prefixStarts.length < bytesRef.length) {
            this.prefixStarts = ArrayUtil.grow(this.prefixStarts, bytesRef.length);
        }
        for (n2 = n3; n2 < bytesRef.length; ++n2) {
            this.prefixStarts[n2] = this.pending.size();
        }
        this.lastTerm.copyBytes(bytesRef);
        if (bytesRef.length > 0 || this.pending.isEmpty()) {
            byte[] byArray = new byte[bytesRef.length];
            System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, 0, bytesRef.length);
            this.pending.add(byArray);
        }
    }

    void savePrefixes(int n2, int n3) throws IOException {
        Object object;
        int n4;
        assert (n3 > 0);
        int n5 = -2;
        int n6 = this.pending.size() - n3;
        assert (n6 >= 0);
        Object object2 = this.pending.get(n6);
        boolean bl = false;
        if (object2 instanceof byte[]) {
            if (((byte[])object2).length == n2) {
                ++n6;
                --n3;
                bl = true;
            }
        } else {
            PrefixTerm prefixTerm = (PrefixTerm)object2;
            if (prefixTerm.term.bytes.length == n2) {
                ++n6;
                --n3;
                bl = true;
            }
        }
        int n7 = this.pending.size();
        int n8 = n6;
        int n9 = -1;
        int n10 = 0;
        PrefixTerm prefixTerm = null;
        for (n4 = n6; n4 < n7; ++n4) {
            PrefixTerm prefixTerm2;
            object2 = this.pending.get(n4);
            if (object2 instanceof byte[]) {
                prefixTerm2 = null;
                object = (byte[])object2;
            } else {
                prefixTerm2 = (PrefixTerm)object2;
                object = prefixTerm2.term.bytes;
                if (prefixTerm2.prefix.length != n2) {
                    assert (prefixTerm2.prefix.length > n2);
                    prefixTerm2 = null;
                }
            }
            assert (((byte[])object).length > n2);
            int n11 = object[n2] & 0xFF;
            if (n11 != n5) {
                assert (n11 > n5) : "suffixLeadLabel=" + n11 + " vs lastSuffixLeadLabel=" + n5;
                int n12 = n4 - n8;
                if (n12 >= this.minItemsInPrefix && n7 - n8 > this.maxItemsInPrefix) {
                    if (prefixTerm != null) {
                        n5 = prefixTerm.floorLeadEnd;
                    }
                    this.savePrefix(n2, n9, n5);
                    ++n10;
                    n9 = n11;
                    n8 = n4;
                }
                if (n9 == -1) {
                    n9 = n11;
                }
                n5 = n11;
            }
            prefixTerm = prefixTerm2;
        }
        if (n8 < n7) {
            if (prefixTerm != null) {
                n5 = prefixTerm.floorLeadEnd;
            }
            assert (n5 >= n9) : "lastSuffixLeadLabel=" + n5 + " nextFloorLeadLabel=" + n9;
            if (n10 == 0) {
                if (n2 > 0) {
                    this.savePrefix(n2, -2, 255);
                    ++n10;
                    if (bl) {
                        ++n3;
                    }
                }
            } else {
                if (n5 == -2) {
                    n5 = 255;
                }
                this.savePrefix(n2, n9, n5);
                ++n10;
            }
        }
        this.pending.subList(this.pending.size() - n3, this.pending.size()).clear();
        for (n4 = 0; n4 < n10; ++n4) {
            object = this.prefixes.get(this.prefixes.size() - (n10 - n4));
            this.pending.add(object);
        }
    }

    private void savePrefix(int n2, int n3, int n4) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.lastTerm.bytes(), 0, byArray, 0, n2);
        assert (n3 != -1);
        assert (n4 != -1);
        PrefixTerm prefixTerm = new PrefixTerm(byArray, n3, n4);
        this.prefixes.add(prefixTerm);
    }

    public static final class PrefixTerm
    implements Comparable<PrefixTerm> {
        public final byte[] prefix;
        public final int floorLeadStart;
        public final int floorLeadEnd;
        public final BytesRef term;

        public PrefixTerm(byte[] byArray, int n2, int n3) {
            this.prefix = byArray;
            this.floorLeadStart = n2;
            this.floorLeadEnd = n3;
            this.term = PrefixTerm.toBytesRef(byArray, n2);
            assert (n3 >= n2);
            assert (n3 >= 0);
            assert (n2 == -2 || n2 >= 0);
            assert (byArray.length > 0 || n2 != -2 || n3 != 255);
        }

        public String toString() {
            String string = AutoPrefixTermsWriter.brToString(new BytesRef(this.prefix));
            string = this.floorLeadStart == -2 ? string + "[-" + Integer.toHexString(this.floorLeadEnd) + "]" : string + "[" + Integer.toHexString(this.floorLeadStart) + "-" + Integer.toHexString(this.floorLeadEnd) + "]";
            return string;
        }

        @Override
        public int compareTo(PrefixTerm prefixTerm) {
            int n2 = this.term.compareTo(prefixTerm.term);
            if (n2 == 0) {
                if (this.prefix.length != prefixTerm.prefix.length) {
                    return this.prefix.length - prefixTerm.prefix.length;
                }
                n2 = prefixTerm.floorLeadEnd - this.floorLeadEnd;
            }
            return n2;
        }

        private static BytesRef toBytesRef(byte[] byArray, int n2) {
            BytesRef bytesRef;
            if (n2 != -2) {
                assert (n2 >= 0);
                bytesRef = new BytesRef(byArray.length + 1);
            } else {
                bytesRef = new BytesRef(byArray.length);
            }
            System.arraycopy(byArray, 0, bytesRef.bytes, 0, byArray.length);
            bytesRef.length = byArray.length;
            if (n2 != -2) {
                assert (n2 >= 0);
                bytesRef.bytes[bytesRef.length++] = (byte)n2;
            }
            return bytesRef;
        }

        @Override
        public int compareTo(BytesRef bytesRef) {
            return this.term.compareTo(bytesRef);
        }

        public TermsEnum getTermsEnum(TermsEnum termsEnum) {
            final BytesRef bytesRef = new BytesRef(this.prefix);
            return new FilteredTermsEnum(termsEnum){
                {
                    super(termsEnum);
                    this.setInitialSeekTerm(term);
                }

                @Override
                protected FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef2) {
                    if (StringHelper.startsWith(bytesRef2, bytesRef) && (floorLeadEnd == -1 || bytesRef2.length == bytesRef.length || (bytesRef2.bytes[bytesRef2.offset + bytesRef.length] & 0xFF) <= floorLeadEnd)) {
                        return FilteredTermsEnum.AcceptStatus.YES;
                    }
                    return FilteredTermsEnum.AcceptStatus.END;
                }
            };
        }
    }
}

