/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blocktree.AutoPrefixTermsWriter;
import org.apache.lucene.codecs.blocktree.BitSetTermsEnum;
import org.apache.lucene.codecs.d;
import org.apache.lucene.codecs.k;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public final class BlockTreeTermsWriter
extends d {
    private final IndexOutput termsOut;
    private final IndexOutput indexOut;
    final int maxDoc;
    final int minItemsInBlock;
    final int maxItemsInBlock;
    final int minItemsInAutoPrefix;
    final int maxItemsInAutoPrefix;
    final k postingsWriter;
    final FieldInfos fieldInfos;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();
    final FixedBitSet prefixDocs;
    final BitSetTermsEnum prefixFixedBitsTermsEnum;
    private TermsEnum prefixTermsEnum;
    private PostingsEnum prefixDocsEnum;
    private final RAMOutputStream scratchBytes = new RAMOutputStream();
    private final IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
    static final BytesRef EMPTY_BYTES_REF = new BytesRef();
    private boolean closed;

    public BlockTreeTermsWriter(SegmentWriteState segmentWriteState, k k2, int n2, int n3) throws IOException {
        this(segmentWriteState, k2, n2, n3, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTreeTermsWriter(SegmentWriteState segmentWriteState, k k2, int n2, int n3, int n4, int n5) throws IOException {
        BlockTreeTermsWriter.validateSettings(n2, n3);
        this.minItemsInBlock = n2;
        this.maxItemsInBlock = n3;
        BlockTreeTermsWriter.validateAutoPrefixSettings(n4, n5);
        if (n4 != 0) {
            this.prefixDocs = new FixedBitSet(segmentWriteState.segmentInfo.maxDoc());
            this.prefixFixedBitsTermsEnum = new BitSetTermsEnum(this.prefixDocs);
        } else {
            this.prefixDocs = null;
            this.prefixFixedBitsTermsEnum = null;
        }
        this.minItemsInAutoPrefix = n4;
        this.maxItemsInAutoPrefix = n5;
        this.maxDoc = segmentWriteState.segmentInfo.maxDoc();
        this.fieldInfos = segmentWriteState.fieldInfos;
        this.postingsWriter = k2;
        String string = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, "tim");
        this.termsOut = segmentWriteState.directory.createOutput(string, segmentWriteState.context);
        boolean bl = false;
        IndexOutput indexOutput = null;
        try {
            CodecUtil.writeIndexHeader(this.termsOut, "BlockTreeTermsDict", 2, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            if (n4 == 0) {
                this.termsOut.writeByte((byte)0);
            } else {
                this.termsOut.writeByte((byte)1);
            }
            String string2 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, "tip");
            indexOutput = segmentWriteState.directory.createOutput(string2, segmentWriteState.context);
            CodecUtil.writeIndexHeader(indexOutput, "BlockTreeTermsIndex", 2, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            k2.init(this.termsOut, segmentWriteState);
            this.indexOut = indexOutput;
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.termsOut, indexOutput);
            throw throwable;
        }
    }

    private void writeTrailer(IndexOutput indexOutput, long l2) throws IOException {
        indexOutput.writeLong(l2);
    }

    private void writeIndexTrailer(IndexOutput indexOutput, long l2) throws IOException {
        indexOutput.writeLong(l2);
    }

    public static void validateSettings(int n2, int n3) {
        if (n2 <= 1) {
            throw new IllegalArgumentException("minItemsInBlock must be >= 2; got " + n2);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("maxItemsInBlock must be >= minItemsInBlock; got maxItemsInBlock=" + n3 + " minItemsInBlock=" + n2);
        }
        if (2 * (n2 - 1) > n3) {
            throw new IllegalArgumentException("maxItemsInBlock must be at least 2*(minItemsInBlock-1); got maxItemsInBlock=" + n3 + " minItemsInBlock=" + n2);
        }
    }

    public static void validateAutoPrefixSettings(int n2, int n3) {
        if (n2 != 0) {
            if (n2 < 2) {
                throw new IllegalArgumentException("minItemsInAutoPrefix must be at least 2; got minItemsInAutoPrefix=" + n2);
            }
            if (n2 > n3) {
                throw new IllegalArgumentException("maxItemsInAutoPrefix must be >= minItemsInAutoPrefix; got maxItemsInAutoPrefix=" + n3 + " minItemsInAutoPrefix=" + n2);
            }
            if (2 * (n2 - 1) > n3) {
                throw new IllegalArgumentException("maxItemsInAutoPrefix must be at least 2*(minItemsInAutoPrefix-1); got maxItemsInAutoPrefix=" + n3 + " minItemsInAutoPrefix=" + n2);
            }
        } else if (n3 != 0) {
            throw new IllegalArgumentException("maxItemsInAutoPrefix must be 0 (disabled) when minItemsInAutoPrefix is 0");
        }
    }

    @Override
    public void write(Fields fields) throws IOException {
        String string = null;
        for (String string2 : fields) {
            List<AutoPrefixTermsWriter.PrefixTerm> list;
            assert (string == null || string.compareTo(string2) < 0);
            string = string2;
            Terms terms = fields.terms(string2);
            if (terms == null) continue;
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(string2);
            if (this.minItemsInAutoPrefix != 0) {
                if (fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                    throw new IllegalStateException("ranges can only be indexed with IndexOptions.DOCS (field: " + fieldInfo.name + ")");
                }
                list = new AutoPrefixTermsWriter((Terms)terms, (int)this.minItemsInAutoPrefix, (int)this.maxItemsInAutoPrefix).prefixes;
            } else {
                list = null;
            }
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(this.fieldInfos.fieldInfo(string2));
            int n2 = 0;
            while (true) {
                BytesRef bytesRef = termsEnum.next();
                if (list != null) {
                    while (n2 < list.size() && (bytesRef == null || list.get(n2).compareTo(bytesRef) <= 0)) {
                        AutoPrefixTermsWriter.PrefixTerm prefixTerm = list.get(n2);
                        termsWriter.write(prefixTerm.term, this.getAutoPrefixTermsEnum(terms, prefixTerm), prefixTerm);
                        ++n2;
                    }
                }
                if (bytesRef == null) break;
                termsWriter.write(bytesRef, termsEnum, null);
            }
            assert (list == null || n2 == list.size());
            termsWriter.finish();
        }
    }

    private TermsEnum getAutoPrefixTermsEnum(Terms terms, AutoPrefixTermsWriter.PrefixTerm prefixTerm) throws IOException {
        assert (this.prefixDocs != null);
        this.prefixDocs.clear(0, this.prefixDocs.length());
        this.prefixTermsEnum = prefixTerm.getTermsEnum(terms.iterator());
        while (this.prefixTermsEnum.next() != null) {
            this.prefixDocsEnum = this.prefixTermsEnum.postings(this.prefixDocsEnum, 0);
            this.prefixDocs.or(this.prefixDocsEnum);
        }
        return this.prefixFixedBitsTermsEnum;
    }

    static long encodeOutput(long l2, boolean bl, boolean bl2) {
        assert (l2 < 0x4000000000000000L);
        return l2 << 2 | (long)(bl ? 2 : 0) | (long)(bl2 ? 1 : 0);
    }

    static String brToString(BytesRef bytesRef) {
        if (bytesRef == null) {
            return "(null)";
        }
        try {
            return bytesRef.utf8ToString() + " " + bytesRef;
        }
        catch (Throwable throwable) {
            return bytesRef.toString();
        }
    }

    static String brToString(byte[] byArray) {
        return BlockTreeTermsWriter.brToString(new BytesRef(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block10: {
            block9: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                boolean bl = false;
                try {
                    long l2 = this.termsOut.getFilePointer();
                    long l3 = this.indexOut.getFilePointer();
                    this.termsOut.writeVInt(this.fields.size());
                    for (FieldMetaData fieldMetaData : this.fields) {
                        this.termsOut.writeVInt(fieldMetaData.fieldInfo.number);
                        assert (fieldMetaData.numTerms > 0L);
                        this.termsOut.writeVLong(fieldMetaData.numTerms);
                        this.termsOut.writeVInt(fieldMetaData.rootCode.length);
                        this.termsOut.writeBytes(fieldMetaData.rootCode.bytes, fieldMetaData.rootCode.offset, fieldMetaData.rootCode.length);
                        assert (fieldMetaData.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                        if (fieldMetaData.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            this.termsOut.writeVLong(fieldMetaData.sumTotalTermFreq);
                        }
                        this.termsOut.writeVLong(fieldMetaData.sumDocFreq);
                        this.termsOut.writeVInt(fieldMetaData.docCount);
                        this.termsOut.writeVInt(fieldMetaData.longsSize);
                        this.indexOut.writeVLong(fieldMetaData.indexStartFP);
                        BlockTreeTermsWriter.writeBytesRef(this.termsOut, fieldMetaData.minTerm);
                        BlockTreeTermsWriter.writeBytesRef(this.termsOut, fieldMetaData.maxTerm);
                    }
                    this.writeTrailer(this.termsOut, l2);
                    CodecUtil.writeFooter(this.termsOut);
                    this.writeIndexTrailer(this.indexOut, l3);
                    CodecUtil.writeFooter(this.indexOut);
                    bl = true;
                    if (!bl) break block9;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(this.termsOut, this.indexOut, this.postingsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(this.termsOut, this.indexOut, this.postingsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(this.termsOut, this.indexOut, this.postingsWriter);
                break block10;
            }
            IOUtils.closeWhileHandlingException(this.termsOut, this.indexOut, this.postingsWriter);
        }
    }

    private static void writeBytesRef(IndexOutput indexOutput, BytesRef bytesRef) throws IOException {
        indexOutput.writeVInt(bytesRef.length);
        indexOutput.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms;
        final FixedBitSet docsSeen;
        long sumTotalTermFreq;
        long sumDocFreq;
        long indexStartFP;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private int[] prefixStarts = new int[8];
        private final long[] longs;
        private final List<PendingEntry> pending = new ArrayList<PendingEntry>();
        private final List<PendingBlock> newBlocks = new ArrayList<PendingBlock>();
        private PendingTerm firstPendingTerm;
        private PendingTerm lastPendingTerm;
        private final RAMOutputStream suffixWriter = new RAMOutputStream();
        private final RAMOutputStream statsWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();

        void writeBlocks(int n2, int n3) throws IOException {
            int n4;
            assert (n3 > 0);
            assert (n2 > 0 || n3 == this.pending.size());
            int n5 = -1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n6 = this.pending.size() - n3;
            int n7 = this.pending.size();
            int n8 = n6;
            int n9 = -1;
            for (n4 = n6; n4 < n7; ++n4) {
                int n10;
                PendingEntry pendingEntry;
                PendingEntry pendingEntry2 = this.pending.get(n4);
                if (pendingEntry2.isTerm) {
                    pendingEntry = (PendingTerm)pendingEntry2;
                    if (pendingEntry.termBytes.length == n2) {
                        assert (n5 == -1) : "i=" + n4 + " lastSuffixLeadLabel=" + n5;
                        n10 = -1;
                    } else {
                        n10 = pendingEntry.termBytes[n2] & 0xFF;
                    }
                } else {
                    pendingEntry = (PendingBlock)pendingEntry2;
                    assert (((PendingBlock)pendingEntry).prefix.length > n2);
                    n10 = ((PendingBlock)pendingEntry).prefix.bytes[((PendingBlock)pendingEntry).prefix.offset + n2] & 0xFF;
                }
                if (n10 != n5) {
                    int n11 = n4 - n8;
                    if (n11 >= BlockTreeTermsWriter.this.minItemsInBlock && n7 - n8 > BlockTreeTermsWriter.this.maxItemsInBlock) {
                        boolean bl4 = n11 < n3;
                        this.newBlocks.add(this.writeBlock(n2, bl4, n9, n8, n4, bl, bl2, bl3));
                        bl = false;
                        bl3 = false;
                        bl2 = false;
                        n9 = n10;
                        n8 = n4;
                    }
                    n5 = n10;
                }
                if (pendingEntry2.isTerm) {
                    bl = true;
                    bl2 |= ((PendingTerm)pendingEntry2).prefixTerm != null;
                    continue;
                }
                bl3 = true;
            }
            if (n8 < n7) {
                n4 = n7 - n8;
                boolean bl5 = n4 < n3;
                this.newBlocks.add(this.writeBlock(n2, bl5, n9, n8, n7, bl, bl2, bl3));
            }
            assert (!this.newBlocks.isEmpty());
            PendingBlock pendingBlock = this.newBlocks.get(0);
            assert (pendingBlock.isFloor || this.newBlocks.size() == 1);
            pendingBlock.compileIndex(this.newBlocks, BlockTreeTermsWriter.this.scratchBytes, BlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - n3, this.pending.size()).clear();
            this.pending.add(pendingBlock);
            this.newBlocks.clear();
        }

        private PendingBlock writeBlock(int n2, boolean bl, int n3, int n4, int n5, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            ArrayList<FST<BytesRef>> arrayList;
            assert (n5 > n4);
            long l2 = BlockTreeTermsWriter.this.termsOut.getFilePointer();
            boolean bl5 = bl && n3 != -1;
            BytesRef bytesRef = new BytesRef(n2 + (bl5 ? 1 : 0));
            System.arraycopy(this.lastTerm.get().bytes, 0, bytesRef.bytes, 0, n2);
            bytesRef.length = n2;
            int n6 = n5 - n4;
            int n7 = n6 << 1;
            if (n5 == this.pending.size()) {
                n7 |= 1;
            }
            BlockTreeTermsWriter.this.termsOut.writeVInt(n7);
            boolean bl6 = !bl4 && !bl3;
            boolean bl7 = true;
            if (bl6) {
                arrayList = null;
                for (int i2 = n4; i2 < n5; ++i2) {
                    PendingEntry pendingEntry = this.pending.get(i2);
                    assert (pendingEntry.isTerm) : "i=" + i2;
                    PendingTerm pendingTerm = (PendingTerm)pendingEntry;
                    assert (pendingTerm.prefixTerm == null);
                    assert (StringHelper.startsWith(pendingTerm.termBytes, bytesRef)) : "term.term=" + pendingTerm.termBytes + " prefix=" + bytesRef;
                    BlockTermState blockTermState = pendingTerm.state;
                    int n8 = pendingTerm.termBytes.length - n2;
                    this.suffixWriter.writeVInt(n8);
                    this.suffixWriter.writeBytes(pendingTerm.termBytes, n2, n8);
                    assert (n3 == -1 || (pendingTerm.termBytes[n2] & 0xFF) >= n3);
                    this.statsWriter.writeVInt(blockTermState.docFreq);
                    if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                        assert (blockTermState.totalTermFreq >= (long)blockTermState.docFreq) : blockTermState.totalTermFreq + " vs " + blockTermState.docFreq;
                        this.statsWriter.writeVLong(blockTermState.totalTermFreq - (long)blockTermState.docFreq);
                    }
                    BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, this.bytesWriter, this.fieldInfo, blockTermState, bl7);
                    for (int i3 = 0; i3 < this.longsSize; ++i3) {
                        assert (this.longs[i3] >= 0L);
                        this.metaWriter.writeVLong(this.longs[i3]);
                    }
                    this.bytesWriter.writeTo(this.metaWriter);
                    this.bytesWriter.reset();
                    bl7 = false;
                }
            } else {
                arrayList = new ArrayList<FST<BytesRef>>();
                boolean bl8 = false;
                for (int i4 = n4; i4 < n5; ++i4) {
                    PendingEntry pendingEntry;
                    PendingEntry pendingEntry2 = this.pending.get(i4);
                    if (pendingEntry2.isTerm) {
                        int n9;
                        pendingEntry = (PendingTerm)pendingEntry2;
                        assert (StringHelper.startsWith(pendingEntry.termBytes, bytesRef)) : "term.term=" + pendingEntry.termBytes + " prefix=" + bytesRef;
                        BlockTermState blockTermState = pendingEntry.state;
                        int n10 = pendingEntry.termBytes.length - n2;
                        if (BlockTreeTermsWriter.this.minItemsInAutoPrefix == 0) {
                            this.suffixWriter.writeVInt(n10 << 1);
                            this.suffixWriter.writeBytes(pendingEntry.termBytes, n2, n10);
                        } else {
                            n7 = n10 << 2;
                            n9 = -1;
                            if (pendingEntry.prefixTerm != null) {
                                assert (BlockTreeTermsWriter.this.minItemsInAutoPrefix > 0);
                                bl8 = true;
                                AutoPrefixTermsWriter.PrefixTerm prefixTerm = pendingEntry.prefixTerm;
                                n9 = prefixTerm.floorLeadEnd;
                                assert (n9 != -1);
                                n7 = prefixTerm.floorLeadStart == -2 ? (n7 |= 2) : (n7 |= 3);
                            }
                            this.suffixWriter.writeVInt(n7);
                            this.suffixWriter.writeBytes(pendingEntry.termBytes, n2, n10);
                            if (n9 != -1) {
                                this.suffixWriter.writeByte((byte)n9);
                            }
                            assert (n3 == -1 || (pendingEntry.termBytes[n2] & 0xFF) >= n3);
                        }
                        this.statsWriter.writeVInt(blockTermState.docFreq);
                        if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            assert (blockTermState.totalTermFreq >= (long)blockTermState.docFreq);
                            this.statsWriter.writeVLong(blockTermState.totalTermFreq - (long)blockTermState.docFreq);
                        }
                        BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, this.bytesWriter, this.fieldInfo, blockTermState, bl7);
                        for (n9 = 0; n9 < this.longsSize; ++n9) {
                            assert (this.longs[n9] >= 0L);
                            this.metaWriter.writeVLong(this.longs[n9]);
                        }
                        this.bytesWriter.writeTo(this.metaWriter);
                        this.bytesWriter.reset();
                        bl7 = false;
                        continue;
                    }
                    pendingEntry = (PendingBlock)pendingEntry2;
                    assert (StringHelper.startsWith(((PendingBlock)pendingEntry).prefix, bytesRef));
                    int n11 = ((PendingBlock)pendingEntry).prefix.length - n2;
                    assert (StringHelper.startsWith(((PendingBlock)pendingEntry).prefix, bytesRef));
                    assert (n11 > 0);
                    if (BlockTreeTermsWriter.this.minItemsInAutoPrefix == 0) {
                        this.suffixWriter.writeVInt(n11 << 1 | 1);
                    } else {
                        this.suffixWriter.writeVInt(n11 << 2 | 1);
                    }
                    this.suffixWriter.writeBytes(((PendingBlock)pendingEntry).prefix.bytes, n2, n11);
                    assert (n3 == -1 || (((PendingBlock)pendingEntry).prefix.bytes[n2] & 0xFF) >= n3) : "floorLeadLabel=" + n3 + " suffixLead=" + (((PendingBlock)pendingEntry).prefix.bytes[n2] & 0xFF);
                    assert (((PendingBlock)pendingEntry).fp < l2);
                    this.suffixWriter.writeVLong(l2 - ((PendingBlock)pendingEntry).fp);
                    arrayList.add(((PendingBlock)pendingEntry).index);
                }
                assert (arrayList.size() != 0 || bl8);
            }
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)(this.suffixWriter.getFilePointer() << 1) | (bl6 ? 1 : 0));
            this.suffixWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.suffixWriter.reset();
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.statsWriter.getFilePointer());
            this.statsWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.statsWriter.reset();
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.metaWriter.getFilePointer());
            this.metaWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.metaWriter.reset();
            if (bl5) {
                bytesRef.bytes[bytesRef.length++] = (byte)n3;
            }
            return new PendingBlock(bytesRef, l2, bl2, bl, n3, arrayList);
        }

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            assert (fieldInfo.getIndexOptions() != IndexOptions.NONE);
            this.docsSeen = new FixedBitSet(BlockTreeTermsWriter.this.maxDoc);
            this.longsSize = BlockTreeTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.longs = new long[this.longsSize];
        }

        public void write(BytesRef bytesRef, TermsEnum termsEnum, AutoPrefixTermsWriter.PrefixTerm prefixTerm) throws IOException {
            BlockTermState blockTermState = BlockTreeTermsWriter.this.postingsWriter.writeTerm(bytesRef, termsEnum, this.docsSeen);
            if (blockTermState != null) {
                assert (blockTermState.docFreq != 0);
                assert (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || blockTermState.totalTermFreq >= (long)blockTermState.docFreq) : "postingsWriter=" + BlockTreeTermsWriter.this.postingsWriter;
                this.pushTerm(bytesRef);
                PendingTerm pendingTerm = new PendingTerm(bytesRef, blockTermState, prefixTerm);
                this.pending.add(pendingTerm);
                if (prefixTerm == null) {
                    this.sumDocFreq += (long)blockTermState.docFreq;
                    this.sumTotalTermFreq += blockTermState.totalTermFreq;
                    ++this.numTerms;
                    if (this.firstPendingTerm == null) {
                        this.firstPendingTerm = pendingTerm;
                    }
                    this.lastPendingTerm = pendingTerm;
                }
            }
        }

        private void pushTerm(BytesRef bytesRef) throws IOException {
            int n2;
            int n3;
            int n4 = Math.min(this.lastTerm.length(), bytesRef.length);
            for (n3 = 0; n3 < n4 && this.lastTerm.byteAt(n3) == bytesRef.bytes[bytesRef.offset + n3]; ++n3) {
            }
            for (n2 = this.lastTerm.length() - 1; n2 >= n3; --n2) {
                int n5 = this.pending.size() - this.prefixStarts[n2];
                if (n5 < BlockTreeTermsWriter.this.minItemsInBlock) continue;
                this.writeBlocks(n2 + 1, n5);
                int n6 = n2;
                this.prefixStarts[n6] = this.prefixStarts[n6] - (n5 - 1);
            }
            if (this.prefixStarts.length < bytesRef.length) {
                this.prefixStarts = ArrayUtil.grow(this.prefixStarts, bytesRef.length);
            }
            for (n2 = n3; n2 < bytesRef.length; ++n2) {
                this.prefixStarts[n2] = this.pending.size();
            }
            this.lastTerm.copyBytes(bytesRef);
        }

        public void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.pushTerm(new BytesRef());
                this.pushTerm(new BytesRef());
                this.writeBlocks(0, this.pending.size());
                assert (this.pending.size() == 1 && !this.pending.get((int)0).isTerm) : "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                PendingBlock pendingBlock = (PendingBlock)this.pending.get(0);
                assert (pendingBlock.prefix.length == 0);
                assert (pendingBlock.index.getEmptyOutput() != null);
                this.indexStartFP = BlockTreeTermsWriter.this.indexOut.getFilePointer();
                pendingBlock.index.save(BlockTreeTermsWriter.this.indexOut);
                assert (this.firstPendingTerm != null);
                BytesRef bytesRef = new BytesRef(this.firstPendingTerm.termBytes);
                assert (this.lastPendingTerm != null);
                BytesRef bytesRef2 = new BytesRef(this.lastPendingTerm.termBytes);
                BlockTreeTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, ((PendingBlock)this.pending.get((int)0)).index.getEmptyOutput(), this.numTerms, this.indexStartFP, this.sumTotalTermFreq, this.sumDocFreq, this.docsSeen.cardinality(), this.longsSize, bytesRef, bytesRef2));
            } else {
                assert (this.sumTotalTermFreq == 0L || this.fieldInfo.getIndexOptions() == IndexOptions.DOCS && this.sumTotalTermFreq == -1L);
                assert (this.sumDocFreq == 0L);
                assert (this.docsSeen.cardinality() == 0);
            }
        }
    }

    private static final class PendingBlock
    extends PendingEntry {
        public final BytesRef prefix;
        public final long fp;
        public FST<BytesRef> index;
        public List<FST<BytesRef>> subIndices;
        public final boolean hasTerms;
        public final boolean isFloor;
        public final int floorLeadByte;

        public PendingBlock(BytesRef bytesRef, long l2, boolean bl, boolean bl2, int n2, List<FST<BytesRef>> list) {
            super(false);
            this.prefix = bytesRef;
            this.fp = l2;
            this.hasTerms = bl;
            this.isFloor = bl2;
            this.floorLeadByte = n2;
            this.subIndices = list;
        }

        public String toString() {
            return "BLOCK: prefix=" + BlockTreeTermsWriter.brToString(this.prefix);
        }

        public void compileIndex(List<PendingBlock> list, RAMOutputStream rAMOutputStream, IntsRefBuilder intsRefBuilder) throws IOException {
            Object object;
            assert (this.isFloor && list.size() > 1 || !this.isFloor && list.size() == 1) : "isFloor=" + this.isFloor + " blocks=" + list;
            assert (this == list.get(0));
            assert (rAMOutputStream.getFilePointer() == 0L);
            rAMOutputStream.writeVLong(BlockTreeTermsWriter.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            if (this.isFloor) {
                rAMOutputStream.writeVInt(list.size() - 1);
                for (int i2 = 1; i2 < list.size(); ++i2) {
                    object = list.get(i2);
                    assert (((PendingBlock)object).floorLeadByte != -1);
                    rAMOutputStream.writeByte((byte)((PendingBlock)object).floorLeadByte);
                    assert (((PendingBlock)object).fp > this.fp);
                    rAMOutputStream.writeVLong(((PendingBlock)object).fp - this.fp << 1 | (long)(((PendingBlock)object).hasTerms ? 1 : 0));
                }
            }
            ByteSequenceOutputs byteSequenceOutputs = ByteSequenceOutputs.getSingleton();
            object = new Builder<BytesRef>(FST.INPUT_TYPE.BYTE1, 0, 0, true, false, Integer.MAX_VALUE, byteSequenceOutputs, false, 0.0f, true, 15);
            byte[] byArray = new byte[(int)rAMOutputStream.getFilePointer()];
            assert (byArray.length > 0);
            rAMOutputStream.writeTo(byArray, 0);
            ((Builder)object).add(Util.toIntsRef(this.prefix, intsRefBuilder), new BytesRef(byArray, 0, byArray.length));
            rAMOutputStream.reset();
            for (PendingBlock pendingBlock : list) {
                if (pendingBlock.subIndices == null) continue;
                for (FST<BytesRef> fST : pendingBlock.subIndices) {
                    this.append((Builder<BytesRef>)object, fST, intsRefBuilder);
                }
                pendingBlock.subIndices = null;
            }
            this.index = ((Builder)object).finish();
            assert (this.subIndices == null);
        }

        private void append(Builder<BytesRef> builder, FST<BytesRef> fST, IntsRefBuilder intsRefBuilder) throws IOException {
            BytesRefFSTEnum.InputOutput<BytesRef> inputOutput;
            BytesRefFSTEnum<BytesRef> bytesRefFSTEnum = new BytesRefFSTEnum<BytesRef>(fST);
            while ((inputOutput = bytesRefFSTEnum.next()) != null) {
                builder.add(Util.toIntsRef(inputOutput.input, intsRefBuilder), (BytesRef)inputOutput.output);
            }
        }
    }

    private static final class PendingTerm
    extends PendingEntry {
        public final byte[] termBytes;
        public final BlockTermState state;
        public final AutoPrefixTermsWriter.PrefixTerm prefixTerm;

        public PendingTerm(BytesRef bytesRef, BlockTermState blockTermState, AutoPrefixTermsWriter.PrefixTerm prefixTerm) {
            super(true);
            this.termBytes = new byte[bytesRef.length];
            System.arraycopy(bytesRef.bytes, bytesRef.offset, this.termBytes, 0, bytesRef.length);
            this.state = blockTermState;
            this.prefixTerm = prefixTerm;
        }

        public String toString() {
            return "TERM: " + BlockTreeTermsWriter.brToString(this.termBytes);
        }
    }

    private static class PendingEntry {
        public final boolean isTerm;

        protected PendingEntry(boolean bl) {
            this.isTerm = bl;
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final BytesRef rootCode;
        public final long numTerms;
        public final long indexStartFP;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        private final int longsSize;
        public final BytesRef minTerm;
        public final BytesRef maxTerm;

        public FieldMetaData(FieldInfo fieldInfo, BytesRef bytesRef, long l2, long l3, long l4, long l5, int n2, int n3, BytesRef bytesRef2, BytesRef bytesRef3) {
            assert (l2 > 0L);
            this.fieldInfo = fieldInfo;
            assert (bytesRef != null) : "field=" + fieldInfo.name + " numTerms=" + l2;
            this.rootCode = bytesRef;
            this.indexStartFP = l3;
            this.numTerms = l2;
            this.sumTotalTermFreq = l4;
            this.sumDocFreq = l5;
            this.docCount = n2;
            this.longsSize = n3;
            this.minTerm = bytesRef2;
            this.maxTerm = bytesRef3;
        }
    }
}

