/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnumFrame;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.a;

final class IntersectTermsEnum
extends TermsEnum {
    final IndexInput in;
    static final a<BytesRef> fstOutputs = ByteSequenceOutputs.getSingleton();
    IntersectTermsEnumFrame[] stack;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[5];
    final RunAutomaton runAutomaton;
    final Automaton automaton;
    final BytesRef commonSuffix;
    private IntersectTermsEnumFrame currentFrame;
    private Transition currentTransition;
    private final BytesRef term = new BytesRef();
    private final FST.a fstReader;
    private final boolean allowAutoPrefixTerms;
    final FieldReader fr;
    private final int sinkState;
    private BytesRef savedStartTerm;
    private boolean useAutoPrefixTerm;
    private final Transition scratchTransition = new Transition();

    public IntersectTermsEnum(FieldReader fieldReader, Automaton automaton, RunAutomaton runAutomaton, BytesRef bytesRef, BytesRef bytesRef2, int n2) throws IOException {
        int n3;
        this.fr = fieldReader;
        this.sinkState = n2;
        assert (automaton != null);
        assert (runAutomaton != null);
        this.runAutomaton = runAutomaton;
        this.allowAutoPrefixTerms = n2 != -1;
        this.automaton = automaton;
        this.commonSuffix = bytesRef;
        this.in = fieldReader.parent.termsIn.clone();
        this.stack = new IntersectTermsEnumFrame[5];
        for (n3 = 0; n3 < this.stack.length; ++n3) {
            this.stack[n3] = new IntersectTermsEnumFrame(this, n3);
        }
        for (n3 = 0; n3 < this.arcs.length; ++n3) {
            this.arcs[n3] = new FST.Arc();
        }
        this.fstReader = fieldReader.index == null ? null : fieldReader.index.getBytesReader();
        FST.Arc<BytesRef> arc = fieldReader.index.getFirstArc(this.arcs[0]);
        assert (arc.isFinal());
        IntersectTermsEnumFrame intersectTermsEnumFrame = this.stack[0];
        intersectTermsEnumFrame.fp = intersectTermsEnumFrame.fpOrig = fieldReader.rootBlockFP;
        intersectTermsEnumFrame.prefix = 0;
        intersectTermsEnumFrame.setState(runAutomaton.getInitialState());
        intersectTermsEnumFrame.arc = arc;
        intersectTermsEnumFrame.outputPrefix = (BytesRef)arc.output;
        intersectTermsEnumFrame.load(fieldReader.rootCode);
        assert (this.setSavedStartTerm(bytesRef2));
        this.currentFrame = intersectTermsEnumFrame;
        if (bytesRef2 != null) {
            this.seekToStartTerm(bytesRef2);
        }
        this.currentTransition = this.currentFrame.transition;
    }

    private boolean setSavedStartTerm(BytesRef bytesRef) {
        this.savedStartTerm = bytesRef == null ? null : BytesRef.deepCopyOf(bytesRef);
        return true;
    }

    @Override
    public q termState() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.clone();
    }

    private IntersectTermsEnumFrame getFrame(int n2) throws IOException {
        if (n2 >= this.stack.length) {
            IntersectTermsEnumFrame[] intersectTermsEnumFrameArray = new IntersectTermsEnumFrame[ArrayUtil.oversize(1 + n2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, intersectTermsEnumFrameArray, 0, this.stack.length);
            for (int i2 = this.stack.length; i2 < intersectTermsEnumFrameArray.length; ++i2) {
                intersectTermsEnumFrameArray[i2] = new IntersectTermsEnumFrame(this, i2);
            }
            this.stack = intersectTermsEnumFrameArray;
        }
        assert (this.stack[n2].ord == n2);
        return this.stack[n2];
    }

    private FST.Arc<BytesRef> getArc(int n2) {
        if (n2 >= this.arcs.length) {
            FST.Arc[] arcArray = new FST.Arc[ArrayUtil.oversize(1 + n2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, arcArray, 0, this.arcs.length);
            for (int i2 = this.arcs.length; i2 < arcArray.length; ++i2) {
                arcArray[i2] = new FST.Arc();
            }
            this.arcs = arcArray;
        }
        return this.arcs[n2];
    }

    private IntersectTermsEnumFrame pushFrame(int n2) throws IOException {
        assert (this.currentFrame != null);
        IntersectTermsEnumFrame intersectTermsEnumFrame = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord);
        intersectTermsEnumFrame.fp = intersectTermsEnumFrame.fpOrig = this.currentFrame.lastSubFP;
        intersectTermsEnumFrame.prefix = this.currentFrame.prefix + this.currentFrame.suffix;
        intersectTermsEnumFrame.setState(n2);
        FST.Arc<BytesRef> arc = this.currentFrame.arc;
        assert (this.currentFrame.suffix > 0);
        BytesRef bytesRef = this.currentFrame.outputPrefix;
        for (int i2 = this.currentFrame.prefix; i2 < intersectTermsEnumFrame.prefix; ++i2) {
            int n3 = this.term.bytes[i2] & 0xFF;
            arc = this.fr.index.findTargetArc(n3, arc, this.getArc(1 + i2), this.fstReader);
            assert (arc != null);
            bytesRef = fstOutputs.add(bytesRef, (BytesRef)arc.output);
        }
        intersectTermsEnumFrame.arc = arc;
        intersectTermsEnumFrame.outputPrefix = bytesRef;
        assert (arc.isFinal());
        intersectTermsEnumFrame.load(fstOutputs.add(bytesRef, (BytesRef)arc.nextFinalOutput));
        return intersectTermsEnumFrame;
    }

    @Override
    public BytesRef term() {
        return this.term;
    }

    @Override
    public int docFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.termState, postingsEnum, n2);
    }

    private int getState() {
        int n2 = this.currentFrame.state;
        for (int i2 = 0; i2 < this.currentFrame.suffix; ++i2) {
            n2 = this.runAutomaton.step(n2, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i2] & 0xFF);
            assert (n2 != -1);
        }
        return n2;
    }

    private void seekToStartTerm(BytesRef bytesRef) throws IOException {
        assert (this.currentFrame.ord == 0);
        if (this.term.length < bytesRef.length) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, bytesRef.length);
        }
        FST.Arc<BytesRef> arc = this.arcs[0];
        assert (arc == this.currentFrame.arc);
        for (int i2 = 0; i2 <= bytesRef.length; ++i2) {
            block10: {
                boolean bl;
                int n2;
                long l2;
                int n3;
                int n4;
                int n5;
                int n6;
                while (true) {
                    n6 = this.currentFrame.nextEnt;
                    n5 = this.currentFrame.suffixesReader.getPosition();
                    n4 = this.currentFrame.startBytePos;
                    n3 = this.currentFrame.suffix;
                    l2 = this.currentFrame.lastSubFP;
                    n2 = this.currentFrame.termState.termBlockOrd;
                    bl = this.currentFrame.isAutoPrefixTerm;
                    boolean bl2 = this.currentFrame.next();
                    this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                    if (this.term.bytes.length < this.term.length) {
                        this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
                    }
                    System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                    if (bl2 && StringHelper.startsWith(bytesRef, this.term)) break block10;
                    int n7 = this.term.compareTo(bytesRef);
                    if (n7 < 0) {
                        if (this.currentFrame.nextEnt != this.currentFrame.entCount) continue;
                        if (!this.currentFrame.isLastInFloor) {
                            this.currentFrame.loadNextFloorBlock();
                            continue;
                        }
                        return;
                    }
                    if (n7 == 0) {
                        if (!this.allowAutoPrefixTerms && this.currentFrame.isAutoPrefixTerm) continue;
                        return;
                    }
                    if (this.allowAutoPrefixTerms || !this.currentFrame.isAutoPrefixTerm) break;
                }
                this.currentFrame.nextEnt = n6;
                this.currentFrame.lastSubFP = l2;
                this.currentFrame.startBytePos = n4;
                this.currentFrame.suffix = n3;
                this.currentFrame.suffixesReader.setPosition(n5);
                this.currentFrame.termState.termBlockOrd = n2;
                this.currentFrame.isAutoPrefixTerm = bl;
                System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                return;
            }
            this.currentFrame = this.pushFrame(this.getState());
        }
        assert (false);
    }

    private boolean popPushNext() throws IOException {
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                throw NoMoreTermsException.INSTANCE;
            }
            long l2 = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            this.currentTransition = this.currentFrame.transition;
            assert (this.currentFrame.lastSubFP == l2);
        }
        return this.currentFrame.next();
    }

    private boolean skipPastLastAutoPrefixTerm() throws IOException {
        boolean bl;
        block21: {
            assert (this.currentFrame.isAutoPrefixTerm);
            this.useAutoPrefixTerm = false;
            this.currentFrame.termState.isRealTerm = true;
            int n2 = this.currentFrame.floorSuffixLeadEnd;
            if (n2 == -1) {
                int n3 = this.currentFrame.prefix;
                int n4 = this.currentFrame.suffix;
                if (n4 == 0) {
                    if (this.currentFrame.ord == 0) {
                        throw NoMoreTermsException.INSTANCE;
                    }
                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                    this.currentTransition = this.currentFrame.transition;
                    return this.popPushNext();
                }
                block0: while (true) {
                    if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                        if (!this.currentFrame.isLastInFloor) {
                            this.currentFrame.loadNextFloorBlock();
                        } else {
                            if (this.currentFrame.ord == 0) {
                                throw NoMoreTermsException.INSTANCE;
                            }
                            this.currentFrame = this.stack[this.currentFrame.ord - 1];
                            this.currentTransition = this.currentFrame.transition;
                            return this.popPushNext();
                        }
                    }
                    bl = this.currentFrame.next();
                    int n5 = 0;
                    while (true) {
                        if (n5 >= n4) continue block0;
                        if (this.term.bytes[n3 + n5] == this.currentFrame.suffixBytes[this.currentFrame.startBytePos + n5]) {
                            ++n5;
                            continue;
                        }
                        break block21;
                        break;
                    }
                    break;
                }
            }
            int n6 = this.currentFrame.prefix;
            int n7 = this.currentFrame.suffix;
            if (this.currentFrame.floorSuffixLeadStart == -1) {
                ++n7;
            }
            if (n7 == 0) {
                if (this.currentFrame.ord == 0) {
                    throw NoMoreTermsException.INSTANCE;
                }
                this.currentFrame = this.stack[this.currentFrame.ord - 1];
                this.currentTransition = this.currentFrame.transition;
                n6 = this.currentFrame.prefix;
                n7 = this.term.length - this.currentFrame.prefix;
            }
            do {
                if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                    if (!this.currentFrame.isLastInFloor) {
                        this.currentFrame.loadNextFloorBlock();
                    } else {
                        if (this.currentFrame.ord == 0) {
                            throw NoMoreTermsException.INSTANCE;
                        }
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        this.currentTransition = this.currentFrame.transition;
                        return this.popPushNext();
                    }
                }
                bl = this.currentFrame.next();
                for (int i2 = 0; i2 < n7 - 1; ++i2) {
                    if (this.term.bytes[n6 + i2] == this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i2]) {
                        continue;
                    }
                    break block21;
                }
            } while (this.currentFrame.suffix < n7 || (this.currentFrame.suffixBytes[this.currentFrame.startBytePos + n7 - 1] & 0xFF) <= n2);
        }
        return bl;
    }

    @Override
    public BytesRef next() throws IOException {
        try {
            return this._next();
        }
        catch (NoMoreTermsException noMoreTermsException) {
            this.currentFrame = null;
            return null;
        }
    }

    private BytesRef _next() throws IOException {
        boolean bl;
        if (this.useAutoPrefixTerm) {
            bl = this.skipPastLastAutoPrefixTerm();
            assert (!this.useAutoPrefixTerm);
        } else {
            bl = this.popPushNext();
        }
        block0: while (true) {
            int n2;
            int n3;
            assert (this.currentFrame.transition == this.currentTransition);
            if (this.currentFrame.suffix != 0) {
                int n4;
                byte[] byArray = this.currentFrame.suffixBytes;
                int n5 = byArray[this.currentFrame.startBytePos] & 0xFF;
                if (n5 < this.currentTransition.min) {
                    n4 = this.currentTransition.min;
                    while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                        bl = this.currentFrame.next();
                        if ((byArray[this.currentFrame.startBytePos] & 0xFF) < n4) continue;
                        continue block0;
                    }
                    bl = this.popPushNext();
                    continue;
                }
                while (n5 > this.currentTransition.max) {
                    if (this.currentFrame.transitionIndex >= this.currentFrame.transitionCount - 1) {
                        if (this.currentFrame.ord == 0) {
                            this.currentFrame = null;
                            return null;
                        }
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        this.currentTransition = this.currentFrame.transition;
                        bl = this.popPushNext();
                        continue block0;
                    }
                    ++this.currentFrame.transitionIndex;
                    this.automaton.getNextTransition(this.currentTransition);
                    if (n5 >= this.currentTransition.min) continue;
                    n4 = this.currentTransition.min;
                    while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                        bl = this.currentFrame.next();
                        if ((byArray[this.currentFrame.startBytePos] & 0xFF) < n4) continue;
                        continue block0;
                    }
                    bl = this.popPushNext();
                    continue block0;
                }
                if (this.commonSuffix != null && !bl) {
                    int n6;
                    n4 = this.currentFrame.prefix + this.currentFrame.suffix;
                    if (n4 < this.commonSuffix.length) {
                        bl = this.popPushNext();
                        continue;
                    }
                    byte[] byArray2 = this.commonSuffix.bytes;
                    int n7 = this.commonSuffix.length - this.currentFrame.suffix;
                    assert (this.commonSuffix.offset == 0);
                    int n8 = 0;
                    if (n7 > 0) {
                        byte[] byArray3 = this.term.bytes;
                        int n9 = this.currentFrame.prefix - n7;
                        assert (n9 >= 0);
                        int n10 = this.currentFrame.prefix;
                        while (n9 < n10) {
                            if (byArray3[n9++] == byArray2[n8++]) continue;
                            bl = this.popPushNext();
                            continue block0;
                        }
                        n6 = this.currentFrame.startBytePos;
                    } else {
                        n6 = this.currentFrame.startBytePos + this.currentFrame.suffix - this.commonSuffix.length;
                    }
                    int n11 = this.commonSuffix.length;
                    while (n8 < n11) {
                        if (byArray[n6++] == byArray2[n8++]) continue;
                        bl = this.popPushNext();
                        continue block0;
                    }
                }
                n3 = this.currentFrame.state;
                n2 = this.currentTransition.dest;
                n4 = this.currentFrame.startBytePos + this.currentFrame.suffix;
                for (int i2 = this.currentFrame.startBytePos + 1; i2 < n4; ++i2) {
                    n3 = n2;
                    if ((n2 = this.runAutomaton.step(n2, byArray[i2] & 0xFF)) != -1) continue;
                    bl = this.popPushNext();
                    continue block0;
                }
            } else {
                n2 = this.currentFrame.state;
                n3 = this.currentFrame.lastState;
            }
            if (bl) {
                this.copyTerm();
                this.currentFrame = this.pushFrame(n2);
                this.currentTransition = this.currentFrame.transition;
                this.currentFrame.lastState = n3;
            } else if (this.currentFrame.isAutoPrefixTerm) {
                if (this.allowAutoPrefixTerms) {
                    if (this.currentFrame.floorSuffixLeadEnd == -1) {
                        this.useAutoPrefixTerm = n2 == this.sinkState;
                    } else if (this.currentFrame.floorSuffixLeadStart == -1) {
                        if (this.automaton.isAccept(n2)) {
                            this.useAutoPrefixTerm = this.acceptsSuffixRange(n2, 0, this.currentFrame.floorSuffixLeadEnd);
                        }
                    } else {
                        this.useAutoPrefixTerm = this.acceptsSuffixRange(n3, this.currentFrame.floorSuffixLeadStart, this.currentFrame.floorSuffixLeadEnd);
                    }
                    if (this.useAutoPrefixTerm) {
                        this.copyTerm();
                        this.currentFrame.termState.isRealTerm = false;
                        return this.term;
                    }
                }
            } else if (this.runAutomaton.isAccept(n2)) {
                this.copyTerm();
                assert (this.savedStartTerm == null || this.term.compareTo(this.savedStartTerm) > 0) : "saveStartTerm=" + this.savedStartTerm.utf8ToString() + " term=" + this.term.utf8ToString();
                return this.term;
            }
            bl = this.popPushNext();
        }
    }

    private boolean acceptsSuffixRange(int n2, int n3, int n4) {
        int n5 = this.automaton.initTransition(n2, this.scratchTransition);
        for (int i2 = 0; i2 < n5; ++i2) {
            this.automaton.getNextTransition(this.scratchTransition);
            if (n3 < this.scratchTransition.min || n4 > this.scratchTransition.max || this.scratchTransition.dest != this.sinkState) continue;
            return true;
        }
        return false;
    }

    private void copyTerm() {
        int n2 = this.currentFrame.prefix + this.currentFrame.suffix;
        if (this.term.bytes.length < n2) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, n2);
        }
        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
        this.term.length = n2;
    }

    @Override
    public boolean seekExact(BytesRef bytesRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) {
        throw new UnsupportedOperationException();
    }

    private static final class NoMoreTermsException
    extends RuntimeException {
        public static final NoMoreTermsException INSTANCE = new NoMoreTermsException();

        private NoMoreTermsException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

