/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;

final class IntersectTermsEnumFrame {
    final int ord;
    long fp;
    long fpOrig;
    long fpEnd;
    long lastSubFP;
    int state;
    int lastState;
    int metaDataUpto;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] statBytes = new byte[64];
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    byte[] floorData = new byte[32];
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    int numFollowFloorBlocks;
    int nextFloorLabel;
    final Transition transition = new Transition();
    int transitionIndex;
    int transitionCount;
    final boolean versionAutoPrefix;
    FST.Arc<BytesRef> arc;
    final BlockTermState termState;
    final long[] longs;
    byte[] bytes = new byte[32];
    final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    BytesRef outputPrefix;
    int startBytePos;
    int suffix;
    int floorSuffixLeadStart;
    int floorSuffixLeadEnd;
    boolean isAutoPrefixTerm;
    private final IntersectTermsEnum ite;

    public IntersectTermsEnumFrame(IntersectTermsEnum intersectTermsEnum, int n2) throws IOException {
        this.ite = intersectTermsEnum;
        this.ord = n2;
        this.termState = intersectTermsEnum.fr.parent.postingsReader.newTermState();
        this.termState.totalTermFreq = -1L;
        this.longs = new long[intersectTermsEnum.fr.longsSize];
        this.versionAutoPrefix = intersectTermsEnum.fr.parent.anyAutoPrefixTerms;
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.numFollowFloorBlocks > 0) : "nextFloorLabel=" + this.nextFloorLabel;
        do {
            this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
            --this.numFollowFloorBlocks;
            this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? this.floorDataReader.readByte() & 0xFF : 256;
        } while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min);
        this.load(null);
    }

    public void setState(int n2) {
        this.state = n2;
        this.transitionIndex = 0;
        this.transitionCount = this.ite.automaton.getNumTransitions(n2);
        if (this.transitionCount != 0) {
            this.ite.automaton.initTransition(n2, this.transition);
            this.ite.automaton.getNextTransition(this.transition);
        } else {
            this.transition.min = -1;
            this.transition.max = -1;
        }
    }

    void load(BytesRef bytesRef) throws IOException {
        if (bytesRef != null) {
            this.floorDataReader.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            long l2 = this.floorDataReader.readVLong();
            if ((l2 & 1L) != 0L) {
                this.numFollowFloorBlocks = this.floorDataReader.readVInt();
                this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                if (!this.ite.runAutomaton.isAccept(this.state) && this.transitionCount != 0) {
                    assert (this.transitionIndex == 0) : "transitionIndex=" + this.transitionIndex;
                    while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min) {
                        this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
                        --this.numFollowFloorBlocks;
                        if (this.numFollowFloorBlocks != 0) {
                            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                            continue;
                        }
                        this.nextFloorLabel = 256;
                    }
                }
            }
        }
        this.ite.in.seek(this.fp);
        int n2 = this.ite.in.readVInt();
        this.entCount = n2 >>> 1;
        assert (this.entCount > 0);
        this.isLastInFloor = (n2 & 1) != 0;
        n2 = this.ite.in.readVInt();
        this.isLeafBlock = (n2 & 1) != 0;
        int n3 = n2 >>> 1;
        if (this.suffixBytes.length < n3) {
            this.suffixBytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ite.in.readBytes(this.suffixBytes, 0, n3);
        this.suffixesReader.reset(this.suffixBytes, 0, n3);
        n3 = this.ite.in.readVInt();
        if (this.statBytes.length < n3) {
            this.statBytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ite.in.readBytes(this.statBytes, 0, n3);
        this.statsReader.reset(this.statBytes, 0, n3);
        this.metaDataUpto = 0;
        this.termState.termBlockOrd = 0;
        this.nextEnt = 0;
        n3 = this.ite.in.readVInt();
        if (this.bytes.length < n3) {
            this.bytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ite.in.readBytes(this.bytes, 0, n3);
        this.bytesReader.reset(this.bytes, 0, n3);
        if (!this.isLastInFloor) {
            this.fpEnd = this.ite.in.getFilePointer();
        }
        this.isAutoPrefixTerm = false;
    }

    public boolean next() {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffix = this.suffixesReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
    }

    public boolean nextNonLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int n2 = this.suffixesReader.readVInt();
        if (!this.versionAutoPrefix) {
            this.suffix = n2 >>> 1;
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffix);
            if ((n2 & 1) == 0) {
                ++this.termState.termBlockOrd;
                return false;
            }
            this.lastSubFP = this.fp - this.suffixesReader.readVLong();
            return true;
        }
        this.suffix = n2 >>> 2;
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
        switch (n2 & 3) {
            case 0: {
                this.isAutoPrefixTerm = false;
                ++this.termState.termBlockOrd;
                return false;
            }
            case 1: {
                this.isAutoPrefixTerm = false;
                this.lastSubFP = this.fp - this.suffixesReader.readVLong();
                return true;
            }
            case 2: {
                this.floorSuffixLeadStart = -1;
                ++this.termState.termBlockOrd;
                this.floorSuffixLeadEnd = this.suffixesReader.readByte() & 0xFF;
                if (this.floorSuffixLeadEnd == 255) {
                    this.floorSuffixLeadEnd = -1;
                }
                this.isAutoPrefixTerm = true;
                return false;
            }
            case 3: {
                if (this.suffix == 0) {
                    assert (this.ord > 0);
                    IntersectTermsEnumFrame intersectTermsEnumFrame = this.ite.stack[this.ord - 1];
                    this.floorSuffixLeadStart = intersectTermsEnumFrame.suffixBytes[intersectTermsEnumFrame.startBytePos + intersectTermsEnumFrame.suffix - 1] & 0xFF;
                } else {
                    this.floorSuffixLeadStart = this.suffixBytes[this.startBytePos + this.suffix - 1] & 0xFF;
                }
                ++this.termState.termBlockOrd;
                this.isAutoPrefixTerm = true;
                this.floorSuffixLeadEnd = this.suffixesReader.readByte() & 0xFF;
                return false;
            }
        }
        assert (false);
        return false;
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.termState.termBlockOrd;
    }

    public void decodeMetaData() throws IOException {
        boolean bl;
        int n2 = this.getTermBlockOrd();
        boolean bl2 = bl = this.metaDataUpto == 0;
        assert (n2 > 0);
        while (this.metaDataUpto < n2) {
            this.termState.docFreq = this.statsReader.readVInt();
            if (this.ite.fr.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                this.termState.totalTermFreq = (long)this.termState.docFreq + this.statsReader.readVLong();
            }
            for (int i2 = 0; i2 < this.ite.fr.longsSize; ++i2) {
                this.longs[i2] = this.bytesReader.readVLong();
            }
            this.ite.fr.parent.postingsReader.decodeTerm(this.longs, this.bytesReader, this.ite.fr.fieldInfo, this.termState, bl);
            ++this.metaDataUpto;
            bl = false;
        }
        this.termState.termBlockOrd = this.metaDataUpto;
    }
}

