/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.SegmentTermsEnumFrame;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

final class SegmentTermsEnum
extends TermsEnum {
    IndexInput in;
    private SegmentTermsEnumFrame[] stack;
    private final SegmentTermsEnumFrame staticFrame;
    SegmentTermsEnumFrame currentFrame;
    boolean termExists;
    final FieldReader fr;
    private int targetBeforeCurrentLength;
    private final ByteArrayDataInput scratchReader = new ByteArrayDataInput();
    private int validIndexPrefix;
    private boolean eof;
    final BytesRefBuilder term = new BytesRefBuilder();
    private final FST.a fstReader;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[1];

    public SegmentTermsEnum(FieldReader fieldReader) throws IOException {
        this.fr = fieldReader;
        this.stack = new SegmentTermsEnumFrame[0];
        this.staticFrame = new SegmentTermsEnumFrame(this, -1);
        this.fstReader = fieldReader.index == null ? null : fieldReader.index.getBytesReader();
        for (int i2 = 0; i2 < this.arcs.length; ++i2) {
            this.arcs[i2] = new FST.Arc();
        }
        this.currentFrame = this.staticFrame;
        if (fieldReader.index != null) {
            FST.Arc<BytesRef> arc = fieldReader.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            Object var2_4 = null;
        }
        this.validIndexPrefix = 0;
    }

    void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.parent.termsIn.clone();
        }
    }

    private SegmentTermsEnumFrame getFrame(int n2) throws IOException {
        if (n2 >= this.stack.length) {
            SegmentTermsEnumFrame[] segmentTermsEnumFrameArray = new SegmentTermsEnumFrame[ArrayUtil.oversize(1 + n2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, segmentTermsEnumFrameArray, 0, this.stack.length);
            for (int i2 = this.stack.length; i2 < segmentTermsEnumFrameArray.length; ++i2) {
                segmentTermsEnumFrameArray[i2] = new SegmentTermsEnumFrame(this, i2);
            }
            this.stack = segmentTermsEnumFrameArray;
        }
        assert (this.stack[n2].ord == n2);
        return this.stack[n2];
    }

    private FST.Arc<BytesRef> getArc(int n2) {
        if (n2 >= this.arcs.length) {
            FST.Arc[] arcArray = new FST.Arc[ArrayUtil.oversize(1 + n2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, arcArray, 0, this.arcs.length);
            for (int i2 = this.arcs.length; i2 < arcArray.length; ++i2) {
                arcArray[i2] = new FST.Arc();
            }
            this.arcs = arcArray;
        }
        return this.arcs[n2];
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, BytesRef bytesRef, int n2) throws IOException {
        this.scratchReader.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        long l2 = this.scratchReader.readVLong();
        long l3 = l2 >>> 2;
        SegmentTermsEnumFrame segmentTermsEnumFrame = this.getFrame(1 + this.currentFrame.ord);
        segmentTermsEnumFrame.hasTermsOrig = segmentTermsEnumFrame.hasTerms = (l2 & 2L) != 0L;
        boolean bl = segmentTermsEnumFrame.isFloor = (l2 & 1L) != 0L;
        if (segmentTermsEnumFrame.isFloor) {
            segmentTermsEnumFrame.setFloorData(this.scratchReader, bytesRef);
        }
        this.pushFrame(arc, l3, n2);
        return segmentTermsEnumFrame;
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, long l2, int n2) throws IOException {
        SegmentTermsEnumFrame segmentTermsEnumFrame = this.getFrame(1 + this.currentFrame.ord);
        segmentTermsEnumFrame.arc = arc;
        if (segmentTermsEnumFrame.fpOrig == l2 && segmentTermsEnumFrame.nextEnt != -1) {
            if (segmentTermsEnumFrame.ord > this.targetBeforeCurrentLength) {
                segmentTermsEnumFrame.rewind();
            }
            assert (n2 == segmentTermsEnumFrame.prefix);
        } else {
            segmentTermsEnumFrame.nextEnt = -1;
            segmentTermsEnumFrame.prefix = n2;
            segmentTermsEnumFrame.state.termBlockOrd = 0;
            segmentTermsEnumFrame.fpOrig = segmentTermsEnumFrame.fp = l2;
            segmentTermsEnumFrame.lastSubFP = -1L;
        }
        return segmentTermsEnumFrame;
    }

    private boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private boolean setEOF() {
        this.eof = true;
        return true;
    }

    @Override
    public boolean seekExact(BytesRef bytesRef) throws IOException {
        int n2;
        Object object;
        BytesRef bytesRef2;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + bytesRef.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            bytesRef2 = (BytesRef)arc.output;
            object = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int n3 = Math.min(bytesRef.length, this.validIndexPrefix);
            int n4 = 0;
            for (n2 = 0; n2 < n3 && (n4 = (this.term.byteAt(n2) & 0xFF) - (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) == 0; ++n2) {
                arc = this.arcs[1 + n2];
                assert (arc.label == (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) : "arc.label=" + (char)arc.label + " targetLabel=" + (char)(bytesRef.bytes[bytesRef.offset + n2] & 0xFF);
                if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                    bytesRef2 = BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.output);
                }
                if (!arc.isFinal()) continue;
                object = this.stack[1 + object.ord];
            }
            if (n4 == 0) {
                int n5 = n2;
                int n6 = Math.min(bytesRef.length, this.term.length());
                while (n2 < n6 && (n4 = (this.term.byteAt(n2) & 0xFF) - (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) == 0) {
                    ++n2;
                }
                if (n4 == 0) {
                    n4 = this.term.length() - bytesRef.length;
                }
                n2 = n5;
            }
            if (n4 < 0) {
                this.currentFrame = object;
            } else if (n4 > 0) {
                this.targetBeforeCurrentLength = object.ord;
                this.currentFrame = object;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == bytesRef.length);
                if (this.termExists) {
                    return true;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output != null);
            bytesRef2 = (BytesRef)arc.output;
            this.currentFrame = this.staticFrame;
            n2 = 0;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.nextFinalOutput), 0);
        }
        while (n2 < bytesRef.length) {
            int n7 = bytesRef.bytes[bytesRef.offset + n2] & 0xFF;
            FST.Arc<BytesRef> arc2 = this.fr.index.findTargetArc(n7, arc, this.getArc(1 + n2), this.fstReader);
            if (arc2 == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(bytesRef);
                if (!this.currentFrame.hasTerms) {
                    this.termExists = false;
                    this.term.setByteAt(n2, (byte)n7);
                    this.term.setLength(1 + n2);
                    return false;
                }
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus seekStatus = this.currentFrame.scanToTerm(bytesRef, true);
                return seekStatus == TermsEnum.SeekStatus.FOUND;
            }
            arc = arc2;
            this.term.setByteAt(n2, (byte)n7);
            assert (arc.output != null);
            if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                bytesRef2 = BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.output);
            }
            ++n2;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.nextFinalOutput), n2);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(bytesRef);
        if (!this.currentFrame.hasTerms) {
            this.termExists = false;
            this.term.setLength(n2);
            return false;
        }
        this.currentFrame.loadBlock();
        object = this.currentFrame.scanToTerm(bytesRef, true);
        return object == TermsEnum.SeekStatus.FOUND;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
        int n2;
        Object object;
        BytesRef bytesRef2;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + bytesRef.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            bytesRef2 = (BytesRef)arc.output;
            object = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int n3 = Math.min(bytesRef.length, this.validIndexPrefix);
            int n4 = 0;
            for (n2 = 0; n2 < n3 && (n4 = (this.term.byteAt(n2) & 0xFF) - (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) == 0; ++n2) {
                arc = this.arcs[1 + n2];
                assert (arc.label == (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) : "arc.label=" + (char)arc.label + " targetLabel=" + (char)(bytesRef.bytes[bytesRef.offset + n2] & 0xFF);
                if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                    bytesRef2 = BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.output);
                }
                if (!arc.isFinal()) continue;
                object = this.stack[1 + object.ord];
            }
            if (n4 == 0) {
                int n5 = n2;
                int n6 = Math.min(bytesRef.length, this.term.length());
                while (n2 < n6 && (n4 = (this.term.byteAt(n2) & 0xFF) - (bytesRef.bytes[bytesRef.offset + n2] & 0xFF)) == 0) {
                    ++n2;
                }
                if (n4 == 0) {
                    n4 = this.term.length() - bytesRef.length;
                }
                n2 = n5;
            }
            if (n4 < 0) {
                this.currentFrame = object;
            } else if (n4 > 0) {
                this.targetBeforeCurrentLength = 0;
                this.currentFrame = object;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == bytesRef.length);
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output != null);
            bytesRef2 = (BytesRef)arc.output;
            this.currentFrame = this.staticFrame;
            n2 = 0;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.nextFinalOutput), 0);
        }
        while (n2 < bytesRef.length) {
            int n7 = bytesRef.bytes[bytesRef.offset + n2] & 0xFF;
            FST.Arc<BytesRef> arc2 = this.fr.index.findTargetArc(n7, arc, this.getArc(1 + n2), this.fstReader);
            if (arc2 == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(bytesRef);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus seekStatus = this.currentFrame.scanToTerm(bytesRef, false);
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(bytesRef);
                    this.termExists = false;
                    if (this.next() != null) {
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }
                return seekStatus;
            }
            this.term.setByteAt(n2, (byte)n7);
            arc = arc2;
            assert (arc.output != null);
            if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                bytesRef2 = BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.output);
            }
            ++n2;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(bytesRef2, (BytesRef)arc.nextFinalOutput), n2);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(bytesRef);
        this.currentFrame.loadBlock();
        object = this.currentFrame.scanToTerm(bytesRef, false);
        if (object == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(bytesRef);
            this.termExists = false;
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }
        return object;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.in == null) {
            FST.Arc<BytesRef> arc;
            if (this.fr.index != null) {
                arc = this.fr.index.getFirstArc(this.arcs[0]);
                assert (arc.isFinal());
            } else {
                arc = null;
            }
            this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
            this.currentFrame.loadBlock();
        }
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        assert (!this.eof);
        if (this.currentFrame == this.staticFrame) {
            boolean bl = this.seekExact(this.term.get());
            assert (bl);
        }
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                assert (this.setEOF());
                this.term.clear();
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                return null;
            }
            long l2 = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            if (this.currentFrame.nextEnt == -1 || this.currentFrame.lastSubFP != l2) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(l2);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.prefix);
        }
        while (this.currentFrame.next()) {
            this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
            this.currentFrame.loadBlock();
        }
        return this.term.get();
    }

    @Override
    public BytesRef term() {
        assert (!this.eof);
        return this.term.get();
    }

    @Override
    public int docFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.state, postingsEnum, n2);
    }

    @Override
    public void seekExact(BytesRef bytesRef, q q2) {
        assert (this.clearEOF());
        if (bytesRef.compareTo(this.term.get()) != 0 || !this.termExists) {
            assert (q2 != null && q2 instanceof BlockTermState);
            this.currentFrame = this.staticFrame;
            this.currentFrame.state.copyFrom(q2);
            this.term.copyBytes(bytesRef);
            this.currentFrame.metaDataUpto = this.currentFrame.getTermBlockOrd();
            assert (this.currentFrame.metaDataUpto > 0);
            this.validIndexPrefix = 0;
        }
    }

    @Override
    public q termState() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        q q2 = this.currentFrame.state.clone();
        return q2;
    }

    @Override
    public void seekExact(long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }
}

