/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktree.SegmentTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;

final class SegmentTermsEnumFrame {
    final int ord;
    boolean hasTerms;
    boolean hasTermsOrig;
    boolean isFloor;
    FST.Arc<BytesRef> arc;
    final boolean versionAutoPrefix;
    long fp;
    long fpOrig;
    long fpEnd;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] statBytes = new byte[64];
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    byte[] floorData = new byte[32];
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    long lastSubFP;
    int nextFloorLabel;
    int numFollowFloorBlocks;
    int metaDataUpto;
    final BlockTermState state;
    final long[] longs;
    byte[] bytes = new byte[32];
    final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    @Weak
    private final SegmentTermsEnum ste;
    private int startBytePos;
    private int suffix;
    private long subCode;

    public SegmentTermsEnumFrame(SegmentTermsEnum segmentTermsEnum, int n2) throws IOException {
        this.ste = segmentTermsEnum;
        this.ord = n2;
        this.state = segmentTermsEnum.fr.parent.postingsReader.newTermState();
        this.state.totalTermFreq = -1L;
        this.longs = new long[segmentTermsEnum.fr.longsSize];
        this.versionAutoPrefix = segmentTermsEnum.fr.parent.anyAutoPrefixTerms;
    }

    public void setFloorData(ByteArrayDataInput byteArrayDataInput, BytesRef bytesRef) {
        int n2 = bytesRef.length - (byteArrayDataInput.getPosition() - bytesRef.offset);
        if (n2 > this.floorData.length) {
            this.floorData = new byte[ArrayUtil.oversize(n2, 1)];
        }
        System.arraycopy(bytesRef.bytes, bytesRef.offset + byteArrayDataInput.getPosition(), this.floorData, 0, n2);
        this.floorDataReader.reset(this.floorData, 0, n2);
        this.numFollowFloorBlocks = this.floorDataReader.readVInt();
        this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.state.termBlockOrd;
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.arc == null || this.isFloor) : "arc=" + this.arc + " isFloor=" + this.isFloor;
        this.fp = this.fpEnd;
        this.nextEnt = -1;
        this.loadBlock();
    }

    void loadBlock() throws IOException {
        this.ste.initIndexInput();
        if (this.nextEnt != -1) {
            return;
        }
        this.ste.in.seek(this.fp);
        int n2 = this.ste.in.readVInt();
        this.entCount = n2 >>> 1;
        assert (this.entCount > 0);
        boolean bl = this.isLastInFloor = (n2 & 1) != 0;
        assert (this.arc == null || this.isLastInFloor || this.isFloor) : "fp=" + this.fp + " arc=" + this.arc + " isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
        n2 = this.ste.in.readVInt();
        this.isLeafBlock = (n2 & 1) != 0;
        int n3 = n2 >>> 1;
        if (this.suffixBytes.length < n3) {
            this.suffixBytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ste.in.readBytes(this.suffixBytes, 0, n3);
        this.suffixesReader.reset(this.suffixBytes, 0, n3);
        n3 = this.ste.in.readVInt();
        if (this.statBytes.length < n3) {
            this.statBytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ste.in.readBytes(this.statBytes, 0, n3);
        this.statsReader.reset(this.statBytes, 0, n3);
        this.metaDataUpto = 0;
        this.state.termBlockOrd = 0;
        this.nextEnt = 0;
        this.lastSubFP = -1L;
        n3 = this.ste.in.readVInt();
        if (this.bytes.length < n3) {
            this.bytes = new byte[ArrayUtil.oversize(n3, 1)];
        }
        this.ste.in.readBytes(this.bytes, 0, n3);
        this.bytesReader.reset(this.bytes, 0, n3);
        this.fpEnd = this.ste.in.getFilePointer();
    }

    void rewind() {
        this.fp = this.fpOrig;
        this.nextEnt = -1;
        this.hasTerms = this.hasTermsOrig;
        if (this.isFloor) {
            this.floorDataReader.rewind();
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            assert (this.numFollowFloorBlocks > 0);
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
        }
    }

    public boolean next() throws IOException {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffix = this.suffixesReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.term.setLength(this.prefix + this.suffix);
        this.ste.term.grow(this.ste.term.length());
        this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefix, this.suffix);
        this.ste.termExists = true;
    }

    public boolean nextNonLeaf() throws IOException {
        block5: while (true) {
            if (this.nextEnt == this.entCount) {
                assert (this.arc == null || this.isFloor && !this.isLastInFloor) : "isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
                this.loadNextFloorBlock();
                if (!this.isLeafBlock) continue;
                this.nextLeaf();
                return false;
            }
            assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
            ++this.nextEnt;
            int n2 = this.suffixesReader.readVInt();
            if (!this.versionAutoPrefix) {
                this.suffix = n2 >>> 1;
                this.startBytePos = this.suffixesReader.getPosition();
                this.ste.term.setLength(this.prefix + this.suffix);
                this.ste.term.grow(this.ste.term.length());
                this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefix, this.suffix);
                if ((n2 & 1) == 0) {
                    this.ste.termExists = true;
                    this.subCode = 0L;
                    ++this.state.termBlockOrd;
                    return false;
                }
                this.ste.termExists = false;
                this.subCode = this.suffixesReader.readVLong();
                this.lastSubFP = this.fp - this.subCode;
                return true;
            }
            this.suffix = n2 >>> 2;
            this.startBytePos = this.suffixesReader.getPosition();
            this.ste.term.setLength(this.prefix + this.suffix);
            this.ste.term.grow(this.ste.term.length());
            this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefix, this.suffix);
            switch (n2 & 3) {
                case 0: {
                    this.ste.termExists = true;
                    this.subCode = 0L;
                    ++this.state.termBlockOrd;
                    return false;
                }
                case 1: {
                    this.ste.termExists = false;
                    this.subCode = this.suffixesReader.readVLong();
                    this.lastSubFP = this.fp - this.subCode;
                    return true;
                }
                case 2: 
                case 3: {
                    ++this.state.termBlockOrd;
                    this.suffixesReader.readByte();
                    continue block5;
                }
            }
        }
    }

    public void scanToFloorFrame(BytesRef bytesRef) {
        if (!this.isFloor || bytesRef.length <= this.prefix) {
            return;
        }
        int n2 = bytesRef.bytes[bytesRef.offset + this.prefix] & 0xFF;
        if (n2 < this.nextFloorLabel) {
            return;
        }
        assert (this.numFollowFloorBlocks != 0);
        long l2 = this.fpOrig;
        do {
            long l3 = this.floorDataReader.readVLong();
            l2 = this.fpOrig + (l3 >>> 1);
            this.hasTerms = (l3 & 1L) != 0L;
            this.isLastInFloor = this.numFollowFloorBlocks == 1;
            --this.numFollowFloorBlocks;
            if (this.isLastInFloor) {
                this.nextFloorLabel = 256;
                break;
            }
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
        } while (n2 >= this.nextFloorLabel);
        if (l2 != this.fp) {
            this.nextEnt = -1;
            this.fp = l2;
        }
    }

    public void decodeMetaData() throws IOException {
        boolean bl;
        int n2 = this.getTermBlockOrd();
        boolean bl2 = bl = this.metaDataUpto == 0;
        assert (n2 > 0);
        while (this.metaDataUpto < n2) {
            this.state.docFreq = this.statsReader.readVInt();
            if (this.ste.fr.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                this.state.totalTermFreq = (long)this.state.docFreq + this.statsReader.readVLong();
            }
            for (int i2 = 0; i2 < this.ste.fr.longsSize; ++i2) {
                this.longs[i2] = this.bytesReader.readVLong();
            }
            this.ste.fr.parent.postingsReader.decodeTerm(this.longs, this.bytesReader, this.ste.fr.fieldInfo, this.state, bl);
            ++this.metaDataUpto;
            bl = false;
        }
        this.state.termBlockOrd = this.metaDataUpto;
    }

    private boolean prefixMatches(BytesRef bytesRef) {
        for (int i2 = 0; i2 < this.prefix; ++i2) {
            if (bytesRef.bytes[bytesRef.offset + i2] == this.ste.term.byteAt(i2)) continue;
            return false;
        }
        return true;
    }

    public void scanToSubBlock(long l2) {
        assert (!this.isLeafBlock);
        if (this.lastSubFP == l2) {
            return;
        }
        assert (l2 < this.fp) : "fp=" + this.fp + " subFP=" + l2;
        long l3 = this.fp - l2;
        while (true) {
            assert (this.nextEnt < this.entCount);
            ++this.nextEnt;
            int n2 = this.suffixesReader.readVInt();
            if (!this.versionAutoPrefix) {
                this.suffixesReader.skipBytes(n2 >>> 1);
                if ((n2 & 1) != 0) {
                    long l4 = this.suffixesReader.readVLong();
                    if (l3 != l4) continue;
                    this.lastSubFP = l2;
                    return;
                }
                ++this.state.termBlockOrd;
                continue;
            }
            int n3 = n2 & 3;
            this.suffixesReader.skipBytes(n2 >>> 2);
            if (n3 == 1) {
                long l5 = this.suffixesReader.readVLong();
                if (l3 != l5) continue;
                this.lastSubFP = l2;
                return;
            }
            ++this.state.termBlockOrd;
            if (n3 != 2 && n3 != 3) continue;
            this.suffixesReader.readByte();
        }
    }

    public TermsEnum.SeekStatus scanToTerm(BytesRef bytesRef, boolean bl) throws IOException {
        return this.isLeafBlock ? this.scanToTermLeaf(bytesRef, bl) : this.scanToTermNonLeaf(bytesRef, bl);
    }

    public TermsEnum.SeekStatus scanToTermLeaf(BytesRef bytesRef, boolean bl) throws IOException {
        block12: {
            assert (this.nextEnt != -1);
            this.ste.termExists = true;
            this.subCode = 0L;
            if (this.nextEnt == this.entCount) {
                if (bl) {
                    this.fillTerm();
                }
                return TermsEnum.SeekStatus.END;
            }
            assert (this.prefixMatches(bytesRef));
            block0: while (true) {
                boolean bl2;
                ++this.nextEnt;
                this.suffix = this.suffixesReader.readVInt();
                int n2 = this.prefix + this.suffix;
                this.startBytePos = this.suffixesReader.getPosition();
                this.suffixesReader.skipBytes(this.suffix);
                int n3 = bytesRef.offset + (bytesRef.length < n2 ? bytesRef.length : n2);
                int n4 = bytesRef.offset + this.prefix;
                int n5 = this.startBytePos;
                do {
                    int n6;
                    if (n4 < n3) {
                        n6 = (this.suffixBytes[n5++] & 0xFF) - (bytesRef.bytes[n4++] & 0xFF);
                        bl2 = false;
                    } else {
                        assert (n4 == n3);
                        n6 = n2 - bytesRef.length;
                        bl2 = true;
                    }
                    if (n6 < 0) {
                        if (this.nextEnt != this.entCount) continue block0;
                        break block12;
                    }
                    if (n6 <= 0) continue;
                    this.fillTerm();
                    return TermsEnum.SeekStatus.NOT_FOUND;
                } while (!bl2);
                break;
            }
            assert (this.ste.termExists);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (bl) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    public TermsEnum.SeekStatus scanToTermNonLeaf(BytesRef bytesRef, boolean bl) throws IOException {
        assert (this.nextEnt != -1);
        if (this.nextEnt == this.entCount) {
            if (bl) {
                this.fillTerm();
                this.ste.termExists = this.subCode == 0L;
            }
            return TermsEnum.SeekStatus.END;
        }
        assert (this.prefixMatches(bytesRef));
        block5: while (this.nextEnt < this.entCount) {
            boolean bl2;
            ++this.nextEnt;
            int n2 = this.suffixesReader.readVInt();
            this.suffix = !this.versionAutoPrefix ? n2 >>> 1 : n2 >>> 2;
            int n3 = this.prefix + this.suffix;
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffix);
            if (!this.versionAutoPrefix) {
                boolean bl3 = this.ste.termExists = (n2 & 1) == 0;
                if (this.ste.termExists) {
                    ++this.state.termBlockOrd;
                    this.subCode = 0L;
                } else {
                    this.subCode = this.suffixesReader.readVLong();
                    this.lastSubFP = this.fp - this.subCode;
                }
            } else {
                switch (n2 & 3) {
                    case 0: {
                        this.ste.termExists = true;
                        ++this.state.termBlockOrd;
                        this.subCode = 0L;
                        break;
                    }
                    case 1: {
                        this.ste.termExists = false;
                        this.subCode = this.suffixesReader.readVLong();
                        this.lastSubFP = this.fp - this.subCode;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.suffixesReader.readByte();
                        this.ste.termExists = false;
                        ++this.state.termBlockOrd;
                        continue block5;
                    }
                }
            }
            int n4 = bytesRef.offset + (bytesRef.length < n3 ? bytesRef.length : n3);
            int n5 = bytesRef.offset + this.prefix;
            int n6 = this.startBytePos;
            do {
                int n7;
                if (n5 < n4) {
                    n7 = (this.suffixBytes[n6++] & 0xFF) - (bytesRef.bytes[n5++] & 0xFF);
                    bl2 = false;
                } else {
                    assert (n5 == n4);
                    n7 = n3 - bytesRef.length;
                    bl2 = true;
                }
                if (n7 < 0) continue block5;
                if (n7 <= 0) continue;
                this.fillTerm();
                if (!bl && !this.ste.termExists) {
                    this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, n3);
                    this.ste.currentFrame.loadBlock();
                    while (this.ste.currentFrame.next()) {
                        this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, this.ste.term.length());
                        this.ste.currentFrame.loadBlock();
                    }
                }
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (!bl2);
            assert (this.ste.termExists);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (bl) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    private void fillTerm() {
        int n2 = this.prefix + this.suffix;
        this.ste.term.setLength(n2);
        this.ste.term.grow(n2);
        System.arraycopy(this.suffixBytes, this.startBytePos, this.ste.term.bytes(), this.prefix, this.suffix);
    }
}

