/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsIndexWriter
implements Closeable {
    final IndexOutput fieldsIndexOut;
    final int blockSize;
    int totalDocs;
    int blockDocs;
    int blockChunks;
    long firstStartPointer;
    long maxStartPointer;
    final int[] docBaseDeltas;
    final long[] startPointerDeltas;

    CompressingStoredFieldsIndexWriter(IndexOutput indexOutput, int n2) throws IOException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        this.blockSize = n2;
        this.fieldsIndexOut = indexOutput;
        this.reset();
        this.totalDocs = 0;
        this.docBaseDeltas = new int[n2];
        this.startPointerDeltas = new long[n2];
        this.fieldsIndexOut.writeVInt(2);
    }

    private void reset() {
        this.blockChunks = 0;
        this.blockDocs = 0;
        this.firstStartPointer = -1L;
    }

    private void writeBlock() throws IOException {
        int n2;
        int n3;
        assert (this.blockChunks > 0);
        this.fieldsIndexOut.writeVInt(this.blockChunks);
        int n4 = this.blockChunks == 1 ? 0 : Math.round((float)(this.blockDocs - this.docBaseDeltas[this.blockChunks - 1]) / (float)(this.blockChunks - 1));
        this.fieldsIndexOut.writeVInt(this.totalDocs - this.blockDocs);
        this.fieldsIndexOut.writeVInt(n4);
        int n5 = 0;
        long l2 = 0L;
        for (n3 = 0; n3 < this.blockChunks; ++n3) {
            int n6 = n5 - n4 * n3;
            l2 |= (long)BitUtil.zigZagEncode(n6);
            n5 += this.docBaseDeltas[n3];
        }
        n3 = PackedInts.bitsRequired(l2);
        this.fieldsIndexOut.writeVInt(n3);
        PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.fieldsIndexOut, PackedInts.Format.PACKED, this.blockChunks, n3, 1);
        n5 = 0;
        for (int i2 = 0; i2 < this.blockChunks; ++i2) {
            long l3 = n5 - n4 * i2;
            assert (PackedInts.bitsRequired(BitUtil.zigZagEncode(l3)) <= writer.bitsPerValue());
            writer.add(BitUtil.zigZagEncode(l3));
            n5 += this.docBaseDeltas[i2];
        }
        writer.finish();
        this.fieldsIndexOut.writeVLong(this.firstStartPointer);
        long l4 = this.blockChunks == 1 ? 0L : (this.maxStartPointer - this.firstStartPointer) / (long)(this.blockChunks - 1);
        this.fieldsIndexOut.writeVLong(l4);
        long l5 = 0L;
        l2 = 0L;
        for (n2 = 0; n2 < this.blockChunks; ++n2) {
            long l6 = (l5 += this.startPointerDeltas[n2]) - l4 * (long)n2;
            l2 |= BitUtil.zigZagEncode(l6);
        }
        n2 = PackedInts.bitsRequired(l2);
        this.fieldsIndexOut.writeVInt(n2);
        writer = PackedInts.getWriterNoHeader(this.fieldsIndexOut, PackedInts.Format.PACKED, this.blockChunks, n2, 1);
        l5 = 0L;
        for (int i3 = 0; i3 < this.blockChunks; ++i3) {
            long l7 = (l5 += this.startPointerDeltas[i3]) - l4 * (long)i3;
            assert (PackedInts.bitsRequired(BitUtil.zigZagEncode(l7)) <= writer.bitsPerValue());
            writer.add(BitUtil.zigZagEncode(l7));
        }
        writer.finish();
    }

    void writeIndex(int n2, long l2) throws IOException {
        if (this.blockChunks == this.blockSize) {
            this.writeBlock();
            this.reset();
        }
        if (this.firstStartPointer == -1L) {
            this.firstStartPointer = this.maxStartPointer = l2;
        }
        assert (this.firstStartPointer > 0L && l2 >= this.firstStartPointer);
        this.docBaseDeltas[this.blockChunks] = n2;
        this.startPointerDeltas[this.blockChunks] = l2 - this.maxStartPointer;
        ++this.blockChunks;
        this.blockDocs += n2;
        this.totalDocs += n2;
        this.maxStartPointer = l2;
    }

    void finish(int n2, long l2) throws IOException {
        if (n2 != this.totalDocs) {
            throw new IllegalStateException("Expected " + n2 + " docs, but got " + this.totalDocs);
        }
        if (this.blockChunks > 0) {
            this.writeBlock();
        }
        this.fieldsIndexOut.writeVInt(0);
        this.fieldsIndexOut.writeVLong(l2);
        CodecUtil.writeFooter(this.fieldsIndexOut);
    }

    @Override
    public void close() throws IOException {
        this.fieldsIndexOut.close();
    }
}

