/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.b;
import org.apache.lucene.codecs.n;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsReader
extends n {
    private final int version;
    private final FieldInfos fieldInfos;
    private final CompressingStoredFieldsIndexReader indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final b decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private final long numChunks;
    private final long numDirtyChunks;
    private boolean closed;

    private CompressingStoredFieldsReader(CompressingStoredFieldsReader compressingStoredFieldsReader, boolean bl) {
        this.version = compressingStoredFieldsReader.version;
        this.fieldInfos = compressingStoredFieldsReader.fieldInfos;
        this.fieldsStream = compressingStoredFieldsReader.fieldsStream.clone();
        this.indexReader = compressingStoredFieldsReader.indexReader.clone();
        this.maxPointer = compressingStoredFieldsReader.maxPointer;
        this.chunkSize = compressingStoredFieldsReader.chunkSize;
        this.packedIntsVersion = compressingStoredFieldsReader.packedIntsVersion;
        this.compressionMode = compressingStoredFieldsReader.compressionMode;
        this.decompressor = compressingStoredFieldsReader.decompressor.clone();
        this.numDocs = compressingStoredFieldsReader.numDocs;
        this.numChunks = compressingStoredFieldsReader.numChunks;
        this.numDirtyChunks = compressingStoredFieldsReader.numDirtyChunks;
        this.merging = bl;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingStoredFieldsReader(c c2, SegmentInfo segmentInfo, String string, FieldInfos fieldInfos, IOContext iOContext, String string2, CompressionMode compressionMode) throws IOException {
        Object object;
        Object object2;
        CompressingStoredFieldsIndexReader compressingStoredFieldsIndexReader;
        long l2;
        int n2;
        boolean bl;
        String string3;
        block25: {
            this.compressionMode = compressionMode;
            string3 = segmentInfo.name;
            bl = false;
            this.fieldInfos = fieldInfos;
            this.numDocs = segmentInfo.maxDoc();
            n2 = -1;
            l2 = -1L;
            compressingStoredFieldsIndexReader = null;
            String string4 = IndexFileNames.segmentFileName(string3, string, "fdx");
            object2 = c2.openChecksumInput(string4, iOContext);
            object = null;
            try {
                Throwable throwable = null;
                try {
                    String string5 = string2 + "Index";
                    n2 = CodecUtil.checkIndexHeader((DataInput)object2, string5, 0, 1, segmentInfo.getId(), string);
                    assert ((long)CodecUtil.indexHeaderLength(string5, string) == ((IndexInput)object2).getFilePointer());
                    compressingStoredFieldsIndexReader = new CompressingStoredFieldsIndexReader((IndexInput)object2, segmentInfo);
                    l2 = ((DataInput)object2).readVLong();
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        break block25;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
                    }
                }
                CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((IndexInput)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((IndexInput)object2).close();
                    }
                }
            }
        }
        this.version = n2;
        this.maxPointer = l2;
        this.indexReader = compressingStoredFieldsIndexReader;
        object2 = IndexFileNames.segmentFileName(string3, string, "fdt");
        try {
            this.fieldsStream = c2.openInput((String)object2, iOContext);
            object = string2 + "Data";
            int n3 = CodecUtil.checkIndexHeader(this.fieldsStream, (String)object, 0, 1, segmentInfo.getId(), string);
            if (n2 != n3) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + n2 + " != " + n3, this.fieldsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength((String)object, string) == this.fieldsStream.getFilePointer());
            this.chunkSize = this.fieldsStream.readVInt();
            this.packedIntsVersion = this.fieldsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            if (n2 >= 1) {
                this.fieldsStream.seek(l2);
                this.numChunks = this.fieldsStream.readVLong();
                this.numDirtyChunks = this.fieldsStream.readVLong();
                if (this.numDirtyChunks > this.numChunks) {
                    throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.fieldsStream);
                }
            } else {
                this.numDirtyChunks = -1L;
                this.numChunks = -1L;
            }
            CodecUtil.retrieveChecksum(this.fieldsStream);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    private void ensureOpen() throws org.apache.lucene.store.a {
        if (this.closed) {
            throw new org.apache.lucene.store.a("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput dataInput, StoredFieldVisitor storedFieldVisitor, FieldInfo fieldInfo, int n2) throws IOException {
        switch (n2 & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                int n3 = dataInput.readVInt();
                byte[] byArray = new byte[n3];
                dataInput.readBytes(byArray, 0, n3);
                storedFieldVisitor.binaryField(fieldInfo, byArray);
                break;
            }
            case 0: {
                int n4 = dataInput.readVInt();
                byte[] byArray = new byte[n4];
                dataInput.readBytes(byArray, 0, n4);
                storedFieldVisitor.stringField(fieldInfo, byArray);
                break;
            }
            case 2: {
                storedFieldVisitor.intField(fieldInfo, dataInput.readZInt());
                break;
            }
            case 3: {
                storedFieldVisitor.floatField(fieldInfo, CompressingStoredFieldsReader.readZFloat(dataInput));
                break;
            }
            case 4: {
                storedFieldVisitor.longField(fieldInfo, CompressingStoredFieldsReader.readTLong(dataInput));
                break;
            }
            case 5: {
                storedFieldVisitor.doubleField(fieldInfo, CompressingStoredFieldsReader.readZDouble(dataInput));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(n2)));
            }
        }
    }

    private static void skipField(DataInput dataInput, int n2) throws IOException {
        switch (n2 & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                int n3 = dataInput.readVInt();
                dataInput.skipBytes(n3);
                break;
            }
            case 2: {
                dataInput.readZInt();
                break;
            }
            case 3: {
                CompressingStoredFieldsReader.readZFloat(dataInput);
                break;
            }
            case 4: {
                CompressingStoredFieldsReader.readTLong(dataInput);
                break;
            }
            case 5: {
                CompressingStoredFieldsReader.readZDouble(dataInput);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(n2)));
            }
        }
    }

    static float readZFloat(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 == 255) {
            return Float.intBitsToFloat(dataInput.readInt());
        }
        if ((n2 & 0x80) != 0) {
            return (n2 & 0x7F) - 1;
        }
        int n3 = n2 << 24 | (dataInput.readShort() & 0xFFFF) << 8 | dataInput.readByte() & 0xFF;
        return Float.intBitsToFloat(n3);
    }

    static double readZDouble(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 == 255) {
            return Double.longBitsToDouble(dataInput.readLong());
        }
        if (n2 == 254) {
            return Float.intBitsToFloat(dataInput.readInt());
        }
        if ((n2 & 0x80) != 0) {
            return (n2 & 0x7F) - 1;
        }
        long l2 = (long)n2 << 56 | ((long)dataInput.readInt() & 0xFFFFFFFFL) << 24 | ((long)dataInput.readShort() & 0xFFFFL) << 8 | (long)dataInput.readByte() & 0xFFL;
        return Double.longBitsToDouble(l2);
    }

    static long readTLong(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        long l2 = n2 & 0x1F;
        if ((n2 & 0x20) != 0) {
            l2 |= dataInput.readVLong() << 5;
        }
        long l3 = BitUtil.zigZagDecode(l2);
        switch (n2 & 0xC0) {
            case 64: {
                l3 *= 1000L;
                break;
            }
            case 128: {
                l3 *= 3600000L;
                break;
            }
            case 192: {
                l3 *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l3;
    }

    SerializedDocument document(int n2) throws IOException {
        if (!this.state.contains(n2)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(n2));
            this.state.reset(n2);
        }
        assert (this.state.contains(n2));
        return this.state.document(n2);
    }

    @Override
    public void visitDocument(int n2, StoredFieldVisitor storedFieldVisitor) throws IOException {
        SerializedDocument serializedDocument = this.document(n2);
        block5: for (int i2 = 0; i2 < serializedDocument.numStoredFields; ++i2) {
            long l2 = serializedDocument.in.readVLong();
            int n3 = (int)(l2 >>> CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n3);
            int n4 = (int)(l2 & (long)CompressingStoredFieldsWriter.TYPE_MASK);
            assert (n4 <= 5) : "bits=" + Integer.toHexString(n4);
            switch (storedFieldVisitor.needsField(fieldInfo)) {
                case YES: {
                    CompressingStoredFieldsReader.readField(serializedDocument.in, storedFieldVisitor, fieldInfo, n4);
                    continue block5;
                }
                case NO: {
                    CompressingStoredFieldsReader.skipField(serializedDocument.in, n4);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public n clone() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, false);
    }

    @Override
    public n getMergeInstance() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, true);
    }

    int getVersion() {
        return this.version;
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    long getNumChunks() {
        return this.numChunks;
    }

    long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.singleton(org.apache.lucene.util.b.a("stored field index", this.indexReader));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private int[] offsets = IntsRef.EMPTY_INTS;
        private int[] numStoredFields = IntsRef.EMPTY_INTS;
        private long startPointer;
        private final BytesRef spare = new BytesRef();
        private final BytesRef bytes = new BytesRef();

        private BlockState() {
        }

        boolean contains(int n2) {
            return n2 >= this.docBase && n2 < this.docBase + this.chunkDocs;
        }

        void reset(int n2) throws IOException {
            boolean bl = false;
            try {
                this.doReset(n2);
                bl = true;
            }
            finally {
                if (!bl) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int n2) throws IOException {
            int n3;
            int n4;
            int n5;
            this.docBase = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int n6 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = n6 >>> 1;
            if (!this.contains(n2) || this.docBase + this.chunkDocs > CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + n2 + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + CompressingStoredFieldsReader.this.numDocs, CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (n6 & 1) != 0;
            this.offsets = ArrayUtil.grow(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.grow(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int n7;
                int n8;
                n5 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (n5 == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (n5 > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + n5, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.c c2 = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, n5, 1);
                    for (n8 = 0; n8 < this.chunkDocs; ++n8) {
                        this.numStoredFields[n8] = (int)c2.next();
                    }
                }
                n4 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (n4 == 0) {
                    n8 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                    for (n7 = 0; n7 < this.chunkDocs; ++n7) {
                        this.offsets[1 + n7] = (1 + n7) * n8;
                    }
                } else {
                    if (n5 > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + n4, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.c c3 = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, n4, 1);
                    for (n7 = 0; n7 < this.chunkDocs; ++n7) {
                        this.offsets[n7 + 1] = (int)c3.next();
                    }
                    for (n7 = 0; n7 < this.chunkDocs; ++n7) {
                        int n9 = n7 + 1;
                        this.offsets[n9] = this.offsets[n9] + this.offsets[n7];
                    }
                }
                for (n3 = 0; n3 < this.chunkDocs; ++n3) {
                    int n10;
                    n7 = this.offsets[n3 + 1] - this.offsets[n3];
                    if (n7 == 0 == ((n10 = this.numStoredFields[n3]) == 0)) continue;
                    throw new CorruptIndexException("length=" + n7 + ", numStoredFields=" + n10, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (CompressingStoredFieldsReader.this.merging) {
                n5 = this.offsets[this.chunkDocs];
                if (this.sliced) {
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (n4 = 0; n4 < n5; n4 += n3) {
                        n3 = Math.min(n5 - n4, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n3, 0, n3, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n5, 0, n5, this.bytes);
                }
                if (this.bytes.length != n5) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + n5 + ", got " + this.bytes.length, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int n2) throws IOException {
            DataInput dataInput;
            if (!this.contains(n2)) {
                throw new IllegalArgumentException();
            }
            int n3 = n2 - this.docBase;
            int n4 = this.offsets[n3];
            final int n5 = this.offsets[n3 + 1] - n4;
            int n6 = this.offsets[this.chunkDocs];
            int n7 = this.numStoredFields[n3];
            if (n5 == 0) {
                dataInput = new ByteArrayDataInput();
            } else if (CompressingStoredFieldsReader.this.merging) {
                dataInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset + n4, n5);
            } else if (this.sliced) {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, CompressingStoredFieldsReader.this.chunkSize, n4, Math.min(n5, CompressingStoredFieldsReader.this.chunkSize - n4), this.bytes);
                dataInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = ((BlockState)BlockState.this).bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= n5);
                        if (this.decompressed == n5) {
                            throw new EOFException();
                        }
                        int n2 = Math.min(n5 - this.decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n2, 0, n2, BlockState.this.bytes);
                        this.decompressed += n2;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (((BlockState)BlockState.this).bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --((BlockState)BlockState.this).bytes.length;
                        return ((BlockState)BlockState.this).bytes.bytes[((BlockState)BlockState.this).bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
                        while (n3 > ((BlockState)BlockState.this).bytes.length) {
                            System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, byArray, n2, ((BlockState)BlockState.this).bytes.length);
                            n3 -= ((BlockState)BlockState.this).bytes.length;
                            n2 += ((BlockState)BlockState.this).bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, byArray, n2, n3);
                        ((BlockState)BlockState.this).bytes.offset += n3;
                        ((BlockState)BlockState.this).bytes.length -= n3;
                    }
                };
            } else {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n6, n4, n5, this.bytes);
                assert (this.bytes.length == n5);
                dataInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset, this.bytes.length);
            }
            return new SerializedDocument(dataInput, n5, n7);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput dataInput, int n2, int n3) {
            this.in = dataInput;
            this.length = n2;
            this.numStoredFields = n3;
        }
    }
}

