/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.b;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.m;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BlockPackedReaderIterator;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingTermVectorsReader
extends p
implements Closeable {
    private final FieldInfos fieldInfos;
    final CompressingStoredFieldsIndexReader indexReader;
    final IndexInput vectorsStream;
    private final int version;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final b decompressor;
    private final int chunkSize;
    private final int numDocs;
    private boolean closed;
    private final BlockPackedReaderIterator reader;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long maxPointer;

    private CompressingTermVectorsReader(CompressingTermVectorsReader compressingTermVectorsReader) {
        this.fieldInfos = compressingTermVectorsReader.fieldInfos;
        this.vectorsStream = compressingTermVectorsReader.vectorsStream.clone();
        this.indexReader = compressingTermVectorsReader.indexReader.clone();
        this.packedIntsVersion = compressingTermVectorsReader.packedIntsVersion;
        this.compressionMode = compressingTermVectorsReader.compressionMode;
        this.decompressor = compressingTermVectorsReader.decompressor.clone();
        this.chunkSize = compressingTermVectorsReader.chunkSize;
        this.numDocs = compressingTermVectorsReader.numDocs;
        this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
        this.version = compressingTermVectorsReader.version;
        this.numChunks = compressingTermVectorsReader.numChunks;
        this.numDirtyChunks = compressingTermVectorsReader.numDirtyChunks;
        this.maxPointer = compressingTermVectorsReader.maxPointer;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingTermVectorsReader(c c2, SegmentInfo segmentInfo, String string, FieldInfos fieldInfos, IOContext iOContext, String string2, CompressionMode compressionMode) throws IOException {
        Object object;
        Object object2;
        long l2;
        CompressingStoredFieldsIndexReader compressingStoredFieldsIndexReader;
        int n2;
        boolean bl;
        String string3;
        block25: {
            this.compressionMode = compressionMode;
            string3 = segmentInfo.name;
            bl = false;
            this.fieldInfos = fieldInfos;
            this.numDocs = segmentInfo.maxDoc();
            n2 = -1;
            compressingStoredFieldsIndexReader = null;
            l2 = -1L;
            String string4 = IndexFileNames.segmentFileName(string3, string, "tvx");
            object2 = c2.openChecksumInput(string4, iOContext);
            object = null;
            try {
                Throwable throwable = null;
                try {
                    String string5 = string2 + "Index";
                    n2 = CodecUtil.checkIndexHeader((DataInput)object2, string5, 0, 1, segmentInfo.getId(), string);
                    assert ((long)CodecUtil.indexHeaderLength(string5, string) == ((IndexInput)object2).getFilePointer());
                    compressingStoredFieldsIndexReader = new CompressingStoredFieldsIndexReader((IndexInput)object2, segmentInfo);
                    l2 = ((DataInput)object2).readVLong();
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        break block25;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
                    }
                }
                CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((IndexInput)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((IndexInput)object2).close();
                    }
                }
            }
        }
        this.version = n2;
        this.indexReader = compressingStoredFieldsIndexReader;
        this.maxPointer = l2;
        try {
            object2 = IndexFileNames.segmentFileName(string3, string, "tvd");
            this.vectorsStream = c2.openInput((String)object2, iOContext);
            object = string2 + "Data";
            int n3 = CodecUtil.checkIndexHeader(this.vectorsStream, (String)object, 0, 1, segmentInfo.getId(), string);
            if (n2 != n3) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + n2 + " != " + n3, this.vectorsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength((String)object, string) == this.vectorsStream.getFilePointer());
            long l3 = this.vectorsStream.getFilePointer();
            if (n2 >= 1) {
                this.vectorsStream.seek(l2);
                this.numChunks = this.vectorsStream.readVLong();
                this.numDirtyChunks = this.vectorsStream.readVLong();
                if (this.numDirtyChunks > this.numChunks) {
                    throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.vectorsStream);
                }
            } else {
                this.numDirtyChunks = -1L;
                this.numChunks = -1L;
            }
            CodecUtil.retrieveChecksum(this.vectorsStream);
            this.vectorsStream.seek(l3);
            this.packedIntsVersion = this.vectorsStream.readVInt();
            this.chunkSize = this.vectorsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    int getVersion() {
        return this.version;
    }

    CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    IndexInput getVectorsStream() {
        return this.vectorsStream;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    long getNumChunks() {
        return this.numChunks;
    }

    long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    private void ensureOpen() throws a {
        if (this.closed) {
            throw new a("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.vectorsStream);
            this.closed = true;
        }
    }

    @Override
    public p clone() {
        return new CompressingTermVectorsReader(this);
    }

    @Override
    public Fields get(int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray;
        Object object;
        Object object2;
        int n10;
        int n11;
        LongsRef longsRef;
        int n12;
        int[] nArray2;
        int n13;
        int n14;
        int n15;
        PackedInts.Reader reader;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        this.ensureOpen();
        long l2 = this.indexReader.getStartPointer(n2);
        this.vectorsStream.seek(l2);
        int n21 = this.vectorsStream.readVInt();
        int n22 = this.vectorsStream.readVInt();
        if (n2 < n21 || n2 >= n21 + n22 || n21 + n22 > this.numDocs) {
            throw new CorruptIndexException("docBase=" + n21 + ",chunkDocs=" + n22 + ",doc=" + n2, this.vectorsStream);
        }
        if (n22 == 1) {
            n20 = 0;
            n18 = n19 = this.vectorsStream.readVInt();
        } else {
            this.reader.reset(this.vectorsStream, n22);
            int n23 = 0;
            for (n17 = n21; n17 < n2; ++n17) {
                n23 = (int)((long)n23 + this.reader.next());
            }
            n20 = n23;
            n18 = (int)this.reader.next();
            n23 += n18;
            for (n17 = n2 + 1; n17 < n21 + n22; ++n17) {
                n23 = (int)((long)n23 + this.reader.next());
            }
            n19 = n23;
        }
        if (n18 == 0) {
            return null;
        }
        n17 = this.vectorsStream.readByte() & 0xFF;
        assert (n17 != 0);
        int n24 = n17 & 0x1F;
        int n25 = n17 >>> 5;
        if (n25 == 7) {
            n25 += this.vectorsStream.readVInt();
        }
        Object object3 = PackedInts.getReaderIteratorNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, ++n25, n24, 1);
        int[] nArray3 = new int[n25];
        for (int i2 = 0; i2 < n25; ++i2) {
            nArray3[i2] = (int)object3.next();
        }
        int[] nArray4 = new int[n18];
        n25 = PackedInts.bitsRequired(nArray3.length - 1);
        object3 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n19, n25);
        switch (this.vectorsStream.readVInt()) {
            case 0: {
                PackedInts.Reader reader2 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, nArray3.length, CompressingTermVectorsWriter.FLAGS_BITS);
                PackedInts.Mutable mutable = PackedInts.getMutable(n19, CompressingTermVectorsWriter.FLAGS_BITS, 0.0f);
                for (n16 = 0; n16 < n19; ++n16) {
                    int n26 = (int)((m)object3).get(n16);
                    assert (n26 >= 0 && n26 < nArray3.length);
                    int n27 = (int)reader2.get(n26);
                    mutable.set(n16, n27);
                }
                reader = mutable;
                break;
            }
            case 1: {
                reader = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n19, CompressingTermVectorsWriter.FLAGS_BITS);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (n15 = 0; n15 < n18; ++n15) {
            nArray4[n15] = (int)((m)object3).get(n20 + n15);
        }
        n15 = this.vectorsStream.readVInt();
        PackedInts.Reader reader3 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n19, n15);
        int n28 = 0;
        for (n16 = 0; n16 < n19; ++n16) {
            n28 = (int)((long)n28 + reader3.get(n16));
        }
        int n29 = n28;
        n15 = 0;
        n28 = 0;
        int[] nArray5 = new int[n18];
        int[][] nArrayArray = new int[n18][];
        int[][] nArrayArray2 = new int[n18][];
        this.reader.reset(this.vectorsStream, n29);
        int n30 = 0;
        for (n14 = 0; n14 < n20; ++n14) {
            n30 = (int)((long)n30 + reader3.get(n14));
        }
        this.reader.skip(n30);
        for (n14 = 0; n14 < n18; ++n14) {
            n13 = (int)reader3.get(n20 + n14);
            nArray2 = new int[n13];
            nArrayArray[n14] = nArray2;
            n12 = 0;
            while (n12 < n13) {
                longsRef = this.reader.next(n13 - n12);
                for (n11 = 0; n11 < longsRef.length; ++n11) {
                    nArray2[n12++] = (int)longsRef.longs[longsRef.offset + n11];
                }
            }
        }
        this.reader.skip((long)n29 - this.reader.ord());
        this.reader.reset(this.vectorsStream, n29);
        n30 = 0;
        for (n14 = 0; n14 < n20; ++n14) {
            n13 = 0;
            while ((long)n13 < reader3.get(n14)) {
                n15 = (int)((long)n15 + this.reader.next());
                ++n13;
            }
        }
        for (n14 = 0; n14 < n18; ++n14) {
            n13 = (int)reader3.get(n20 + n14);
            nArray2 = new int[n13];
            nArrayArray2[n14] = nArray2;
            n12 = 0;
            while (n12 < n13) {
                longsRef = this.reader.next(n13 - n12);
                for (n11 = 0; n11 < longsRef.length; ++n11) {
                    nArray2[n12++] = (int)longsRef.longs[longsRef.offset + n11];
                }
            }
            nArray5[n14] = CompressingTermVectorsReader.sum(nArrayArray2[n14]);
            n28 += nArray5[n14];
        }
        n16 = n15 + n28;
        for (n14 = n20 + n18; n14 < n19; ++n14) {
            n13 = 0;
            while ((long)n13 < reader3.get(n14)) {
                n16 = (int)((long)n16 + this.reader.next());
                ++n13;
            }
        }
        int[] nArray6 = new int[n29];
        this.reader.reset(this.vectorsStream, n29);
        n14 = 0;
        while (n14 < n29) {
            LongsRef longsRef2 = this.reader.next(n29 - n14);
            for (int i3 = 0; i3 < longsRef2.length; ++i3) {
                nArray6[n14++] = 1 + (int)longsRef2.longs[longsRef2.offset + i3];
            }
        }
        n14 = 0;
        int n31 = 0;
        int n32 = 0;
        int n33 = 0;
        for (n12 = 0; n12 < n19; ++n12) {
            n11 = (int)reader.get(n12);
            int n34 = (int)reader3.get(n12);
            for (int i4 = 0; i4 < n34; ++i4) {
                n10 = nArray6[n33++];
                if ((n11 & 1) != 0) {
                    n14 += n10;
                }
                if ((n11 & 2) != 0) {
                    n31 += n10;
                }
                if ((n11 & 4) == 0) continue;
                n32 += n10;
            }
            assert (n12 != n19 - 1 || n33 == n29) : n33 + " " + n29;
        }
        int[][] nArray7 = this.positionIndex(n20, n18, reader3, nArray6);
        Object object4 = n14 > 0 ? (Object)this.readPositions(n20, n18, reader, reader3, nArray6, 1, n14, nArray7) : new int[n18][];
        if (n31 > 0) {
            float[] fArray = new float[nArray3.length];
            for (n10 = 0; n10 < fArray.length; ++n10) {
                fArray[n10] = Float.intBitsToFloat(this.vectorsStream.readInt());
            }
            object2 = this.readPositions(n20, n18, reader, reader3, nArray6, 2, n31, nArray7);
            object = this.readPositions(n20, n18, reader, reader3, nArray6, 2, n31, nArray7);
            for (n10 = 0; n10 < n18; ++n10) {
                nArray = object2[n10];
                int[] nArray8 = object4[n10];
                if (nArray != null && nArray8 != null) {
                    float f2 = fArray[nArray4[n10]];
                    for (n9 = 0; n9 < object2[n10].length; ++n9) {
                        int n35 = n9;
                        nArray[n35] = nArray[n35] + (int)(f2 * (float)nArray8[n9]);
                    }
                }
                if (nArray == null) continue;
                int[] nArray9 = nArrayArray[n10];
                int[] nArray10 = nArrayArray2[n10];
                int[] nArray11 = object[n10];
                n8 = (int)reader3.get(n20 + n10);
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = nArray9[n7] + nArray10[n7];
                    int[] nArray12 = object[n10];
                    int n36 = nArray7[n10][n7];
                    nArray12[n36] = nArray12[n36] + n6;
                    n5 = nArray7[n10][n7] + 1;
                    while (n5 < nArray7[n10][n7 + 1]) {
                        int n37 = n5;
                        nArray[n37] = nArray[n37] + nArray[n5 - 1];
                        int n38 = n5++;
                        nArray11[n38] = nArray11[n38] + n6;
                    }
                }
            }
        } else {
            object2 = object = new int[n18][];
        }
        if (n14 > 0) {
            for (int i5 = 0; i5 < n18; ++i5) {
                int[] nArray13 = object4[i5];
                nArray = nArray7[i5];
                if (nArray13 == null) continue;
                int n39 = (int)reader3.get(n20 + i5);
                for (int i6 = 0; i6 < n39; ++i6) {
                    for (n9 = nArray[i6] + 1; n9 < nArray[i6 + 1]; ++n9) {
                        int n40 = n9;
                        nArray13[n40] = nArray13[n40] + nArray13[n9 - 1];
                    }
                }
            }
        }
        int[][] nArrayArray3 = new int[n18][];
        int n41 = 0;
        int n42 = 0;
        int n43 = 0;
        if (n32 > 0) {
            this.reader.reset(this.vectorsStream, n32);
            int n44 = 0;
            for (n9 = 0; n9 < n20; ++n9) {
                int n45 = (int)reader.get(n9);
                n7 = (int)reader3.get(n9);
                if ((n45 & 4) != 0) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        n6 = nArray6[n44 + n8];
                        for (n5 = 0; n5 < n6; ++n5) {
                            n4 = (int)this.reader.next();
                            n42 += n4;
                        }
                    }
                }
                n44 += n7;
            }
            n41 = n42;
            for (n9 = 0; n9 < n18; ++n9) {
                int n46 = (int)reader.get(n20 + n9);
                n7 = (int)reader3.get(n20 + n9);
                if ((n46 & 4) != 0) {
                    n8 = nArray7[n9][n7];
                    nArrayArray3[n9] = new int[n8 + 1];
                    n6 = 0;
                    nArrayArray3[n9][n6] = n43;
                    for (n5 = 0; n5 < n7; ++n5) {
                        n4 = nArray6[n44 + n5];
                        for (n3 = 0; n3 < n4; ++n3) {
                            int n47 = (int)this.reader.next();
                            nArrayArray3[n9][n6 + 1] = n43 += n47;
                            ++n6;
                        }
                    }
                    assert (n6 == n8);
                }
                n44 += n7;
            }
            n41 += n43;
            for (n9 = n20 + n18; n9 < n19; ++n9) {
                int n48 = (int)reader.get(n9);
                n7 = (int)reader3.get(n9);
                if ((n48 & 4) != 0) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        n6 = nArray6[n44 + n8];
                        for (n5 = 0; n5 < n6; ++n5) {
                            n41 = (int)((long)n41 + this.reader.next());
                        }
                    }
                }
                n44 += n7;
            }
            assert (n44 == n29) : n44 + " " + n29;
        }
        BytesRef bytesRef = new BytesRef();
        this.decompressor.decompress(this.vectorsStream, n16 + n41, n15 + n42, n28 + n43, bytesRef);
        bytesRef.length = n28;
        BytesRef bytesRef2 = new BytesRef(bytesRef.bytes, bytesRef.offset + n28, n43);
        int[] nArray14 = new int[n18];
        for (n7 = 0; n7 < n18; ++n7) {
            nArray14[n7] = (int)reader.get(n20 + n7);
        }
        int[] nArray15 = new int[n18];
        for (n8 = 0; n8 < n18; ++n8) {
            nArray15[n8] = (int)reader3.get(n20 + n8);
        }
        int[][] nArrayArray4 = new int[n18][];
        n6 = 0;
        for (n5 = 0; n5 < n20; ++n5) {
            n6 = (int)((long)n6 + reader3.get(n5));
        }
        for (n5 = 0; n5 < n18; ++n5) {
            n4 = (int)reader3.get(n20 + n5);
            nArrayArray4[n5] = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArrayArray4[n5][n3] = nArray6[n6++];
            }
        }
        assert (CompressingTermVectorsReader.sum(nArray5) == n28) : CompressingTermVectorsReader.sum(nArray5) + " != " + n28;
        return new TVFields(nArray3, nArray14, nArray4, nArray15, nArray5, nArrayArray, nArrayArray2, nArrayArray4, nArray7, (int[][])object4, (int[][])object2, (int[][])object, bytesRef2, nArrayArray3, bytesRef);
    }

    private int[][] positionIndex(int n2, int n3, PackedInts.Reader reader, int[] nArray) {
        int n4;
        int n5;
        int[][] nArrayArray = new int[n3][];
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = (int)reader.get(n5);
            n6 += n4;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            n4 = (int)reader.get(n2 + n5);
            nArrayArray[n5] = new int[n4 + 1];
            for (int i2 = 0; i2 < n4; ++i2) {
                int n7 = nArray[n6 + i2];
                nArrayArray[n5][i2 + 1] = nArrayArray[n5][i2] + n7;
            }
            n6 += n4;
        }
        return nArrayArray;
    }

    private int[][] readPositions(int n2, int n3, PackedInts.Reader reader, PackedInts.Reader reader2, int[] nArray, int n4, int n5, int[][] nArray2) throws IOException {
        int n6;
        int n7;
        int n8;
        int n9;
        int[][] nArrayArray = new int[n3][];
        this.reader.reset(this.vectorsStream, n5);
        int n10 = 0;
        int n11 = 0;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = (int)reader.get(n9);
            n7 = (int)reader2.get(n9);
            if ((n8 & n4) != 0) {
                for (n6 = 0; n6 < n7; ++n6) {
                    int n12 = nArray[n11 + n6];
                    n10 += n12;
                }
            }
            n11 += n7;
        }
        this.reader.skip(n10);
        for (n9 = 0; n9 < n3; ++n9) {
            n8 = (int)reader.get(n2 + n9);
            n7 = (int)reader2.get(n2 + n9);
            if ((n8 & n4) != 0) {
                n6 = nArray2[n9][n7];
                int[] nArray3 = new int[n6];
                nArrayArray[n9] = nArray3;
                int n13 = 0;
                while (n13 < n6) {
                    LongsRef longsRef = this.reader.next(n6 - n13);
                    for (int i2 = 0; i2 < longsRef.length; ++i2) {
                        nArray3[n13++] = (int)longsRef.longs[longsRef.offset + i2];
                    }
                }
            }
            n11 += n7;
        }
        this.reader.skip((long)n5 - this.reader.ord());
        return nArrayArray;
    }

    private static int sum(int[] nArray) {
        int n2 = 0;
        for (int n3 : nArray) {
            n2 += n3;
        }
        return n2;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.singleton(org.apache.lucene.util.b.a("term vector index", this.indexReader));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private static class TVPostingsEnum
    extends PostingsEnum {
        private int doc = -1;
        private int termFreq;
        private int positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private final BytesRef payload = new BytesRef();
        private int[] payloadIndex;
        private int basePayloadOffset;
        private int i;

        TVPostingsEnum() {
        }

        public void reset(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, BytesRef bytesRef, int[] nArray4) {
            this.termFreq = n2;
            this.positionIndex = n3;
            this.positions = nArray;
            this.startOffsets = nArray2;
            this.lengths = nArray3;
            this.basePayloadOffset = bytesRef.offset;
            this.payload.bytes = bytesRef.bytes;
            this.payload.length = 0;
            this.payload.offset = 0;
            this.payloadIndex = nArray4;
            this.i = -1;
            this.doc = -1;
        }

        private void checkDoc() {
            if (this.doc == Integer.MAX_VALUE) {
                throw new IllegalStateException("DocsEnum exhausted");
            }
            if (this.doc == -1) {
                throw new IllegalStateException("DocsEnum not started");
            }
        }

        private void checkPosition() {
            this.checkDoc();
            if (this.i < 0) {
                throw new IllegalStateException("Position enum not started");
            }
            if (this.i >= this.termFreq) {
                throw new IllegalStateException("Read past last position");
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.doc != 0) {
                throw new IllegalStateException();
            }
            if (this.i >= this.termFreq - 1) {
                throw new IllegalStateException("Read past last position");
            }
            ++this.i;
            if (this.payloadIndex != null) {
                this.payload.offset = this.basePayloadOffset + this.payloadIndex[this.positionIndex + this.i];
                this.payload.length = this.payloadIndex[this.positionIndex + this.i + 1] - this.payloadIndex[this.positionIndex + this.i];
            }
            if (this.positions == null) {
                return -1;
            }
            return this.positions[this.positionIndex + this.i];
        }

        @Override
        public int startOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i];
        }

        @Override
        public int endOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i] + this.lengths[this.positionIndex + this.i];
        }

        @Override
        public BytesRef getPayload() throws IOException {
            this.checkPosition();
            if (this.payloadIndex == null || this.payload.length == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public int freq() throws IOException {
            this.checkDoc();
            return this.termFreq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == -1) {
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int n2) throws IOException {
            return this.slowAdvance(n2);
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private static class TVTermsEnum
    extends TermsEnum {
        private int numTerms;
        private int startPos;
        private int ord;
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int[] termFreqs;
        private int[] positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        private ByteArrayDataInput in;
        private BytesRef payloads;
        private final BytesRef term = new BytesRef(16);

        private TVTermsEnum() {
        }

        void reset(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, BytesRef bytesRef, ByteArrayDataInput byteArrayDataInput) {
            this.numTerms = n2;
            this.prefixLengths = nArray;
            this.suffixLengths = nArray2;
            this.termFreqs = nArray3;
            this.positionIndex = nArray4;
            this.positions = nArray5;
            this.startOffsets = nArray6;
            this.lengths = nArray7;
            this.payloadIndex = nArray8;
            this.payloads = bytesRef;
            this.in = byteArrayDataInput;
            this.startPos = byteArrayDataInput.getPosition();
            this.reset();
        }

        void reset() {
            this.term.length = 0;
            this.in.setPosition(this.startPos);
            this.ord = -1;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.ord == this.numTerms - 1) {
                return null;
            }
            assert (this.ord < this.numTerms);
            ++this.ord;
            this.term.offset = 0;
            this.term.length = this.prefixLengths[this.ord] + this.suffixLengths[this.ord];
            if (this.term.length > this.term.bytes.length) {
                this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
            }
            this.in.readBytes(this.term.bytes, this.prefixLengths[this.ord], this.suffixLengths[this.ord]);
            return this.term;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
            int n2;
            if (this.ord < this.numTerms && this.ord >= 0) {
                int n3 = this.term().compareTo(bytesRef);
                if (n3 == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (n3 > 0) {
                    this.reset();
                }
            }
            do {
                BytesRef bytesRef2;
                if ((bytesRef2 = this.next()) == null) {
                    return TermsEnum.SeekStatus.END;
                }
                n2 = bytesRef2.compareTo(bytesRef);
                if (n2 <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (n2 != 0);
            return TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long l2) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.termFreqs[this.ord];
        }

        @Override
        public final PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
            if (PostingsEnum.featureRequested(n2, (short)16384) && this.positions == null && this.startOffsets == null) {
                return null;
            }
            TVPostingsEnum tVPostingsEnum = postingsEnum != null && postingsEnum instanceof TVPostingsEnum ? (TVPostingsEnum)postingsEnum : new TVPostingsEnum();
            tVPostingsEnum.reset(this.termFreqs[this.ord], this.positionIndex[this.ord], this.positions, this.startOffsets, this.lengths, this.payloads, this.payloadIndex);
            return tVPostingsEnum;
        }
    }

    private class TVTerms
    extends Terms {
        private final int numTerms;
        private final int flags;
        private final int[] prefixLengths;
        private final int[] suffixLengths;
        private final int[] termFreqs;
        private final int[] positionIndex;
        private final int[] positions;
        private final int[] startOffsets;
        private final int[] lengths;
        private final int[] payloadIndex;
        private final BytesRef termBytes;
        private final BytesRef payloadBytes;

        TVTerms(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, BytesRef bytesRef, BytesRef bytesRef2) {
            this.numTerms = n2;
            this.flags = n3;
            this.prefixLengths = nArray;
            this.suffixLengths = nArray2;
            this.termFreqs = nArray3;
            this.positionIndex = nArray4;
            this.positions = nArray5;
            this.startOffsets = nArray6;
            this.lengths = nArray7;
            this.payloadIndex = nArray8;
            this.payloadBytes = bytesRef;
            this.termBytes = bytesRef2;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            TVTermsEnum tVTermsEnum = new TVTermsEnum();
            tVTermsEnum.reset(this.numTerms, this.flags, this.prefixLengths, this.suffixLengths, this.termFreqs, this.positionIndex, this.positions, this.startOffsets, this.lengths, this.payloadIndex, this.payloadBytes, new ByteArrayDataInput(this.termBytes.bytes, this.termBytes.offset, this.termBytes.length));
            return tVTermsEnum;
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.numTerms;
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasPositions() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasPayloads() {
            return (this.flags & 4) != 0;
        }
    }

    private class TVFields
    extends Fields {
        private final int[] fieldNums;
        private final int[] fieldFlags;
        private final int[] fieldNumOffs;
        private final int[] numTerms;
        private final int[] fieldLengths;
        private final int[][] prefixLengths;
        private final int[][] suffixLengths;
        private final int[][] termFreqs;
        private final int[][] positionIndex;
        private final int[][] positions;
        private final int[][] startOffsets;
        private final int[][] lengths;
        private final int[][] payloadIndex;
        private final BytesRef suffixBytes;
        private final BytesRef payloadBytes;

        public TVFields(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[][] nArray6, int[][] nArray7, int[][] nArray8, int[][] nArray9, int[][] nArray10, int[][] nArray11, int[][] nArray12, BytesRef bytesRef, int[][] nArray13, BytesRef bytesRef2) {
            this.fieldNums = nArray;
            this.fieldFlags = nArray2;
            this.fieldNumOffs = nArray3;
            this.numTerms = nArray4;
            this.fieldLengths = nArray5;
            this.prefixLengths = nArray6;
            this.suffixLengths = nArray7;
            this.termFreqs = nArray8;
            this.positionIndex = nArray9;
            this.positions = nArray10;
            this.startOffsets = nArray11;
            this.lengths = nArray12;
            this.payloadBytes = bytesRef;
            this.payloadIndex = nArray13;
            this.suffixBytes = bytesRef2;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < TVFields.this.fieldNumOffs.length;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int n2 = TVFields.this.fieldNums[TVFields.this.fieldNumOffs[this.i++]];
                    return ((CompressingTermVectorsReader)CompressingTermVectorsReader.this).fieldInfos.fieldInfo((int)n2).name;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Terms terms(String string) throws IOException {
            int n2;
            FieldInfo fieldInfo = CompressingTermVectorsReader.this.fieldInfos.fieldInfo(string);
            if (fieldInfo == null) {
                return null;
            }
            int n3 = -1;
            for (n2 = 0; n2 < this.fieldNumOffs.length; ++n2) {
                if (this.fieldNums[this.fieldNumOffs[n2]] != fieldInfo.number) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1 || this.numTerms[n3] == 0) {
                return null;
            }
            n2 = 0;
            int n4 = -1;
            for (int i2 = 0; i2 < this.fieldNumOffs.length; ++i2) {
                if (i2 < n3) {
                    n2 += this.fieldLengths[i2];
                    continue;
                }
                n4 = this.fieldLengths[i2];
                break;
            }
            assert (n4 >= 0);
            return new TVTerms(this.numTerms[n3], this.fieldFlags[n3], this.prefixLengths[n3], this.suffixLengths[n3], this.termFreqs[n3], this.positionIndex[n3], this.positions[n3], this.startOffsets[n3], this.lengths[n3], this.payloadIndex[n3], this.payloadBytes, new BytesRef(this.suffixBytes.bytes, this.suffixBytes.offset + n2, n4));
        }

        @Override
        public int size() {
            return this.fieldNumOffs.length;
        }
    }
}

