/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

final class LZ4 {
    private LZ4() {
    }

    private static int hash(int n2, int n3) {
        return n2 * -1640531535 >>> 32 - n3;
    }

    private static int hashHC(int n2) {
        return LZ4.hash(n2, 15);
    }

    private static int readInt(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    private static boolean readIntEquals(byte[] byArray, int n2, int n3) {
        return LZ4.readInt(byArray, n2) == LZ4.readInt(byArray, n3);
    }

    private static int commonBytes(byte[] byArray, int n2, int n3, int n4) {
        assert (n2 < n3);
        int n5 = 0;
        while (n3 < n4 && byArray[n2++] == byArray[n3++]) {
            ++n5;
        }
        return n5;
    }

    private static int commonBytesBackward(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n2 > n4 && n3 > n5 && byArray[--n2] == byArray[--n3]) {
            ++n6;
        }
        return n6;
    }

    public static int decompress(DataInput dataInput, int n2, byte[] byArray, int n3) throws IOException {
        int n4 = byArray.length;
        do {
            int n5;
            int n6;
            int n7;
            int n8;
            if ((n8 = (n7 = dataInput.readByte() & 0xFF) >>> 4) != 0) {
                if (n8 == 15) {
                    while ((n6 = dataInput.readByte()) == -1) {
                        n8 += 255;
                    }
                    n8 += n6 & 0xFF;
                }
                dataInput.readBytes(byArray, n3, n8);
                n3 += n8;
            }
            if (n3 >= n2) break;
            n6 = dataInput.readByte() & 0xFF | (dataInput.readByte() & 0xFF) << 8;
            assert (n6 > 0);
            int n9 = n7 & 0xF;
            if (n9 == 15) {
                while ((n5 = dataInput.readByte()) == -1) {
                    n9 += 255;
                }
                n9 += n5 & 0xFF;
            }
            n5 = (n9 += 4) + 7 & 0xFFFFFFF8;
            if (n6 < n9 || n3 + n5 > n4) {
                int n10 = n3 - n6;
                int n11 = n3 + n9;
                while (n3 < n11) {
                    byArray[n3] = byArray[n10];
                    ++n10;
                    ++n3;
                }
            } else {
                System.arraycopy(byArray, n3 - n6, byArray, n3, n5);
                n3 += n9;
            }
        } while (n3 < n2);
        return n3;
    }

    private static void encodeLen(int n2, DataOutput dataOutput) throws IOException {
        while (n2 >= 255) {
            dataOutput.writeByte((byte)-1);
            n2 -= 255;
        }
        dataOutput.writeByte((byte)n2);
    }

    private static void encodeLiterals(byte[] byArray, int n2, int n3, int n4, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)n2);
        if (n4 >= 15) {
            LZ4.encodeLen(n4 - 15, dataOutput);
        }
        dataOutput.writeBytes(byArray, n3, n4);
    }

    private static void encodeLastLiterals(byte[] byArray, int n2, int n3, DataOutput dataOutput) throws IOException {
        int n4 = Math.min(n3, 15) << 4;
        LZ4.encodeLiterals(byArray, n4, n2, n3, dataOutput);
    }

    private static void encodeSequence(byte[] byArray, int n2, int n3, int n4, int n5, DataOutput dataOutput) throws IOException {
        int n6 = n4 - n2;
        assert (n5 >= 4);
        int n7 = Math.min(n6, 15) << 4 | Math.min(n5 - 4, 15);
        LZ4.encodeLiterals(byArray, n7, n2, n6, dataOutput);
        int n8 = n4 - n3;
        assert (n8 > 0 && n8 < 65536);
        dataOutput.writeByte((byte)n8);
        dataOutput.writeByte((byte)(n8 >>> 8));
        if (n5 >= 19) {
            LZ4.encodeLen(n5 - 15 - 4, dataOutput);
        }
    }

    public static void compress(byte[] byArray, int n2, int n3, DataOutput dataOutput, HashTable hashTable) throws IOException {
        int n4;
        int n5 = n2;
        int n6 = n2 + n3;
        int n7 = n2++;
        if (n3 > 9) {
            n4 = n6 - 5;
            int n8 = n4 - 4;
            hashTable.reset(n3);
            int n9 = hashTable.hashLog;
            PackedInts.Mutable mutable = hashTable.hashTable;
            block0: while (n2 <= n4) {
                while (n2 < n8) {
                    int n10 = LZ4.readInt(byArray, n2);
                    int n11 = LZ4.hash(n10, n9);
                    int n12 = n5 + (int)mutable.get(n11);
                    assert (PackedInts.bitsRequired(n2 - n5) <= mutable.getBitsPerValue());
                    mutable.set(n11, n2 - n5);
                    if (n2 - n12 >= 65536 || LZ4.readInt(byArray, n12) != n10) {
                        ++n2;
                        continue;
                    }
                    n10 = 4 + LZ4.commonBytes(byArray, n12 + 4, n2 + 4, n4);
                    LZ4.encodeSequence(byArray, n7, n12, n2, n10, dataOutput);
                    n7 = n2 += n10;
                    continue block0;
                }
                break block0;
            }
        }
        n4 = n6 - n7;
        assert (n4 >= 5 || n4 == n3);
        LZ4.encodeLastLiterals(byArray, n7, n6 - n7, dataOutput);
    }

    private static void copyTo(Match match, Match match2) {
        match2.len = match.len;
        match2.start = match.start;
        match2.ref = match.ref;
    }

    public static void compressHC(byte[] byArray, int n2, int n3, DataOutput dataOutput, HCHashTable hCHashTable) throws IOException {
        int n4 = n2 + n3;
        int n5 = n4 - 5;
        int n6 = n5 - 4;
        int n7 = n2;
        int n8 = n7++;
        hCHashTable.reset(n2);
        Match match = new Match();
        Match match2 = new Match();
        Match match3 = new Match();
        Match match4 = new Match();
        block0: while (n7 <= n6) {
            if (!hCHashTable.insertAndFindBestMatch(byArray, n7, n5, match2)) {
                ++n7;
                continue;
            }
            LZ4.copyTo(match2, match);
            block1: while (true) {
                assert (match2.start >= n8);
                if (match2.end() >= n6 || !hCHashTable.insertAndFindWiderMatch(byArray, match2.end() - 2, match2.start + 1, n5, match2.len, match3)) {
                    LZ4.encodeSequence(byArray, n8, match2.ref, match2.start, match2.len, dataOutput);
                    n8 = n7 = match2.end();
                    continue block0;
                }
                if (match.start < match2.start && match3.start < match2.start + match.len) {
                    LZ4.copyTo(match, match2);
                }
                assert (match3.start > match2.start);
                if (match3.start - match2.start < 3) {
                    LZ4.copyTo(match3, match2);
                    continue;
                }
                while (true) {
                    int n9;
                    if (match3.start - match2.start < 18) {
                        int n10;
                        n9 = match2.len;
                        if (n9 > 18) {
                            n9 = 18;
                        }
                        if (match2.start + n9 > match3.end() - 4) {
                            n9 = match3.start - match2.start + match3.len - 4;
                        }
                        if ((n10 = n9 - (match3.start - match2.start)) > 0) {
                            match3.fix(n10);
                        }
                    }
                    if (match3.start + match3.len >= n6 || !hCHashTable.insertAndFindWiderMatch(byArray, match3.end() - 3, match3.start, n5, match3.len, match4)) {
                        if (match3.start < match2.end()) {
                            match2.len = match3.start - match2.start;
                        }
                        LZ4.encodeSequence(byArray, n8, match2.ref, match2.start, match2.len, dataOutput);
                        n8 = n7 = match2.end();
                        LZ4.encodeSequence(byArray, n8, match3.ref, match3.start, match3.len, dataOutput);
                        n8 = n7 = match3.end();
                        continue block0;
                    }
                    if (match4.start < match2.end() + 3) {
                        if (match4.start >= match2.end()) {
                            if (match3.start < match2.end()) {
                                n9 = match2.end() - match3.start;
                                match3.fix(n9);
                                if (match3.len < 4) {
                                    LZ4.copyTo(match4, match3);
                                }
                            }
                            LZ4.encodeSequence(byArray, n8, match2.ref, match2.start, match2.len, dataOutput);
                            n8 = n7 = match2.end();
                            LZ4.copyTo(match4, match2);
                            LZ4.copyTo(match3, match);
                            continue block1;
                        }
                        LZ4.copyTo(match4, match3);
                        continue;
                    }
                    if (match3.start < match2.end()) {
                        if (match3.start - match2.start < 15) {
                            if (match2.len > 18) {
                                match2.len = 18;
                            }
                            if (match2.end() > match3.end() - 4) {
                                match2.len = match3.end() - match2.start - 4;
                            }
                            n9 = match2.end() - match3.start;
                            match3.fix(n9);
                        } else {
                            match2.len = match3.start - match2.start;
                        }
                    }
                    LZ4.encodeSequence(byArray, n8, match2.ref, match2.start, match2.len, dataOutput);
                    n8 = n7 = match2.end();
                    LZ4.copyTo(match3, match2);
                    LZ4.copyTo(match4, match3);
                }
                break;
            }
        }
        LZ4.encodeLastLiterals(byArray, n8, n4 - n8, dataOutput);
    }

    static final class HCHashTable {
        int nextToUpdate;
        private int base;
        private final int[] hashTable = new int[32768];
        private final short[] chainTable = new short[65536];

        HCHashTable() {
        }

        private void reset(int n2) {
            this.base = n2;
            this.nextToUpdate = n2;
            Arrays.fill(this.hashTable, -1);
            Arrays.fill(this.chainTable, (short)0);
        }

        private int hashPointer(byte[] byArray, int n2) {
            int n3 = LZ4.readInt(byArray, n2);
            int n4 = LZ4.hashHC(n3);
            return this.hashTable[n4];
        }

        private int next(int n2) {
            return n2 - (this.chainTable[n2 & 0xFFFF] & 0xFFFF);
        }

        private void addHash(byte[] byArray, int n2) {
            int n3 = LZ4.readInt(byArray, n2);
            int n4 = LZ4.hashHC(n3);
            int n5 = n2 - this.hashTable[n4];
            assert (n5 > 0) : n5;
            if (n5 >= 65536) {
                n5 = 65535;
            }
            this.chainTable[n2 & 0xFFFF] = (short)n5;
            this.hashTable[n4] = n2;
        }

        void insert(int n2, byte[] byArray) {
            while (this.nextToUpdate < n2) {
                this.addHash(byArray, this.nextToUpdate);
                ++this.nextToUpdate;
            }
        }

        boolean insertAndFindBestMatch(byte[] byArray, int n2, int n3, Match match) {
            int n4;
            int n5;
            match.start = n2;
            match.len = 0;
            int n6 = 0;
            int n7 = 0;
            this.insert(n2, byArray);
            int n8 = this.hashPointer(byArray, n2);
            if (n8 >= n2 - 4 && n8 <= n2 && n8 >= this.base) {
                if (LZ4.readIntEquals(byArray, n8, n2)) {
                    n6 = n2 - n8;
                    n7 = match.len = 4 + LZ4.commonBytes(byArray, n8 + 4, n2 + 4, n3);
                    match.ref = n8;
                }
                n8 = this.next(n8);
            }
            for (n5 = 0; n5 < 256 && n8 >= Math.max(this.base, n2 - 65536 + 1) && n8 <= n2; ++n5) {
                if (byArray[n8 + match.len] == byArray[n2 + match.len] && LZ4.readIntEquals(byArray, n8, n2) && (n4 = 4 + LZ4.commonBytes(byArray, n8 + 4, n2 + 4, n3)) > match.len) {
                    match.ref = n8;
                    match.len = n4;
                }
                n8 = this.next(n8);
            }
            if (n7 != 0) {
                n4 = n2 + n7 - 3;
                for (n5 = n2; n5 < n4 - n6; ++n5) {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                }
                do {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                    this.hashTable[LZ4.hashHC((int)LZ4.readInt((byte[])byArray, (int)n5))] = n5;
                } while (++n5 < n4);
                this.nextToUpdate = n4;
            }
            return match.len != 0;
        }

        boolean insertAndFindWiderMatch(byte[] byArray, int n2, int n3, int n4, int n5, Match match) {
            match.len = n5;
            this.insert(n2, byArray);
            int n6 = n2 - n3;
            int n7 = this.hashPointer(byArray, n2);
            for (int i2 = 0; i2 < 256 && n7 >= Math.max(this.base, n2 - 65536 + 1) && n7 <= n2; ++i2) {
                if (byArray[n7 - n6 + match.len] == byArray[n3 + match.len] && LZ4.readIntEquals(byArray, n7, n2)) {
                    int n8 = 4 + LZ4.commonBytes(byArray, n7 + 4, n2 + 4, n4);
                    int n9 = LZ4.commonBytesBackward(byArray, n7, n2, this.base, n3);
                    int n10 = n9 + n8;
                    if (n10 > match.len) {
                        match.len = n10;
                        match.ref = n7 - n9;
                        match.start = n2 - n9;
                    }
                }
                n7 = this.next(n7);
            }
            return match.len > n5;
        }
    }

    private static class Match {
        int start;
        int ref;
        int len;

        private Match() {
        }

        void fix(int n2) {
            this.start += n2;
            this.ref += n2;
            this.len -= n2;
        }

        int end() {
            return this.start + this.len;
        }
    }

    static final class HashTable {
        private int hashLog;
        private PackedInts.Mutable hashTable;

        HashTable() {
        }

        void reset(int n2) {
            int n3 = PackedInts.bitsRequired(n2 - 5);
            int n4 = 32 - Integer.numberOfLeadingZeros(n3 - 1);
            this.hashLog = 17 - n4;
            if (this.hashTable == null || this.hashTable.size() < 1 << this.hashLog || this.hashTable.getBitsPerValue() < n3) {
                this.hashTable = PackedInts.getMutable(1 << this.hashLog, n3, 0.25f);
            } else {
                this.hashTable.clear();
            }
        }
    }
}

