/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.f;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.h;

public final class Lucene50LiveDocsFormat
extends f {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    @Override
    public h newLiveDocs(int n2) throws IOException {
        FixedBitSet fixedBitSet = new FixedBitSet(n2);
        fixedBitSet.set(0, n2);
        return fixedBitSet;
    }

    @Override
    public h newLiveDocs(Bits bits) throws IOException {
        FixedBitSet fixedBitSet = (FixedBitSet)bits;
        return fixedBitSet.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(c c2, SegmentCommitInfo segmentCommitInfo, IOContext iOContext) throws IOException {
        block21: {
            long l2 = segmentCommitInfo.getDelGen();
            String string = IndexFileNames.fileNameFromGeneration(segmentCommitInfo.info.name, EXTENSION, l2);
            int n2 = segmentCommitInfo.info.maxDoc();
            Throwable throwable = null;
            try (b b2 = c2.openChecksumInput(string, iOContext);){
                FixedBitSet fixedBitSet;
                Throwable throwable2 = null;
                try {
                    CodecUtil.checkIndexHeader(b2, CODEC_NAME, 0, 0, segmentCommitInfo.info.getId(), Long.toString(l2, 36));
                    long[] lArray = new long[FixedBitSet.bits2words(n2)];
                    for (int i2 = 0; i2 < lArray.length; ++i2) {
                        lArray[i2] = b2.readLong();
                    }
                    FixedBitSet fixedBitSet2 = new FixedBitSet(lArray, n2);
                    if (fixedBitSet2.length() - fixedBitSet2.cardinality() != segmentCommitInfo.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fixedBitSet2.length() - fixedBitSet2.cardinality()) + " info.delcount=" + segmentCommitInfo.getDelCount(), b2);
                    }
                    fixedBitSet = fixedBitSet2;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                        }
                        catch (Throwable throwable4) {
                            CodecUtil.checkFooter(b2, throwable2);
                            throw throwable4;
                        }
                        CodecUtil.checkFooter(b2, throwable2);
                        break block21;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
                CodecUtil.checkFooter(b2, throwable2);
                return fixedBitSet;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeLiveDocs(h h2, c c2, SegmentCommitInfo segmentCommitInfo, int n2, IOContext iOContext) throws IOException {
        long l2 = segmentCommitInfo.getNextDelGen();
        String string = IndexFileNames.fileNameFromGeneration(segmentCommitInfo.info.name, EXTENSION, l2);
        FixedBitSet fixedBitSet = (FixedBitSet)h2;
        if (fixedBitSet.length() - fixedBitSet.cardinality() != segmentCommitInfo.getDelCount() + n2) {
            throw new CorruptIndexException("bits.deleted=" + (fixedBitSet.length() - fixedBitSet.cardinality()) + " info.delcount=" + segmentCommitInfo.getDelCount() + " newdelcount=" + n2, string);
        }
        long[] lArray = fixedBitSet.getBits();
        try (IndexOutput indexOutput = c2.createOutput(string, iOContext);){
            CodecUtil.writeIndexHeader(indexOutput, CODEC_NAME, 0, segmentCommitInfo.info.getId(), Long.toString(l2, 36));
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                indexOutput.writeLong(lArray[i2]);
            }
            CodecUtil.writeFooter(indexOutput);
        }
    }

    @Override
    public void files(SegmentCommitInfo segmentCommitInfo, Collection<String> collection) throws IOException {
        if (segmentCommitInfo.hasDeletions()) {
            collection.add(IndexFileNames.fileNameFromGeneration(segmentCommitInfo.info.name, EXTENSION, segmentCommitInfo.getDelGen()));
        }
    }
}

