/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.l;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Version;

public class Lucene50SegmentInfoFormat
extends l {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(c c2, String string, byte[] byArray, IOContext iOContext) throws IOException {
        String string2 = IndexFileNames.segmentFileName(string, "", SI_EXTENSION);
        try (b b2 = c2.openChecksumInput(string2, iOContext);){
            Throwable throwable = null;
            SegmentInfo segmentInfo = null;
            try {
                Map<String, String> map;
                Set<String> set;
                Map<String, String> map2;
                boolean bl;
                int n2 = CodecUtil.checkIndexHeader(b2, CODEC_NAME, 0, 1, byArray, "");
                Version version = Version.fromBits(b2.readInt(), b2.readInt(), b2.readInt());
                int n3 = b2.readInt();
                if (n3 < 0) {
                    throw new CorruptIndexException("invalid docCount: " + n3, b2);
                }
                boolean bl2 = bl = b2.readByte() == 1;
                if (n2 >= 1) {
                    map2 = b2.readMapOfStrings();
                    set = b2.readSetOfStrings();
                    map = b2.readMapOfStrings();
                } else {
                    map2 = Collections.unmodifiableMap(b2.readStringStringMap());
                    set = Collections.unmodifiableSet(b2.readStringSet());
                    map = Collections.unmodifiableMap(b2.readStringStringMap());
                }
                segmentInfo = new SegmentInfo(c2, version, string, n3, bl, null, map2, byArray, map);
                segmentInfo.setFiles(set);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                CodecUtil.checkFooter(b2, throwable);
            }
            SegmentInfo segmentInfo2 = segmentInfo;
            return segmentInfo2;
        }
    }

    @Override
    public void write(c c2, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        String string = IndexFileNames.segmentFileName(segmentInfo.name, "", SI_EXTENSION);
        try (IndexOutput indexOutput = c2.createOutput(string, iOContext);){
            segmentInfo.addFile(string);
            CodecUtil.writeIndexHeader(indexOutput, CODEC_NAME, 1, segmentInfo.getId(), "");
            Version version = segmentInfo.getVersion();
            if (version.major < 5) {
                throw new IllegalArgumentException("invalid major version: should be >= 5 but got: " + version.major + " segment=" + segmentInfo);
            }
            indexOutput.writeInt(version.major);
            indexOutput.writeInt(version.minor);
            indexOutput.writeInt(version.bugfix);
            assert (version.prerelease == 0);
            indexOutput.writeInt(segmentInfo.maxDoc());
            indexOutput.writeByte((byte)(segmentInfo.getUseCompoundFile() ? 1 : -1));
            indexOutput.writeMapOfStrings(segmentInfo.getDiagnostics());
            Set<String> set = segmentInfo.files();
            for (String string2 : set) {
                if (IndexFileNames.parseSegmentName(string2).equals(segmentInfo.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + segmentInfo.name + ", got=" + set);
            }
            indexOutput.writeSetOfStrings(set);
            indexOutput.writeMapOfStrings(segmentInfo.getAttributes());
            CodecUtil.writeFooter(indexOutput);
        }
    }
}

