/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.m;
import org.apache.lucene.codecs.n;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;

public final class Lucene50StoredFieldsFormat
extends m {
    public static final String MODE_KEY = Lucene50StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;

    public Lucene50StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene50StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    @Override
    public n fieldsReader(c c2, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext iOContext) throws IOException {
        String string = segmentInfo.getAttribute(MODE_KEY);
        if (string == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + segmentInfo.name);
        }
        Mode mode = Mode.valueOf(string);
        return this.impl(mode).fieldsReader(c2, segmentInfo, fieldInfos, iOContext);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(c c2, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        String string = segmentInfo.putAttribute(MODE_KEY, this.mode.name());
        if (string != null) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + segmentInfo.name + "old=" + string + ", new=" + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(c2, segmentInfo, iOContext);
    }

    m impl(Mode mode) {
        switch (mode) {
            case BEST_SPEED: {
                return new CompressingStoredFieldsFormat("Lucene50StoredFieldsFast", CompressionMode.FAST, 16384, 128, 1024);
            }
            case BEST_COMPRESSION: {
                return new CompressingStoredFieldsFormat("Lucene50StoredFieldsHigh", CompressionMode.HIGH_COMPRESSION, 61440, 512, 1024);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

