/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.g;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

class Lucene53NormsConsumer
extends g {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene53NormsConsumer(SegmentWriteState segmentWriteState, String string, String string2, String string3, String string4) throws IOException {
        boolean bl = false;
        try {
            String string5 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string2);
            this.data = segmentWriteState.directory.createOutput(string5, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.data, string, 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            String string6 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string4);
            this.meta = segmentWriteState.directory.createOutput(string6, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.meta, string3, 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            this.maxDoc = segmentWriteState.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNormsField(FieldInfo fieldInfo, Iterable<Number> iterable) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        int n2 = 0;
        for (Number number : iterable) {
            if (number == null) {
                throw new IllegalStateException("illegal norms data for field " + fieldInfo.name + ", got null for value: " + n2);
            }
            long l4 = number.longValue();
            l2 = Math.min(l2, l4);
            l3 = Math.max(l3, l4);
            ++n2;
        }
        if (n2 != this.maxDoc) {
            throw new IllegalStateException("illegal norms data for field " + fieldInfo.name + ", expected count=" + this.maxDoc + ", got=" + n2);
        }
        if (l2 == l3) {
            this.addConstant(l2);
        } else if (l2 >= -128L && l3 <= 127L) {
            this.addByte1(iterable);
        } else if (l2 >= -32768L && l3 <= 32767L) {
            this.addByte2(iterable);
        } else if (l2 >= Integer.MIN_VALUE && l3 <= Integer.MAX_VALUE) {
            this.addByte4(iterable);
        } else {
            this.addByte8(iterable);
        }
    }

    private void addConstant(long l2) throws IOException {
        this.meta.writeByte((byte)0);
        this.meta.writeLong(l2);
    }

    private void addByte1(Iterable<Number> iterable) throws IOException {
        this.meta.writeByte((byte)1);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number number : iterable) {
            this.data.writeByte(number.byteValue());
        }
    }

    private void addByte2(Iterable<Number> iterable) throws IOException {
        this.meta.writeByte((byte)2);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number number : iterable) {
            this.data.writeShort(number.shortValue());
        }
    }

    private void addByte4(Iterable<Number> iterable) throws IOException {
        this.meta.writeByte((byte)4);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number number : iterable) {
            this.data.writeInt(number.intValue());
        }
    }

    private void addByte8(Iterable<Number> iterable) throws IOException {
        this.meta.writeByte((byte)8);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number number : iterable) {
            this.data.writeLong(number.longValue());
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean bl = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(bl = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }
}

