/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.i;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.m;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.h;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.a;

class Lucene53NormsProducer
extends i {
    private final Map<Integer, NormsEntry> norms;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene53NormsProducer(SegmentReadState segmentReadState, String string, String string2, String string3, String string4) throws IOException {
        Object object;
        int n2;
        block20: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = segmentReadState.segmentInfo.maxDoc();
            String string5 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string4);
            n2 = -1;
            object = segmentReadState.directory.openChecksumInput(string5, segmentReadState.context);
            Throwable throwable = null;
            try {
                Throwable throwable2 = null;
                try {
                    n2 = CodecUtil.checkIndexHeader((DataInput)object, string3, 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                    this.readFields((IndexInput)object, segmentReadState.fieldInfos);
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        break block20;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        CodecUtil.checkFooter((b)object, throwable2);
                    }
                }
                CodecUtil.checkFooter((b)object, throwable2);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((IndexInput)object).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        ((IndexInput)object).close();
                    }
                }
            }
        }
        object = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string2);
        this.data = segmentReadState.directory.openInput((String)object, segmentReadState.context);
        boolean bl = false;
        try {
            int n3 = CodecUtil.checkIndexHeader(this.data, string, 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            if (n2 != n3) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + n2 + ",data=" + n3, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        int n2 = indexInput.readVInt();
        while (n2 != -1) {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(n2);
            if (fieldInfo == null) {
                throw new CorruptIndexException("Invalid field number: " + n2, indexInput);
            }
            if (!fieldInfo.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + fieldInfo.name, indexInput);
            }
            NormsEntry normsEntry = new NormsEntry();
            normsEntry.bytesPerValue = indexInput.readByte();
            switch (normsEntry.bytesPerValue) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + normsEntry.bytesPerValue + ", field: " + fieldInfo.name, indexInput);
                }
            }
            normsEntry.offset = indexInput.readLong();
            this.norms.put(fieldInfo.number, normsEntry);
            n2 = indexInput.readVInt();
        }
    }

    @Override
    public m getNorms(FieldInfo fieldInfo) throws IOException {
        NormsEntry normsEntry = this.norms.get(fieldInfo.number);
        if (normsEntry.bytesPerValue == 0) {
            final long l2 = normsEntry.offset;
            return new m(){

                @Override
                public long get(int n2) {
                    return l2;
                }
            };
        }
        IndexInput indexInput = this.data;
        synchronized (indexInput) {
            switch (normsEntry.bytesPerValue) {
                case 1: {
                    final h h2 = this.data.randomAccessSlice(normsEntry.offset, this.maxDoc);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h2.readByte(n2);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 2: {
                    final h h3 = this.data.randomAccessSlice(normsEntry.offset, (long)this.maxDoc * 2L);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h3.readShort((long)n2 << 1);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 4: {
                    final h h4 = this.data.randomAccessSlice(normsEntry.offset, (long)this.maxDoc * 4L);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h4.readInt((long)n2 << 2);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 8: {
                    final h h5 = this.data.randomAccessSlice(normsEntry.offset, (long)this.maxDoc * 8L);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h5.readLong((long)n2 << 3);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
            }
            throw new AssertionError();
        }
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static class NormsEntry {
        byte bytesPerValue;
        long offset;

        NormsEntry() {
        }
    }
}

