/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.j;
import org.apache.lucene.util.BytesRef;

public class Field
implements j {
    protected final FieldType type;
    protected final String name;
    protected Object fieldsData;
    protected TokenStream tokenStream;
    protected float boost = 1.0f;

    protected Field(String string, FieldType fieldType) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
        if (fieldType == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type = fieldType;
    }

    public Field(String string, byte[] byArray, FieldType fieldType) {
        this(string, byArray, 0, byArray.length, fieldType);
    }

    public Field(String string, byte[] byArray, int n2, int n3, FieldType fieldType) {
        this(string, new BytesRef(byArray, n2, n3), fieldType);
    }

    public Field(String string, BytesRef bytesRef, FieldType fieldType) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (bytesRef == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        this.fieldsData = bytesRef;
        this.type = fieldType;
        this.name = string;
    }

    public Field(String string, String string2, FieldType fieldType) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (!fieldType.stored() && fieldType.indexOptions() == IndexOptions.NONE) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        this.type = fieldType;
        this.name = string;
        this.fieldsData = string2;
    }

    @Override
    public String stringValue() {
        if (this.fieldsData instanceof String || this.fieldsData instanceof Number) {
            return this.fieldsData.toString();
        }
        return null;
    }

    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public float boost() {
        return this.boost;
    }

    @Override
    public Number numericValue() {
        if (this.fieldsData instanceof Number) {
            return (Number)this.fieldsData;
        }
        return null;
    }

    @Override
    public BytesRef binaryValue() {
        if (this.fieldsData instanceof BytesRef) {
            return (BytesRef)this.fieldsData;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type.toString());
        stringBuilder.append('<');
        stringBuilder.append(this.name);
        stringBuilder.append(':');
        if (this.fieldsData != null) {
            stringBuilder.append(this.fieldsData);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public FieldType fieldType() {
        return this.type;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream tokenStream) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        FieldType.NumericType numericType = this.fieldType().numericType();
        if (numericType != null) {
            if (!(tokenStream instanceof NumericTokenStream) || ((NumericTokenStream)tokenStream).getPrecisionStep() != this.type.numericPrecisionStep()) {
                tokenStream = new NumericTokenStream(this.type.numericPrecisionStep());
            }
            NumericTokenStream numericTokenStream = (NumericTokenStream)tokenStream;
            Number number = (Number)this.fieldsData;
            switch (numericType) {
                case INT: {
                    numericTokenStream.setIntValue(number.intValue());
                    break;
                }
                case LONG: {
                    numericTokenStream.setLongValue(number.longValue());
                    break;
                }
                case FLOAT: {
                    numericTokenStream.setFloatValue(number.floatValue());
                    break;
                }
                case DOUBLE: {
                    numericTokenStream.setDoubleValue(number.doubleValue());
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here");
                }
            }
            return tokenStream;
        }
        if (!this.fieldType().tokenized()) {
            if (this.stringValue() != null) {
                if (!(tokenStream instanceof StringTokenStream)) {
                    tokenStream = new StringTokenStream();
                }
                ((StringTokenStream)tokenStream).setValue(this.stringValue());
                return tokenStream;
            }
            if (this.binaryValue() != null) {
                if (!(tokenStream instanceof BinaryTokenStream)) {
                    tokenStream = new BinaryTokenStream();
                }
                ((BinaryTokenStream)tokenStream).setValue(this.binaryValue());
                return tokenStream;
            }
            throw new IllegalArgumentException("Non-Tokenized Fields must have a String value");
        }
        if (this.tokenStream != null) {
            return this.tokenStream;
        }
        if (this.readerValue() != null) {
            return analyzer.tokenStream(this.name(), this.readerValue());
        }
        if (this.stringValue() != null) {
            return analyzer.tokenStream(this.name(), this.stringValue());
        }
        throw new IllegalArgumentException("Field must have either TokenStream, String, Reader or Number value; got " + this);
    }

    @Deprecated
    public static enum TermVector {
        NO{}
        ,
        YES{}
        ,
        WITH_POSITIONS{}
        ,
        WITH_OFFSETS{}
        ,
        WITH_POSITIONS_OFFSETS{};

    }

    @Deprecated
    public static enum Index {
        NO{}
        ,
        ANALYZED{}
        ,
        NOT_ANALYZED{}
        ,
        NOT_ANALYZED_NO_NORMS{}
        ,
        ANALYZED_NO_NORMS{};

    }

    public static enum Store {
        YES,
        NO;

    }

    private static final class StringTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
        private boolean used = true;
        private String value = null;

        StringTokenStream() {
        }

        void setValue(String string) {
            this.value = string;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.value.length());
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            int n2 = this.value.length();
            this.offsetAttribute.setOffset(n2, n2);
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }

    private static final class BinaryTokenStream
    extends TokenStream {
        private final BytesTermAttribute bytesAtt = this.addAttribute(BytesTermAttribute.class);
        private boolean used = true;
        private BytesRef value;

        BinaryTokenStream() {
        }

        public void setValue(BytesRef bytesRef) {
            this.value = bytesRef;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.bytesAtt.setBytesRef(this.value);
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }
}

