/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;

public final class CompositeReaderContext
extends IndexReaderContext {
    private final List<IndexReaderContext> children;
    private final List<LeafReaderContext> leaves;
    private final CompositeReader reader;

    static CompositeReaderContext create(CompositeReader compositeReader) {
        return new Builder(compositeReader).build();
    }

    CompositeReaderContext(CompositeReaderContext compositeReaderContext, CompositeReader compositeReader, int n2, int n3, List<IndexReaderContext> list) {
        this(compositeReaderContext, compositeReader, n2, n3, list, null);
    }

    CompositeReaderContext(CompositeReader compositeReader, List<IndexReaderContext> list, List<LeafReaderContext> list2) {
        this(null, compositeReader, 0, 0, list, list2);
    }

    private CompositeReaderContext(CompositeReaderContext compositeReaderContext, CompositeReader compositeReader, int n2, int n3, List<IndexReaderContext> list, List<LeafReaderContext> list2) {
        super(compositeReaderContext, n2, n3);
        this.children = Collections.unmodifiableList(list);
        this.leaves = list2 == null ? null : Collections.unmodifiableList(list2);
        this.reader = compositeReader;
    }

    @Override
    public List<LeafReaderContext> leaves() throws UnsupportedOperationException {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public CompositeReader reader() {
        return this.reader;
    }

    private static final class Builder {
        private final CompositeReader reader;
        private final List<LeafReaderContext> leaves = new ArrayList<LeafReaderContext>();
        private int leafDocBase = 0;

        public Builder(CompositeReader compositeReader) {
            this.reader = compositeReader;
        }

        public CompositeReaderContext build() {
            return (CompositeReaderContext)this.build(null, this.reader, 0, 0);
        }

        private IndexReaderContext build(CompositeReaderContext compositeReaderContext, IndexReader indexReader, int n2, int n3) {
            if (indexReader instanceof LeafReader) {
                LeafReader leafReader = (LeafReader)indexReader;
                LeafReaderContext leafReaderContext = new LeafReaderContext(compositeReaderContext, leafReader, n2, n3, this.leaves.size(), this.leafDocBase);
                this.leaves.add(leafReaderContext);
                this.leafDocBase += indexReader.maxDoc();
                return leafReaderContext;
            }
            CompositeReader compositeReader = (CompositeReader)indexReader;
            List<? extends IndexReader> list = compositeReader.getSequentialSubReaders();
            List<IndexReaderContext> list2 = Arrays.asList(new IndexReaderContext[list.size()]);
            CompositeReaderContext compositeReaderContext2 = compositeReaderContext == null ? new CompositeReaderContext(compositeReader, list2, this.leaves) : new CompositeReaderContext(compositeReaderContext, compositeReader, n2, n3, list2);
            int n4 = 0;
            int n5 = list.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                IndexReader indexReader2 = list.get(i2);
                list2.set(i2, this.build(compositeReaderContext2, indexReader2, i2, n4));
                n4 += indexReader2.maxDoc();
            }
            assert (n4 == compositeReader.maxDoc());
            return compositeReaderContext2;
        }
    }
}

