/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.g;
import org.apache.lucene.codecs.h;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.NormValuesWriter;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.b;
import org.apache.lucene.index.c;
import org.apache.lucene.index.j;
import org.apache.lucene.index.k;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class DefaultIndexingChain
extends b {
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final DocumentsWriterPerThread docWriter;
    final FieldInfos.Builder fieldInfos;
    final TermsHash termsHash;
    private StoredFieldsWriter storedFieldsWriter;
    private int lastStoredDocID;
    private PerField[] fieldHash = new PerField[2];
    private int hashMask = 1;
    private int totalFieldCount;
    private long nextFieldGen;
    private PerField[] fields = new PerField[1];

    public DefaultIndexingChain(DocumentsWriterPerThread documentsWriterPerThread) throws IOException {
        this.docWriter = documentsWriterPerThread;
        this.fieldInfos = documentsWriterPerThread.getFieldInfosBuilder();
        this.docState = documentsWriterPerThread.docState;
        this.bytesUsed = documentsWriterPerThread.bytesUsed;
        TermVectorsConsumer termVectorsConsumer = new TermVectorsConsumer(documentsWriterPerThread);
        this.termsHash = new FreqProxTermsWriter(documentsWriterPerThread, termVectorsConsumer);
    }

    private void initStoredFieldsWriter() throws IOException {
        if (this.storedFieldsWriter == null) {
            this.storedFieldsWriter = this.docWriter.codec.storedFieldsFormat().fieldsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), IOContext.DEFAULT);
        }
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState) throws IOException, AbortingException {
        int n2 = segmentWriteState.segmentInfo.maxDoc();
        this.writeNorms(segmentWriteState);
        this.writeDocValues(segmentWriteState);
        this.initStoredFieldsWriter();
        this.fillStoredFields(n2);
        this.storedFieldsWriter.finish(segmentWriteState.fieldInfos, n2);
        this.storedFieldsWriter.close();
        HashMap<String, TermsHashPerField> hashMap = new HashMap<String, TermsHashPerField>();
        for (int i2 = 0; i2 < this.fieldHash.length; ++i2) {
            PerField perField = this.fieldHash[i2];
            while (perField != null) {
                if (perField.invertState != null) {
                    hashMap.put(perField.fieldInfo.name, perField.termsHashPerField);
                }
                perField = perField.next;
            }
        }
        this.termsHash.flush(hashMap, segmentWriteState);
        this.docWriter.codec.fieldInfosFormat().write(segmentWriteState.directory, segmentWriteState.segmentInfo, "", segmentWriteState.fieldInfos, IOContext.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocValues(SegmentWriteState segmentWriteState) throws IOException {
        DocValuesConsumer docValuesConsumer;
        block16: {
            block15: {
                int n2 = segmentWriteState.segmentInfo.maxDoc();
                docValuesConsumer = null;
                boolean bl = false;
                try {
                    for (int i2 = 0; i2 < this.fieldHash.length; ++i2) {
                        PerField perField = this.fieldHash[i2];
                        while (perField != null) {
                            if (perField.docValuesWriter != null) {
                                if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                                    throw new AssertionError((Object)("segment=" + segmentWriteState.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no docValues but wrote them"));
                                }
                                if (docValuesConsumer == null) {
                                    DocValuesFormat docValuesFormat = segmentWriteState.segmentInfo.getCodec().docValuesFormat();
                                    docValuesConsumer = docValuesFormat.fieldsConsumer(segmentWriteState);
                                }
                                perField.docValuesWriter.finish(n2);
                                perField.docValuesWriter.flush(segmentWriteState, docValuesConsumer);
                                perField.docValuesWriter = null;
                            } else if (perField.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                                throw new AssertionError((Object)("segment=" + segmentWriteState.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has docValues but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    bl = true;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(docValuesConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(docValuesConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(docValuesConsumer);
                break block16;
            }
            IOUtils.closeWhileHandlingException(docValuesConsumer);
        }
        if (!segmentWriteState.fieldInfos.hasDocValues()) {
            if (docValuesConsumer != null) {
                throw new AssertionError((Object)("segment=" + segmentWriteState.segmentInfo + ": fieldInfos has no docValues but wrote them"));
            }
        } else if (docValuesConsumer == null) {
            throw new AssertionError((Object)("segment=" + segmentWriteState.segmentInfo + ": fieldInfos has docValues but did not wrote them"));
        }
    }

    private void fillStoredFields(int n2) throws IOException, AbortingException {
        while (this.lastStoredDocID < n2) {
            this.startStoredFields();
            this.finishStoredFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNorms(SegmentWriteState segmentWriteState) throws IOException {
        block10: {
            g g2;
            block9: {
                boolean bl = false;
                g2 = null;
                try {
                    if (segmentWriteState.fieldInfos.hasNorms()) {
                        h h2 = segmentWriteState.segmentInfo.getCodec().normsFormat();
                        assert (h2 != null);
                        g2 = h2.normsConsumer(segmentWriteState);
                        for (FieldInfo fieldInfo : segmentWriteState.fieldInfos) {
                            PerField perField = this.getPerField(fieldInfo.name);
                            assert (perField != null);
                            if (fieldInfo.omitsNorms() || fieldInfo.getIndexOptions() == IndexOptions.NONE) continue;
                            assert (perField.norms != null) : "field=" + fieldInfo.name;
                            perField.norms.finish(segmentWriteState.segmentInfo.maxDoc());
                            perField.norms.flush(segmentWriteState, g2);
                        }
                    }
                    if (!(bl = true)) break block9;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(g2);
                    } else {
                        IOUtils.closeWhileHandlingException(g2);
                    }
                    throw throwable;
                }
                IOUtils.close(g2);
                break block10;
            }
            IOUtils.closeWhileHandlingException(g2);
        }
    }

    @Override
    public void abort() {
        IOUtils.closeWhileHandlingException(this.storedFieldsWriter);
        try {
            this.termsHash.abort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Arrays.fill(this.fieldHash, null);
    }

    private void rehash() {
        int n2 = this.fieldHash.length * 2;
        assert (n2 > this.fieldHash.length);
        PerField[] perFieldArray = new PerField[n2];
        int n3 = n2 - 1;
        for (int i2 = 0; i2 < this.fieldHash.length; ++i2) {
            PerField perField = this.fieldHash[i2];
            while (perField != null) {
                int n4 = perField.fieldInfo.name.hashCode() & n3;
                PerField perField2 = perField.next;
                perField.next = perFieldArray[n4];
                perFieldArray[n4] = perField;
                perField = perField2;
            }
        }
        this.fieldHash = perFieldArray;
        this.hashMask = n3;
    }

    private void startStoredFields() throws IOException, AbortingException {
        try {
            this.initStoredFieldsWriter();
            this.storedFieldsWriter.startDocument();
        }
        catch (Throwable throwable) {
            throw AbortingException.wrap(throwable);
        }
        ++this.lastStoredDocID;
    }

    private void finishStoredFields() throws IOException, AbortingException {
        try {
            this.storedFieldsWriter.finishDocument();
        }
        catch (Throwable throwable) {
            throw AbortingException.wrap(throwable);
        }
    }

    @Override
    public void processDocument() throws IOException, AbortingException {
        int n2 = 0;
        long l2 = this.nextFieldGen++;
        this.termsHash.startDocument();
        this.fillStoredFields(this.docState.docID);
        this.startStoredFields();
        boolean bl = false;
        try {
            for (j j2 : this.docState.doc) {
                n2 = this.processField(j2, l2, n2);
            }
        }
        catch (AbortingException abortingException) {
            bl = true;
            throw abortingException;
        }
        finally {
            if (!bl) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.fields[i2].finish();
                }
                this.finishStoredFields();
            }
        }
        try {
            this.termsHash.finishDocument();
        }
        catch (Throwable throwable) {
            throw AbortingException.wrap(throwable);
        }
    }

    private int processField(j j2, long l2, int n2) throws IOException, AbortingException {
        DocValuesType docValuesType;
        String string = j2.name();
        k k2 = j2.fieldType();
        PerField perField = null;
        if (k2.indexOptions() == null) {
            throw new NullPointerException("IndexOptions must not be null (field: \"" + j2.name() + "\")");
        }
        if (k2.indexOptions() != IndexOptions.NONE) {
            if (k2.omitNorms() && j2.boost() != 1.0f) {
                throw new UnsupportedOperationException("You cannot set an index-time boost: norms are omitted for field '" + j2.name() + "'");
            }
            perField = this.getOrAddField(string, k2, true);
            boolean bl = perField.fieldGen != l2;
            perField.invert(j2, bl);
            if (bl) {
                this.fields[n2++] = perField;
                perField.fieldGen = l2;
            }
        } else {
            DefaultIndexingChain.verifyUnIndexedFieldType(string, k2);
        }
        if (k2.stored()) {
            if (perField == null) {
                perField = this.getOrAddField(string, k2, false);
            }
            if (k2.stored()) {
                try {
                    this.storedFieldsWriter.writeField(perField.fieldInfo, j2);
                }
                catch (Throwable throwable) {
                    throw AbortingException.wrap(throwable);
                }
            }
        }
        if ((docValuesType = k2.docValuesType()) == null) {
            throw new NullPointerException("docValuesType cannot be null (field: \"" + string + "\")");
        }
        if (docValuesType != DocValuesType.NONE) {
            if (perField == null) {
                perField = this.getOrAddField(string, k2, false);
            }
            this.indexDocValue(perField, docValuesType, j2);
        }
        return n2;
    }

    private static void verifyUnIndexedFieldType(String string, k k2) {
        if (k2.storeTermVectors()) {
            throw new IllegalArgumentException("cannot store term vectors for a field that is not indexed (field=\"" + string + "\")");
        }
        if (k2.storeTermVectorPositions()) {
            throw new IllegalArgumentException("cannot store term vector positions for a field that is not indexed (field=\"" + string + "\")");
        }
        if (k2.storeTermVectorOffsets()) {
            throw new IllegalArgumentException("cannot store term vector offsets for a field that is not indexed (field=\"" + string + "\")");
        }
        if (k2.storeTermVectorPayloads()) {
            throw new IllegalArgumentException("cannot store term vector payloads for a field that is not indexed (field=\"" + string + "\")");
        }
    }

    private void indexDocValue(PerField perField, DocValuesType docValuesType, j j2) throws IOException {
        if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
            this.fieldInfos.globalFieldNumbers.setDocValuesType(perField.fieldInfo.number, perField.fieldInfo.name, docValuesType);
        }
        perField.fieldInfo.setDocValuesType(docValuesType);
        int n2 = this.docState.docID;
        switch (docValuesType) {
            case NUMERIC: {
                if (perField.docValuesWriter == null) {
                    perField.docValuesWriter = new NumericDocValuesWriter(perField.fieldInfo, this.bytesUsed);
                }
                ((NumericDocValuesWriter)perField.docValuesWriter).addValue(n2, j2.numericValue().longValue());
                break;
            }
            case BINARY: {
                if (perField.docValuesWriter == null) {
                    perField.docValuesWriter = new BinaryDocValuesWriter(perField.fieldInfo, this.bytesUsed);
                }
                ((BinaryDocValuesWriter)perField.docValuesWriter).addValue(n2, j2.binaryValue());
                break;
            }
            case SORTED: {
                if (perField.docValuesWriter == null) {
                    perField.docValuesWriter = new SortedDocValuesWriter(perField.fieldInfo, this.bytesUsed);
                }
                ((SortedDocValuesWriter)perField.docValuesWriter).addValue(n2, j2.binaryValue());
                break;
            }
            case SORTED_NUMERIC: {
                if (perField.docValuesWriter == null) {
                    perField.docValuesWriter = new SortedNumericDocValuesWriter(perField.fieldInfo, this.bytesUsed);
                }
                ((SortedNumericDocValuesWriter)perField.docValuesWriter).addValue(n2, j2.numericValue().longValue());
                break;
            }
            case SORTED_SET: {
                if (perField.docValuesWriter == null) {
                    perField.docValuesWriter = new SortedSetDocValuesWriter(perField.fieldInfo, this.bytesUsed);
                }
                ((SortedSetDocValuesWriter)perField.docValuesWriter).addValue(n2, j2.binaryValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + (Object)((Object)docValuesType)));
            }
        }
    }

    private PerField getPerField(String string) {
        int n2 = string.hashCode() & this.hashMask;
        PerField perField = this.fieldHash[n2];
        while (perField != null && !perField.fieldInfo.name.equals(string)) {
            perField = perField.next;
        }
        return perField;
    }

    private PerField getOrAddField(String string, k k2, boolean bl) {
        int n2 = string.hashCode() & this.hashMask;
        PerField perField = this.fieldHash[n2];
        while (perField != null && !perField.fieldInfo.name.equals(string)) {
            perField = perField.next;
        }
        if (perField == null) {
            FieldInfo fieldInfo = this.fieldInfos.getOrAdd(string);
            fieldInfo.setIndexOptions(k2.indexOptions());
            perField = new PerField(fieldInfo, bl);
            perField.next = this.fieldHash[n2];
            this.fieldHash[n2] = perField;
            ++this.totalFieldCount;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] perFieldArray = new PerField[ArrayUtil.oversize(this.totalFieldCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.fields, 0, perFieldArray, 0, this.fields.length);
                this.fields = perFieldArray;
            }
        } else if (bl && perField.invertState == null) {
            perField.fieldInfo.setIndexOptions(k2.indexOptions());
            perField.setInvertState();
        }
        return perField;
    }

    private final class PerField
    implements Comparable<PerField> {
        final FieldInfo fieldInfo;
        final a similarity;
        FieldInvertState invertState;
        TermsHashPerField termsHashPerField;
        c docValuesWriter;
        long fieldGen = -1L;
        PerField next;
        NormValuesWriter norms;
        TokenStream tokenStream;

        public PerField(FieldInfo fieldInfo, boolean bl) {
            this.fieldInfo = fieldInfo;
            this.similarity = DefaultIndexingChain.this.docState.similarity;
            if (bl) {
                this.setInvertState();
            }
        }

        void setInvertState() {
            this.invertState = new FieldInvertState(this.fieldInfo.name);
            this.termsHashPerField = DefaultIndexingChain.this.termsHash.addField(this.invertState, this.fieldInfo);
            if (!this.fieldInfo.omitsNorms()) {
                assert (this.norms == null);
                this.norms = new NormValuesWriter(this.fieldInfo, DefaultIndexingChain.this.docState.docWriter.bytesUsed);
            }
        }

        @Override
        public int compareTo(PerField perField) {
            return this.fieldInfo.name.compareTo(perField.fieldInfo.name);
        }

        public void finish() throws IOException {
            if (!this.fieldInfo.omitsNorms() && this.invertState.length != 0) {
                this.norms.addValue(DefaultIndexingChain.this.docState.docID, this.similarity.computeNorm(this.invertState));
            }
            this.termsHashPerField.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invert(j j2, boolean bl) throws IOException, AbortingException {
            if (bl) {
                this.invertState.reset();
            }
            k k2 = j2.fieldType();
            IndexOptions indexOptions = k2.indexOptions();
            this.fieldInfo.setIndexOptions(indexOptions);
            if (k2.omitNorms()) {
                this.fieldInfo.setOmitsNorms();
            }
            boolean bl2 = k2.tokenized() && DefaultIndexingChain.this.docState.analyzer != null;
            boolean bl3 = indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            boolean bl4 = false;
            try (TokenStream tokenStream = this.tokenStream = j2.tokenStream(DefaultIndexingChain.this.docState.analyzer, this.tokenStream);){
                tokenStream.reset();
                this.invertState.setAttributeSource(tokenStream);
                this.termsHashPerField.start(j2, bl);
                while (tokenStream.incrementToken()) {
                    int n2 = this.invertState.posIncrAttribute.getPositionIncrement();
                    this.invertState.position += n2;
                    if (this.invertState.position < this.invertState.lastPosition) {
                        if (n2 == 0) {
                            throw new IllegalArgumentException("first position increment must be > 0 (got 0) for field '" + j2.name() + "'");
                        }
                        throw new IllegalArgumentException("position increments (and gaps) must be >= 0 (got " + n2 + ") for field '" + j2.name() + "'");
                    }
                    if (this.invertState.position > 0x7FFFFF7F) {
                        throw new IllegalArgumentException("position " + this.invertState.position + " is too large for field '" + j2.name() + "': max allowed position is " + 0x7FFFFF7F);
                    }
                    this.invertState.lastPosition = this.invertState.position;
                    if (n2 == 0) {
                        ++this.invertState.numOverlap;
                    }
                    if (bl3) {
                        int n3 = this.invertState.offset + this.invertState.offsetAttribute.startOffset();
                        int n4 = this.invertState.offset + this.invertState.offsetAttribute.endOffset();
                        if (n3 < this.invertState.lastStartOffset || n4 < n3) {
                            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + n3 + ",endOffset=" + n4 + ",lastStartOffset=" + this.invertState.lastStartOffset + " for field '" + j2.name() + "'");
                        }
                        this.invertState.lastStartOffset = n3;
                    }
                    ++this.invertState.length;
                    if (this.invertState.length < 0) {
                        throw new IllegalArgumentException("too many tokens in field '" + j2.name() + "'");
                    }
                    try {
                        this.termsHashPerField.add();
                    }
                    catch (BytesRefHash.b b2) {
                        byte[] byArray = new byte[30];
                        BytesRef bytesRef = this.invertState.termAttribute.getBytesRef();
                        System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, 0, 30);
                        String string = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose UTF8 encoding is longer than the max length " + 32766 + "), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + Arrays.toString(byArray) + "...', original message: " + b2.getMessage();
                        if (DefaultIndexingChain.this.docState.infoStream.isEnabled("IW")) {
                            DefaultIndexingChain.this.docState.infoStream.message("IW", "ERROR: " + string);
                        }
                        throw new IllegalArgumentException(string, b2);
                    }
                    catch (Throwable throwable) {
                        throw AbortingException.wrap(throwable);
                    }
                }
                tokenStream.end();
                this.invertState.position += this.invertState.posIncrAttribute.getPositionIncrement();
                this.invertState.offset += this.invertState.offsetAttribute.endOffset();
                bl4 = true;
            }
            finally {
                if (!bl4 && DefaultIndexingChain.this.docState.infoStream.isEnabled("DW")) {
                    DefaultIndexingChain.this.docState.infoStream.message("DW", "An exception was thrown while processing field " + this.fieldInfo.name);
                }
            }
            if (bl2) {
                this.invertState.position += DefaultIndexingChain.this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                this.invertState.offset += DefaultIndexingChain.this.docState.analyzer.getOffsetGap(this.fieldInfo.name);
            }
            this.invertState.boost *= j2.boost();
        }
    }
}

