/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SingletonSortedNumericDocValues;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.n;
import org.apache.lucene.index.p;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    private DocValues() {
    }

    public static final a emptyBinary() {
        final BytesRef bytesRef = new BytesRef();
        return new a(){

            @Override
            public BytesRef get(int n2) {
                return bytesRef;
            }
        };
    }

    public static final m emptyNumeric() {
        return new m(){

            @Override
            public long get(int n2) {
                return 0L;
            }
        };
    }

    public static final SortedDocValues emptySorted() {
        final BytesRef bytesRef = new BytesRef();
        return new SortedDocValues(){

            @Override
            public int getOrd(int n2) {
                return -1;
            }

            @Override
            public BytesRef lookupOrd(int n2) {
                return bytesRef;
            }

            @Override
            public int getValueCount() {
                return 0;
            }
        };
    }

    public static final p emptySortedNumeric(int n2) {
        return DocValues.singleton(DocValues.emptyNumeric(), new Bits.MatchNoBits(n2));
    }

    public static final n emptySortedSet() {
        return DocValues.singleton(DocValues.emptySorted());
    }

    public static n singleton(SortedDocValues sortedDocValues) {
        return new SingletonSortedSetDocValues(sortedDocValues);
    }

    public static p singleton(m m2, Bits bits) {
        return new SingletonSortedNumericDocValues(m2, bits);
    }

    public static Bits docsWithValue(final SortedDocValues sortedDocValues, final int n2) {
        return new Bits(){

            @Override
            public boolean get(int n22) {
                return sortedDocValues.getOrd(n22) >= 0;
            }

            @Override
            public int length() {
                return n2;
            }
        };
    }

    public static Bits docsWithValue(final SortedSetDocValues sortedSetDocValues, final int n2) {
        return new Bits(){

            @Override
            public boolean get(int n22) {
                sortedSetDocValues.setDocument(n22);
                return sortedSetDocValues.nextOrd() != -1L;
            }

            @Override
            public int length() {
                return n2;
            }
        };
    }

    public static Bits docsWithValue(final p p2, final int n2) {
        return new Bits(){

            @Override
            public boolean get(int n22) {
                p2.setDocument(n22);
                return p2.count() != 0;
            }

            @Override
            public int length() {
                return n2;
            }
        };
    }

    private static void checkField(LeafReader leafReader, String string, DocValuesType ... docValuesTypeArray) {
        FieldInfo fieldInfo = leafReader.getFieldInfos().fieldInfo(string);
        if (fieldInfo != null) {
            DocValuesType docValuesType = fieldInfo.getDocValuesType();
            throw new IllegalStateException("unexpected docvalues type " + (Object)((Object)docValuesType) + " for field '" + string + "' " + (docValuesTypeArray.length == 1 ? "(expected=" + (Object)((Object)docValuesTypeArray[0]) : "(expected one of " + Arrays.toString((Object[])docValuesTypeArray)) + "). Use UninvertingReader or index with docvalues.");
        }
    }

    public static m getNumeric(LeafReader leafReader, String string) throws IOException {
        m m2 = leafReader.getNumericDocValues(string);
        if (m2 == null) {
            DocValues.checkField(leafReader, string, DocValuesType.NUMERIC);
            return DocValues.emptyNumeric();
        }
        return m2;
    }

    public static a getBinary(LeafReader leafReader, String string) throws IOException {
        a a2 = leafReader.getBinaryDocValues(string);
        if (a2 == null && (a2 = leafReader.getSortedDocValues(string)) == null) {
            DocValues.checkField(leafReader, string, DocValuesType.BINARY, DocValuesType.SORTED);
            return DocValues.emptyBinary();
        }
        return a2;
    }

    public static SortedDocValues getSorted(LeafReader leafReader, String string) throws IOException {
        SortedDocValues sortedDocValues = leafReader.getSortedDocValues(string);
        if (sortedDocValues == null) {
            DocValues.checkField(leafReader, string, DocValuesType.SORTED);
            return DocValues.emptySorted();
        }
        return sortedDocValues;
    }

    public static Bits getDocsWithField(LeafReader leafReader, String string) throws IOException {
        Bits bits = leafReader.getDocsWithField(string);
        if (bits == null) {
            assert (DocValuesType.values().length == 6);
            DocValues.checkField(leafReader, string, DocValuesType.BINARY, DocValuesType.NUMERIC, DocValuesType.SORTED, DocValuesType.SORTED_NUMERIC, DocValuesType.SORTED_SET);
            return new Bits.MatchNoBits(leafReader.maxDoc());
        }
        return bits;
    }
}

