/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;

abstract class DocValuesFieldUpdates {
    final String field;
    final DocValuesType type;

    protected DocValuesFieldUpdates(String string, DocValuesType docValuesType) {
        this.field = string;
        if (docValuesType == null) {
            throw new NullPointerException("DocValuesType cannot be null");
        }
        this.type = docValuesType;
    }

    protected static int estimateCapacity(int n2) {
        return (int)Math.ceil((double)n2 / 1024.0) * 1024;
    }

    public abstract void add(int var1, Object var2);

    public abstract a iterator();

    public abstract void merge(DocValuesFieldUpdates var1);

    static class Container {
        final Map<String, NumericDocValuesFieldUpdates> numericDVUpdates = new HashMap<String, NumericDocValuesFieldUpdates>();
        final Map<String, BinaryDocValuesFieldUpdates> binaryDVUpdates = new HashMap<String, BinaryDocValuesFieldUpdates>();

        Container() {
        }

        boolean any() {
            for (NumericDocValuesFieldUpdates docValuesFieldUpdates : this.numericDVUpdates.values()) {
                if (!docValuesFieldUpdates.any()) continue;
                return true;
            }
            for (BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates : this.binaryDVUpdates.values()) {
                if (!binaryDocValuesFieldUpdates.any()) continue;
                return true;
            }
            return false;
        }

        int size() {
            return this.numericDVUpdates.size() + this.binaryDVUpdates.size();
        }

        DocValuesFieldUpdates getUpdates(String string, DocValuesType docValuesType) {
            switch (docValuesType) {
                case NUMERIC: {
                    return this.numericDVUpdates.get(string);
                }
                case BINARY: {
                    return this.binaryDVUpdates.get(string);
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)docValuesType));
        }

        DocValuesFieldUpdates newUpdates(String string, DocValuesType docValuesType, int n2) {
            switch (docValuesType) {
                case NUMERIC: {
                    assert (this.numericDVUpdates.get(string) == null);
                    NumericDocValuesFieldUpdates numericDocValuesFieldUpdates = new NumericDocValuesFieldUpdates(string, n2);
                    this.numericDVUpdates.put(string, numericDocValuesFieldUpdates);
                    return numericDocValuesFieldUpdates;
                }
                case BINARY: {
                    assert (this.binaryDVUpdates.get(string) == null);
                    BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates = new BinaryDocValuesFieldUpdates(string, n2);
                    this.binaryDVUpdates.put(string, binaryDocValuesFieldUpdates);
                    return binaryDocValuesFieldUpdates;
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)docValuesType));
        }

        public String toString() {
            return "numericDVUpdates=" + this.numericDVUpdates + " binaryDVUpdates=" + this.binaryDVUpdates;
        }
    }

    static abstract class a {
        a() {
        }

        abstract int nextDoc();

        abstract int doc();

        abstract Object value();

        abstract void reset();
    }
}

