/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

final class DocumentsWriterDeleteQueue
implements org.apache.lucene.util.a {
    private volatile Node<?> tail;
    private static final AtomicReferenceFieldUpdater<DocumentsWriterDeleteQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(DocumentsWriterDeleteQueue.class, Node.class, "tail");
    private final DeleteSlice globalSlice;
    private final BufferedUpdates globalBufferedUpdates;
    private final ReentrantLock globalBufferLock = new ReentrantLock();
    final long generation;

    DocumentsWriterDeleteQueue() {
        this(0L);
    }

    DocumentsWriterDeleteQueue(long l2) {
        this(new BufferedUpdates(), l2);
    }

    DocumentsWriterDeleteQueue(BufferedUpdates bufferedUpdates, long l2) {
        this.globalBufferedUpdates = bufferedUpdates;
        this.generation = l2;
        this.tail = new Node<Object>(null);
        this.globalSlice = new DeleteSlice(this.tail);
    }

    void addDelete(Query ... queryArray) {
        this.add(new a(queryArray));
        this.tryApplyGlobalSlice();
    }

    void addDelete(Term ... termArray) {
        this.add(new b(termArray));
        this.tryApplyGlobalSlice();
    }

    void add(Term term, DeleteSlice deleteSlice) {
        c c2 = new c(term);
        this.add(c2);
        deleteSlice.sliceTail = c2;
        assert (deleteSlice.sliceHead != deleteSlice.sliceTail) : "slice head and tail must differ after add";
        this.tryApplyGlobalSlice();
    }

    void add(Node<?> node) {
        Node<?> node2;
        while (true) {
            node2 = this.tail;
            Node<?> node3 = node2.next;
            if (this.tail != node2) continue;
            if (node3 != null) {
                tailUpdater.compareAndSet(this, node2, node3);
                continue;
            }
            if (node2.casNext(null, node)) break;
        }
        tailUpdater.compareAndSet(this, node2, node);
    }

    boolean anyChanges() {
        this.globalBufferLock.lock();
        try {
            boolean bl = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.sliceTail != this.tail || this.tail.next != null;
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    void tryApplyGlobalSlice() {
        if (this.globalBufferLock.tryLock()) {
            try {
                if (this.updateSlice(this.globalSlice)) {
                    this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
                }
            }
            finally {
                this.globalBufferLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrozenBufferedUpdates freezeGlobalBuffer(DeleteSlice deleteSlice) {
        this.globalBufferLock.lock();
        Node<?> node = this.tail;
        if (deleteSlice != null) {
            deleteSlice.sliceTail = node;
        }
        try {
            if (this.globalSlice.sliceTail != node) {
                this.globalSlice.sliceTail = node;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            FrozenBufferedUpdates frozenBufferedUpdates = new FrozenBufferedUpdates(this.globalBufferedUpdates, false);
            this.globalBufferedUpdates.clear();
            FrozenBufferedUpdates frozenBufferedUpdates2 = frozenBufferedUpdates;
            return frozenBufferedUpdates2;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    DeleteSlice newSlice() {
        return new DeleteSlice(this.tail);
    }

    boolean updateSlice(DeleteSlice deleteSlice) {
        if (deleteSlice.sliceTail != this.tail) {
            deleteSlice.sliceTail = this.tail;
            return true;
        }
        return false;
    }

    public int numGlobalTermDeletes() {
        return this.globalBufferedUpdates.numTermDeletes.get();
    }

    void clear() {
        this.globalBufferLock.lock();
        try {
            Node<?> node = this.tail;
            this.globalSlice.sliceTail = node;
            this.globalSlice.sliceHead = this.globalSlice.sliceTail;
            this.globalBufferedUpdates.clear();
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.globalBufferedUpdates.bytesUsed.get();
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return "DWDQ: [ generation: " + this.generation + " ]";
    }

    private static final class b
    extends Node<Term[]> {
        b(Term[] termArray) {
            super(termArray);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int n2) {
            for (Term term : (Term[])this.item) {
                bufferedUpdates.addTerm(term, n2);
            }
        }

        public String toString() {
            return "dels=" + Arrays.toString((Object[])this.item);
        }
    }

    private static final class a
    extends Node<Query[]> {
        a(Query[] queryArray) {
            super(queryArray);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int n2) {
            for (Query query : (Query[])this.item) {
                bufferedUpdates.addQuery(query, n2);
            }
        }
    }

    private static final class c
    extends Node<Term> {
        c(Term term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int n2) {
            bufferedUpdates.addTerm((Term)this.item, n2);
        }

        public String toString() {
            return "del=" + this.item;
        }
    }

    private static class Node<T> {
        volatile Node<?> next;
        final T item;
        static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");

        Node(T t2) {
            this.item = t2;
        }

        void apply(BufferedUpdates bufferedUpdates, int n2) {
            throw new IllegalStateException("sentinel item must never be applied");
        }

        boolean casNext(Node<?> node, Node<?> node2) {
            return nextUpdater.compareAndSet(this, node, node2);
        }
    }

    static class DeleteSlice {
        Node<?> sliceHead;
        Node<?> sliceTail;

        DeleteSlice(Node<?> node) {
            assert (node != null);
            this.sliceTail = node;
            this.sliceHead = this.sliceTail;
        }

        void apply(BufferedUpdates bufferedUpdates, int n2) {
            if (this.sliceHead == this.sliceTail) {
                return;
            }
            Node<?> node = this.sliceHead;
            do {
                node = node.next;
                assert (node != null) : "slice property violated between the head on the tail must not be a null node";
                node.apply(bufferedUpdates, n2);
            } while (node != this.sliceTail);
            this.reset();
        }

        void reset() {
            this.sliceHead = this.sliceTail;
        }

        boolean isTailItem(Object object) {
            return this.sliceTail.item == object;
        }

        boolean isEmpty() {
            return this.sliceHead == this.sliceTail;
        }
    }
}

