/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.DocumentsWriterStallControl;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.a;
import org.apache.lucene.util.k;

final class DocumentsWriterFlushControl
implements a {
    private final long hardMaxBytesPerDWPT;
    private long activeBytes = 0L;
    private long flushBytes = 0L;
    private volatile int numPending = 0;
    private int numDocsSinceStalled = 0;
    final AtomicBoolean flushDeletes = new AtomicBoolean(false);
    private boolean fullFlush = false;
    private final Queue<DocumentsWriterPerThread> flushQueue = new LinkedList<DocumentsWriterPerThread>();
    private final Queue<BlockedFlush> blockedFlushes = new LinkedList<BlockedFlush>();
    private final IdentityHashMap<DocumentsWriterPerThread, Long> flushingWriters = new IdentityHashMap();
    double maxConfiguredRamBuffer = 0.0;
    long peakActiveBytes = 0L;
    long peakFlushBytes = 0L;
    long peakNetBytes = 0L;
    long peakDelta = 0L;
    boolean flushByRAMWasDisabled;
    final DocumentsWriterStallControl stallControl;
    private final DocumentsWriterPerThreadPool perThreadPool;
    private final FlushPolicy flushPolicy;
    private boolean closed = false;
    @Weak
    private final DocumentsWriter documentsWriter;
    private final LiveIndexWriterConfig config;
    private final BufferedUpdatesStream bufferedUpdatesStream;
    private final InfoStream infoStream;
    private final List<DocumentsWriterPerThread> fullFlushBuffer = new ArrayList<DocumentsWriterPerThread>();

    DocumentsWriterFlushControl(DocumentsWriter documentsWriter, LiveIndexWriterConfig liveIndexWriterConfig, BufferedUpdatesStream bufferedUpdatesStream) {
        this.infoStream = liveIndexWriterConfig.getInfoStream();
        this.stallControl = new DocumentsWriterStallControl(liveIndexWriterConfig);
        this.perThreadPool = documentsWriter.perThreadPool;
        this.flushPolicy = documentsWriter.flushPolicy;
        this.config = liveIndexWriterConfig;
        this.hardMaxBytesPerDWPT = liveIndexWriterConfig.getRAMPerThreadHardLimitMB() * 1024 * 1024;
        this.documentsWriter = documentsWriter;
        this.bufferedUpdatesStream = bufferedUpdatesStream;
    }

    public synchronized long activeBytes() {
        return this.activeBytes;
    }

    public synchronized long flushBytes() {
        return this.flushBytes;
    }

    public synchronized long netBytes() {
        return this.flushBytes + this.activeBytes;
    }

    private long stallLimitBytes() {
        double d2 = this.config.getRAMBufferSizeMB();
        return d2 != -1.0 ? (long)(2.0 * (d2 * 1024.0 * 1024.0)) : Long.MAX_VALUE;
    }

    private boolean assertMemory() {
        double d2 = this.config.getRAMBufferSizeMB();
        if (d2 != -1.0 && !this.flushByRAMWasDisabled) {
            this.maxConfiguredRamBuffer = Math.max(d2, this.maxConfiguredRamBuffer);
            long l2 = this.flushBytes + this.activeBytes;
            long l3 = (long)(this.maxConfiguredRamBuffer * 1024.0 * 1024.0);
            long l4 = 2L * l3 + (long)(this.numPending + this.numFlushingDWPT() + this.numBlockedFlushes()) * this.peakDelta + (long)this.numDocsSinceStalled * this.peakDelta;
            if (this.peakDelta < l3 >> 1) assert (l2 <= l4) : "actual mem: " + l2 + " byte, expected mem: " + l4 + " byte, flush mem: " + this.flushBytes + ", active mem: " + this.activeBytes + ", pending DWPT: " + this.numPending + ", flushing DWPT: " + this.numFlushingDWPT() + ", blocked DWPT: " + this.numBlockedFlushes() + ", peakDelta mem: " + this.peakDelta + " bytes, ramBufferBytes=" + l3 + ", maxConfiguredRamBuffer=" + this.maxConfiguredRamBuffer;
        } else {
            this.flushByRAMWasDisabled = true;
        }
        return true;
    }

    private void commitPerThreadBytes(DocumentsWriterPerThreadPool.ThreadState threadState) {
        long l2 = threadState.dwpt.bytesUsed() - threadState.bytesUsed;
        threadState.bytesUsed += l2;
        if (threadState.flushPending) {
            this.flushBytes += l2;
        } else {
            this.activeBytes += l2;
        }
        assert (this.updatePeaks(l2));
    }

    private boolean updatePeaks(long l2) {
        this.peakActiveBytes = Math.max(this.peakActiveBytes, this.activeBytes);
        this.peakFlushBytes = Math.max(this.peakFlushBytes, this.flushBytes);
        this.peakNetBytes = Math.max(this.peakNetBytes, this.netBytes());
        this.peakDelta = Math.max(this.peakDelta, l2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DocumentsWriterPerThread doAfterDocument(DocumentsWriterPerThreadPool.ThreadState threadState, boolean bl) {
        try {
            DocumentsWriterPerThread documentsWriterPerThread;
            this.commitPerThreadBytes(threadState);
            if (!threadState.flushPending) {
                if (bl) {
                    this.flushPolicy.onUpdate(this, threadState);
                } else {
                    this.flushPolicy.onInsert(this, threadState);
                }
                if (!threadState.flushPending && threadState.bytesUsed > this.hardMaxBytesPerDWPT) {
                    this.setFlushPending(threadState);
                }
            }
            if (this.fullFlush) {
                if (threadState.flushPending) {
                    this.checkoutAndBlock(threadState);
                    documentsWriterPerThread = this.nextPendingFlush();
                } else {
                    documentsWriterPerThread = null;
                }
            } else {
                documentsWriterPerThread = this.tryCheckoutForFlush(threadState);
            }
            DocumentsWriterPerThread documentsWriterPerThread2 = documentsWriterPerThread;
            return documentsWriterPerThread2;
        }
        finally {
            boolean bl2 = this.updateStallState();
            assert (this.assertNumDocsSinceStalled(bl2) && this.assertMemory());
        }
    }

    private boolean assertNumDocsSinceStalled(boolean bl) {
        this.numDocsSinceStalled = bl ? ++this.numDocsSinceStalled : 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doAfterFlush(DocumentsWriterPerThread documentsWriterPerThread) {
        assert (this.flushingWriters.containsKey(documentsWriterPerThread));
        try {
            Long l2 = this.flushingWriters.remove(documentsWriterPerThread);
            this.flushBytes -= l2.longValue();
            this.perThreadPool.recycle(documentsWriterPerThread);
            assert (this.assertMemory());
        }
        finally {
            try {
                this.updateStallState();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private boolean updateStallState() {
        assert (Thread.holdsLock(this));
        long l2 = this.stallLimitBytes();
        boolean bl = this.activeBytes + this.flushBytes > l2 && this.activeBytes < l2 && !this.closed;
        this.stallControl.updateStalled(bl);
        return bl;
    }

    public synchronized void waitForFlush() {
        while (this.flushingWriters.size() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new k(interruptedException);
            }
        }
    }

    public synchronized void setFlushPending(DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (!threadState.flushPending);
        if (threadState.dwpt.getNumDocsInRAM() > 0) {
            threadState.flushPending = true;
            long l2 = threadState.bytesUsed;
            this.flushBytes += l2;
            this.activeBytes -= l2;
            ++this.numPending;
            assert (this.assertMemory());
        }
    }

    synchronized void doOnAbort(DocumentsWriterPerThreadPool.ThreadState threadState) {
        try {
            if (threadState.flushPending) {
                this.flushBytes -= threadState.bytesUsed;
            } else {
                this.activeBytes -= threadState.bytesUsed;
            }
            assert (this.assertMemory());
            this.perThreadPool.reset(threadState);
        }
        finally {
            this.updateStallState();
        }
    }

    synchronized DocumentsWriterPerThread tryCheckoutForFlush(DocumentsWriterPerThreadPool.ThreadState threadState) {
        return threadState.flushPending ? this.internalTryCheckOutForFlush(threadState) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutAndBlock(DocumentsWriterPerThreadPool.ThreadState threadState) {
        threadState.lock();
        try {
            assert (threadState.flushPending) : "can not block non-pending threadstate";
            assert (this.fullFlush) : "can not block if fullFlush == false";
            long l2 = threadState.bytesUsed;
            DocumentsWriterPerThread documentsWriterPerThread = this.perThreadPool.reset(threadState);
            --this.numPending;
            this.blockedFlushes.add(new BlockedFlush(documentsWriterPerThread, l2));
        }
        finally {
            threadState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentsWriterPerThread internalTryCheckOutForFlush(DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (Thread.holdsLock(this));
        assert (threadState.flushPending);
        try {
            if (threadState.tryLock()) {
                try {
                    if (threadState.isInitialized()) {
                        assert (threadState.isHeldByCurrentThread());
                        long l2 = threadState.bytesUsed;
                        DocumentsWriterPerThread documentsWriterPerThread = this.perThreadPool.reset(threadState);
                        assert (!this.flushingWriters.containsKey(documentsWriterPerThread)) : "DWPT is already flushing";
                        this.flushingWriters.put(documentsWriterPerThread, l2);
                        --this.numPending;
                        DocumentsWriterPerThread documentsWriterPerThread2 = documentsWriterPerThread;
                        return documentsWriterPerThread2;
                    }
                }
                finally {
                    threadState.unlock();
                }
            }
            DocumentsWriterPerThread documentsWriterPerThread = null;
            return documentsWriterPerThread;
        }
        finally {
            this.updateStallState();
        }
    }

    public String toString() {
        return "DocumentsWriterFlushControl [activeBytes=" + this.activeBytes + ", flushBytes=" + this.flushBytes + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThread nextPendingFlush() {
        int n2;
        boolean bl;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterPerThread documentsWriterPerThread = this.flushQueue.poll();
            if (documentsWriterPerThread != null) {
                this.updateStallState();
                return documentsWriterPerThread;
            }
            bl = this.fullFlush;
            n2 = this.numPending;
        }
        if (n2 > 0 && !bl) {
            int n3 = this.perThreadPool.getActiveThreadStateCount();
            for (int i2 = 0; i2 < n3 && n2 > 0; ++i2) {
                DocumentsWriterPerThread documentsWriterPerThread;
                DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
                if (!threadState.flushPending || (documentsWriterPerThread = this.tryCheckoutForFlush(threadState)) == null) continue;
                return documentsWriterPerThread;
            }
        }
        return null;
    }

    synchronized void setClosed() {
        this.closed = true;
    }

    public Iterator<DocumentsWriterPerThreadPool.ThreadState> allActiveThreadStates() {
        return this.getPerThreadsIterator(this.perThreadPool.getActiveThreadStateCount());
    }

    private Iterator<DocumentsWriterPerThreadPool.ThreadState> getPerThreadsIterator(final int n2) {
        return new Iterator<DocumentsWriterPerThreadPool.ThreadState>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n2;
            }

            @Override
            public DocumentsWriterPerThreadPool.ThreadState next() {
                return DocumentsWriterFlushControl.this.perThreadPool.getThreadState(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported.");
            }
        };
    }

    synchronized void doOnDelete() {
        this.flushPolicy.onDelete(this, null);
    }

    public int getNumGlobalTermDeletes() {
        return this.documentsWriter.deleteQueue.numGlobalTermDeletes() + this.bufferedUpdatesStream.numTerms();
    }

    public long getDeleteBytesUsed() {
        return this.documentsWriter.deleteQueue.ramBytesUsed() + this.bufferedUpdatesStream.ramBytesUsed();
    }

    @Override
    public long ramBytesUsed() {
        return this.getDeleteBytesUsed() + this.netBytes();
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    synchronized int numFlushingDWPT() {
        return this.flushingWriters.size();
    }

    public boolean getAndResetApplyAllDeletes() {
        return this.flushDeletes.getAndSet(false);
    }

    public void setApplyAllDeletes() {
        this.flushDeletes.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThreadPool.ThreadState obtainAndLock() {
        DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getAndLock(Thread.currentThread(), this.documentsWriter);
        boolean bl = false;
        try {
            if (threadState.isInitialized() && threadState.dwpt.deleteQueue != this.documentsWriter.deleteQueue) {
                this.addFlushableState(threadState);
            }
            bl = true;
            DocumentsWriterPerThreadPool.ThreadState threadState2 = threadState;
            return threadState2;
        }
        finally {
            if (!bl) {
                this.perThreadPool.release(threadState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markForFullFlush() {
        DocumentsWriterDeleteQueue documentsWriterDeleteQueue;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterDeleteQueue documentsWriterDeleteQueue2;
            assert (!this.fullFlush) : "called DWFC#markForFullFlush() while full flush is still running";
            assert (this.fullFlushBuffer.isEmpty()) : "full flush buffer should be empty: " + this.fullFlushBuffer;
            this.fullFlush = true;
            documentsWriterDeleteQueue = this.documentsWriter.deleteQueue;
            this.documentsWriter.deleteQueue = documentsWriterDeleteQueue2 = new DocumentsWriterDeleteQueue(documentsWriterDeleteQueue.generation + 1L);
        }
        int n2 = this.perThreadPool.getActiveThreadStateCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
            threadState.lock();
            try {
                if (!threadState.isInitialized()) continue;
                assert (threadState.dwpt.deleteQueue == documentsWriterDeleteQueue || threadState.dwpt.deleteQueue == this.documentsWriter.deleteQueue) : " flushingQueue: " + documentsWriterDeleteQueue + " currentqueue: " + this.documentsWriter.deleteQueue + " perThread queue: " + threadState.dwpt.deleteQueue + " numDocsInRam: " + threadState.dwpt.getNumDocsInRAM();
                if (threadState.dwpt.deleteQueue != documentsWriterDeleteQueue) continue;
                this.addFlushableState(threadState);
                continue;
            }
            finally {
                threadState.unlock();
            }
        }
        DocumentsWriterFlushControl documentsWriterFlushControl2 = this;
        synchronized (documentsWriterFlushControl2) {
            this.pruneBlockedQueue(documentsWriterDeleteQueue);
            assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
            this.flushQueue.addAll(this.fullFlushBuffer);
            this.fullFlushBuffer.clear();
            this.updateStallState();
        }
        assert (this.assertActiveDeleteQueue(this.documentsWriter.deleteQueue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertActiveDeleteQueue(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        int n2 = this.perThreadPool.getActiveThreadStateCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
            threadState.lock();
            try {
                if ($assertionsDisabled || !threadState.isInitialized() || threadState.dwpt.deleteQueue == documentsWriterDeleteQueue) continue;
                throw new AssertionError((Object)("isInitialized: " + threadState.isInitialized() + " numDocs: " + (threadState.isInitialized() ? threadState.dwpt.getNumDocsInRAM() : 0)));
            }
            finally {
                threadState.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFlushableState(DocumentsWriterPerThreadPool.ThreadState threadState) {
        if (this.infoStream.isEnabled("DWFC")) {
            this.infoStream.message("DWFC", "addFlushableState " + threadState.dwpt);
        }
        DocumentsWriterPerThread documentsWriterPerThread = threadState.dwpt;
        assert (threadState.isHeldByCurrentThread());
        assert (threadState.isInitialized());
        assert (this.fullFlush);
        assert (documentsWriterPerThread.deleteQueue != this.documentsWriter.deleteQueue);
        if (documentsWriterPerThread.getNumDocsInRAM() > 0) {
            DocumentsWriterFlushControl documentsWriterFlushControl = this;
            synchronized (documentsWriterFlushControl) {
                if (!threadState.flushPending) {
                    this.setFlushPending(threadState);
                }
                DocumentsWriterPerThread documentsWriterPerThread2 = this.internalTryCheckOutForFlush(threadState);
                assert (documentsWriterPerThread2 != null) : "DWPT must never be null here since we hold the lock and it holds documents";
                assert (documentsWriterPerThread == documentsWriterPerThread2) : "flushControl returned different DWPT";
                this.fullFlushBuffer.add(documentsWriterPerThread2);
            }
        } else {
            this.perThreadPool.reset(threadState);
        }
    }

    private void pruneBlockedQueue(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        Iterator iterator = this.blockedFlushes.iterator();
        while (iterator.hasNext()) {
            BlockedFlush blockedFlush = (BlockedFlush)iterator.next();
            if (blockedFlush.dwpt.deleteQueue != documentsWriterDeleteQueue) continue;
            iterator.remove();
            assert (!this.flushingWriters.containsKey(blockedFlush.dwpt)) : "DWPT is already flushing";
            this.flushingWriters.put(blockedFlush.dwpt, blockedFlush.bytes);
            this.flushQueue.add(blockedFlush.dwpt);
        }
    }

    synchronized void finishFullFlush() {
        assert (this.fullFlush);
        assert (this.flushQueue.isEmpty());
        assert (this.flushingWriters.isEmpty());
        try {
            if (!this.blockedFlushes.isEmpty()) {
                assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
                this.pruneBlockedQueue(this.documentsWriter.deleteQueue);
                assert (this.blockedFlushes.isEmpty());
            }
        }
        finally {
            this.fullFlush = false;
            this.updateStallState();
        }
    }

    boolean assertBlockedFlushes(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        for (BlockedFlush blockedFlush : this.blockedFlushes) {
            assert (blockedFlush.dwpt.deleteQueue == documentsWriterDeleteQueue);
        }
        return true;
    }

    synchronized void abortFullFlushes() {
        try {
            this.abortPendingFlushes();
        }
        finally {
            this.fullFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abortPendingFlushes() {
        try {
            for (DocumentsWriterPerThread object : this.flushQueue) {
                try {
                    this.documentsWriter.subtractFlushedNumDocs(object.getNumDocsInRAM());
                    object.abort();
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    this.doAfterFlush(object);
                }
            }
            for (BlockedFlush blockedFlush : this.blockedFlushes) {
                try {
                    this.flushingWriters.put(blockedFlush.dwpt, blockedFlush.bytes);
                    this.documentsWriter.subtractFlushedNumDocs(blockedFlush.dwpt.getNumDocsInRAM());
                    blockedFlush.dwpt.abort();
                }
                catch (Throwable throwable) {}
                continue;
                finally {
                    this.doAfterFlush(blockedFlush.dwpt);
                }
            }
        }
        finally {
            this.flushQueue.clear();
            this.blockedFlushes.clear();
            this.updateStallState();
        }
    }

    synchronized boolean isFullFlush() {
        return this.fullFlush;
    }

    synchronized int numQueuedFlushes() {
        return this.flushQueue.size();
    }

    synchronized int numBlockedFlushes() {
        return this.blockedFlushes.size();
    }

    void waitIfStalled() {
        if (this.infoStream.isEnabled("DWFC")) {
            this.infoStream.message("DWFC", "waitIfStalled: numFlushesPending: " + this.flushQueue.size() + " netBytes: " + this.netBytes() + " flushBytes: " + this.flushBytes() + " fullFlush: " + this.fullFlush);
        }
        this.stallControl.waitIfStalled();
    }

    boolean anyStalledThreads() {
        return this.stallControl.anyStalledThreads();
    }

    private static class BlockedFlush {
        final DocumentsWriterPerThread dwpt;
        final long bytes;

        BlockedFlush(DocumentsWriterPerThread documentsWriterPerThread, long l2) {
            this.dwpt = documentsWriterPerThread;
            this.bytes = l2;
        }
    }
}

