/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.j;
import org.apache.lucene.util.BytesRef;

final class FreqProxTermsWriterPerField
extends TermsHashPerField {
    private FreqProxPostingsArray freqProxPostingsArray;
    final boolean hasFreq;
    final boolean hasProx;
    final boolean hasOffsets;
    PayloadAttribute payloadAttribute;
    OffsetAttribute offsetAttribute;
    long sumTotalTermFreq;
    long sumDocFreq;
    int docCount;
    boolean sawPayloads;

    public FreqProxTermsWriterPerField(FieldInvertState fieldInvertState, TermsHash termsHash, FieldInfo fieldInfo, TermsHashPerField termsHashPerField) {
        super(fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 ? 2 : 1, fieldInvertState, termsHash, termsHashPerField, fieldInfo);
        IndexOptions indexOptions = fieldInfo.getIndexOptions();
        assert (indexOptions != IndexOptions.NONE);
        this.hasFreq = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        this.hasProx = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.hasOffsets = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    void finish() throws IOException {
        super.finish();
        this.sumDocFreq += (long)this.fieldState.uniqueTermCount;
        this.sumTotalTermFreq += (long)this.fieldState.length;
        if (this.fieldState.length > 0) {
            ++this.docCount;
        }
        if (this.sawPayloads) {
            this.fieldInfo.setStorePayloads();
        }
    }

    @Override
    boolean start(j j2, boolean bl) {
        super.start(j2, bl);
        this.payloadAttribute = this.fieldState.payloadAttribute;
        this.offsetAttribute = this.fieldState.offsetAttribute;
        return true;
    }

    void writeProx(int n2, int n3) {
        if (this.payloadAttribute == null) {
            this.writeVInt(1, n3 << 1);
        } else {
            BytesRef bytesRef = this.payloadAttribute.getPayload();
            if (bytesRef != null && bytesRef.length > 0) {
                this.writeVInt(1, n3 << 1 | 1);
                this.writeVInt(1, bytesRef.length);
                this.writeBytes(1, bytesRef.bytes, bytesRef.offset, bytesRef.length);
                this.sawPayloads = true;
            } else {
                this.writeVInt(1, n3 << 1);
            }
        }
        assert (this.postingsArray == this.freqProxPostingsArray);
        this.freqProxPostingsArray.lastPositions[n2] = this.fieldState.position;
    }

    void writeOffsets(int n2, int n3) {
        int n4 = n3 + this.offsetAttribute.startOffset();
        int n5 = n3 + this.offsetAttribute.endOffset();
        assert (n4 - this.freqProxPostingsArray.lastOffsets[n2] >= 0);
        this.writeVInt(1, n4 - this.freqProxPostingsArray.lastOffsets[n2]);
        this.writeVInt(1, n5 - n4);
        this.freqProxPostingsArray.lastOffsets[n2] = n4;
    }

    @Override
    void newTerm(int n2) {
        FreqProxPostingsArray freqProxPostingsArray = this.freqProxPostingsArray;
        freqProxPostingsArray.lastDocIDs[n2] = this.docState.docID;
        if (!this.hasFreq) {
            assert (freqProxPostingsArray.termFreqs == null);
            freqProxPostingsArray.lastDocCodes[n2] = this.docState.docID;
        } else {
            freqProxPostingsArray.lastDocCodes[n2] = this.docState.docID << 1;
            freqProxPostingsArray.termFreqs[n2] = 1;
            if (this.hasProx) {
                this.writeProx(n2, this.fieldState.position);
                if (this.hasOffsets) {
                    this.writeOffsets(n2, this.fieldState.offset);
                }
            } else assert (!this.hasOffsets);
        }
        this.fieldState.maxTermFrequency = Math.max(1, this.fieldState.maxTermFrequency);
        ++this.fieldState.uniqueTermCount;
    }

    @Override
    void addTerm(int n2) {
        FreqProxPostingsArray freqProxPostingsArray = this.freqProxPostingsArray;
        assert (!this.hasFreq || freqProxPostingsArray.termFreqs[n2] > 0);
        if (!this.hasFreq) {
            assert (freqProxPostingsArray.termFreqs == null);
            if (this.docState.docID != freqProxPostingsArray.lastDocIDs[n2]) {
                assert (this.docState.docID > freqProxPostingsArray.lastDocIDs[n2]);
                this.writeVInt(0, freqProxPostingsArray.lastDocCodes[n2]);
                freqProxPostingsArray.lastDocCodes[n2] = this.docState.docID - freqProxPostingsArray.lastDocIDs[n2];
                freqProxPostingsArray.lastDocIDs[n2] = this.docState.docID;
                ++this.fieldState.uniqueTermCount;
            }
        } else if (this.docState.docID != freqProxPostingsArray.lastDocIDs[n2]) {
            assert (this.docState.docID > freqProxPostingsArray.lastDocIDs[n2]) : "id: " + this.docState.docID + " postings ID: " + freqProxPostingsArray.lastDocIDs[n2] + " termID: " + n2;
            if (1 == freqProxPostingsArray.termFreqs[n2]) {
                this.writeVInt(0, freqProxPostingsArray.lastDocCodes[n2] | 1);
            } else {
                this.writeVInt(0, freqProxPostingsArray.lastDocCodes[n2]);
                this.writeVInt(0, freqProxPostingsArray.termFreqs[n2]);
            }
            freqProxPostingsArray.termFreqs[n2] = 1;
            this.fieldState.maxTermFrequency = Math.max(1, this.fieldState.maxTermFrequency);
            freqProxPostingsArray.lastDocCodes[n2] = this.docState.docID - freqProxPostingsArray.lastDocIDs[n2] << 1;
            freqProxPostingsArray.lastDocIDs[n2] = this.docState.docID;
            if (this.hasProx) {
                this.writeProx(n2, this.fieldState.position);
                if (this.hasOffsets) {
                    freqProxPostingsArray.lastOffsets[n2] = 0;
                    this.writeOffsets(n2, this.fieldState.offset);
                }
            } else assert (!this.hasOffsets);
            ++this.fieldState.uniqueTermCount;
        } else {
            int n3 = n2;
            int n4 = freqProxPostingsArray.termFreqs[n3] + 1;
            freqProxPostingsArray.termFreqs[n3] = n4;
            this.fieldState.maxTermFrequency = Math.max(this.fieldState.maxTermFrequency, n4);
            if (this.hasProx) {
                this.writeProx(n2, this.fieldState.position - freqProxPostingsArray.lastPositions[n2]);
                if (this.hasOffsets) {
                    this.writeOffsets(n2, this.fieldState.offset);
                }
            }
        }
    }

    @Override
    public void newPostingsArray() {
        this.freqProxPostingsArray = (FreqProxPostingsArray)this.postingsArray;
    }

    @Override
    ParallelPostingsArray createPostingsArray(int n2) {
        IndexOptions indexOptions = this.fieldInfo.getIndexOptions();
        assert (indexOptions != IndexOptions.NONE);
        boolean bl = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean bl2 = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean bl3 = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        return new FreqProxPostingsArray(n2, bl, bl2, bl3);
    }

    static final class FreqProxPostingsArray
    extends ParallelPostingsArray {
        int[] termFreqs;
        int[] lastDocIDs;
        int[] lastDocCodes;
        int[] lastPositions;
        int[] lastOffsets;

        public FreqProxPostingsArray(int n2, boolean bl, boolean bl2, boolean bl3) {
            super(n2);
            if (bl) {
                this.termFreqs = new int[n2];
            }
            this.lastDocIDs = new int[n2];
            this.lastDocCodes = new int[n2];
            if (bl2) {
                this.lastPositions = new int[n2];
                if (bl3) {
                    this.lastOffsets = new int[n2];
                }
            } else assert (!bl3);
        }

        @Override
        ParallelPostingsArray newInstance(int n2) {
            return new FreqProxPostingsArray(n2, this.termFreqs != null, this.lastPositions != null, this.lastOffsets != null);
        }

        @Override
        void copyTo(ParallelPostingsArray parallelPostingsArray, int n2) {
            assert (parallelPostingsArray instanceof FreqProxPostingsArray);
            FreqProxPostingsArray freqProxPostingsArray = (FreqProxPostingsArray)parallelPostingsArray;
            super.copyTo(parallelPostingsArray, n2);
            System.arraycopy(this.lastDocIDs, 0, freqProxPostingsArray.lastDocIDs, 0, n2);
            System.arraycopy(this.lastDocCodes, 0, freqProxPostingsArray.lastDocCodes, 0, n2);
            if (this.lastPositions != null) {
                assert (freqProxPostingsArray.lastPositions != null);
                System.arraycopy(this.lastPositions, 0, freqProxPostingsArray.lastPositions, 0, n2);
            }
            if (this.lastOffsets != null) {
                assert (freqProxPostingsArray.lastOffsets != null);
                System.arraycopy(this.lastOffsets, 0, freqProxPostingsArray.lastOffsets, 0, n2);
            }
            if (this.termFreqs != null) {
                assert (freqProxPostingsArray.termFreqs != null);
                System.arraycopy(this.termFreqs, 0, freqProxPostingsArray.termFreqs, 0, n2);
            }
        }

        @Override
        int bytesPerPosting() {
            int n2 = 20;
            if (this.lastPositions != null) {
                n2 += 4;
            }
            if (this.lastOffsets != null) {
                n2 += 4;
            }
            if (this.termFreqs != null) {
                n2 += 4;
            }
            return n2;
        }
    }
}

