/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms terms;
    final Query[] queries;
    final int[] queryLimits;
    final DocValuesUpdate.a[] numericDVUpdates;
    final DocValuesUpdate.BinaryDocValuesUpdate[] binaryDVUpdates;
    final int bytesUsed;
    final int numTermDeletes;
    private long gen = -1L;
    final boolean isSegmentPrivate;

    /*
     * WARNING - void declaration
     */
    public FrozenBufferedUpdates(BufferedUpdates bufferedUpdates, boolean bl) {
        void var9_16;
        this.isSegmentPrivate = bl;
        assert (!bl || bufferedUpdates.terms.size() == 0) : "segment private package should only have del queries";
        Comparable[] comparableArray = bufferedUpdates.terms.keySet().toArray(new Term[bufferedUpdates.terms.size()]);
        ArrayUtil.timSort((Comparable[])comparableArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable arrayList2 : comparableArray) {
            builder.add((Term)arrayList2);
        }
        this.terms = builder.finish();
        this.queries = new Query[bufferedUpdates.queries.size()];
        this.queryLimits = new int[bufferedUpdates.queries.size()];
        int n2 = 0;
        for (Map.Entry<Query, Integer> entry : bufferedUpdates.queries.entrySet()) {
            this.queries[n2] = entry.getKey();
            this.queryLimits[n2] = entry.getValue();
            ++n2;
        }
        ArrayList arrayList3 = new ArrayList();
        int n3 = 0;
        for (LinkedHashMap<Term, DocValuesUpdate.a> linkedHashMap : bufferedUpdates.numericUpdates.values()) {
            for (DocValuesUpdate.a a2 : linkedHashMap.values()) {
                arrayList3.add(a2);
                n3 += a2.sizeInBytes();
            }
        }
        this.numericDVUpdates = arrayList3.toArray(new DocValuesUpdate.a[arrayList3.size()]);
        ArrayList<DocValuesUpdate.BinaryDocValuesUpdate> arrayList = new ArrayList<DocValuesUpdate.BinaryDocValuesUpdate>();
        boolean bl2 = false;
        for (LinkedHashMap linkedHashMap : bufferedUpdates.binaryUpdates.values()) {
            for (DocValuesUpdate.BinaryDocValuesUpdate binaryDocValuesUpdate : linkedHashMap.values()) {
                arrayList.add(binaryDocValuesUpdate);
                var9_16 += binaryDocValuesUpdate.sizeInBytes();
            }
        }
        this.binaryDVUpdates = arrayList.toArray(new DocValuesUpdate.BinaryDocValuesUpdate[arrayList.size()]);
        this.bytesUsed = (int)(this.terms.ramBytesUsed() + (long)(this.queries.length * BYTES_PER_DEL_QUERY) + (long)n3 + RamUsageEstimator.shallowSizeOf(this.numericDVUpdates) + (long)var9_16 + RamUsageEstimator.shallowSizeOf(this.binaryDVUpdates));
        this.numTermDeletes = bufferedUpdates.numTermDeletes.get();
    }

    public void setDelGen(long l2) {
        assert (this.gen == -1L);
        this.gen = l2;
        this.terms.setDelGen(l2);
    }

    public long delGen() {
        assert (this.gen != -1L);
        return this.gen;
    }

    public Iterable<BufferedUpdatesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedUpdatesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedUpdatesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedUpdatesStream.QueryAndLimit>(){
                    private int upto;

                    @Override
                    public boolean hasNext() {
                        return this.upto < FrozenBufferedUpdates.this.queries.length;
                    }

                    @Override
                    public BufferedUpdatesStream.QueryAndLimit next() {
                        BufferedUpdatesStream.QueryAndLimit queryAndLimit = new BufferedUpdatesStream.QueryAndLimit(FrozenBufferedUpdates.this.queries[this.upto], FrozenBufferedUpdates.this.queryLimits[this.upto]);
                        ++this.upto;
                        return queryAndLimit;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        String string = "";
        if (this.numTermDeletes != 0) {
            string = string + " " + this.numTermDeletes + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.length != 0) {
            string = string + " " + this.queries.length + " deleted queries";
        }
        if (this.bytesUsed != 0) {
            string = string + " bytesUsed=" + this.bytesUsed;
        }
        return string;
    }

    boolean any() {
        return this.terms.size() > 0L || this.queries.length > 0 || this.numericDVUpdates.length > 0 || this.binaryDVUpdates.length > 0;
    }
}

