/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.regex.Pattern;

public final class IndexFileNames {
    public static final Pattern CODEC_FILE_PATTERN = Pattern.compile("_[a-z0-9]+(_.*)?\\..*");

    private IndexFileNames() {
    }

    public static String fileNameFromGeneration(String string, String string2, long l2) {
        if (l2 == -1L) {
            return null;
        }
        if (l2 == 0L) {
            return IndexFileNames.segmentFileName(string, "", string2);
        }
        assert (l2 > 0L);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6 + string2.length()).append(string).append('_').append(Long.toString(l2, 36));
        if (string2.length() > 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    public static String segmentFileName(String string, String string2, String string3) {
        if (string3.length() > 0 || string2.length() > 0) {
            assert (!string3.startsWith("."));
            StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + string2.length() + string3.length());
            stringBuilder.append(string);
            if (string2.length() > 0) {
                stringBuilder.append('_').append(string2);
            }
            if (string3.length() > 0) {
                stringBuilder.append('.').append(string3);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static int indexOfSegmentName(String string) {
        int n2 = string.indexOf(95, 1);
        if (n2 == -1) {
            n2 = string.indexOf(46);
        }
        return n2;
    }

    public static String stripSegmentName(String string) {
        int n2 = IndexFileNames.indexOfSegmentName(string);
        if (n2 != -1) {
            string = string.substring(n2);
        }
        return string;
    }

    public static long parseGeneration(String string) {
        assert (string.startsWith("_"));
        String[] stringArray = IndexFileNames.stripExtension(string).substring(1).split("_");
        if (stringArray.length == 2 || stringArray.length == 4) {
            return Long.parseLong(stringArray[1], 36);
        }
        return 0L;
    }

    public static String parseSegmentName(String string) {
        int n2 = IndexFileNames.indexOfSegmentName(string);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static String stripExtension(String string) {
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }
}

