/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.g;
import org.apache.lucene.index.h;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.SetOnce;

public final class IndexWriterConfig
extends LiveIndexWriterConfig {
    private SetOnce<IndexWriter> writer = new SetOnce();

    IndexWriterConfig setIndexWriter(IndexWriter indexWriter) {
        if (this.writer.get() != null) {
            throw new IllegalStateException("do not share IndexWriterConfig instances across IndexWriters");
        }
        this.writer.set(indexWriter);
        return this;
    }

    public IndexWriterConfig(Analyzer analyzer) {
        super(analyzer);
    }

    @Override
    public OpenMode getOpenMode() {
        return this.openMode;
    }

    @Override
    public h getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    @Override
    public g getIndexCommit() {
        return this.commit;
    }

    @Override
    public a getSimilarity() {
        return this.similarity;
    }

    @Override
    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    @Override
    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    @Override
    DocumentsWriterPerThreadPool getIndexerThreadPool() {
        return this.indexerThreadPool;
    }

    @Override
    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    @Override
    DocumentsWriterPerThread.a getIndexingChain() {
        return this.indexingChain;
    }

    @Override
    public int getRAMPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    @Override
    FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    @Override
    public Analyzer getAnalyzer() {
        return super.getAnalyzer();
    }

    @Override
    public int getMaxBufferedDeleteTerms() {
        return super.getMaxBufferedDeleteTerms();
    }

    @Override
    public int getMaxBufferedDocs() {
        return super.getMaxBufferedDocs();
    }

    @Override
    public IndexWriter.b getMergedSegmentWarmer() {
        return super.getMergedSegmentWarmer();
    }

    @Override
    public double getRAMBufferSizeMB() {
        return super.getRAMBufferSizeMB();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("writer=").append(this.writer.get()).append("\n");
        return stringBuilder.toString();
    }

    public static enum OpenMode {
        CREATE,
        APPEND,
        CREATE_OR_APPEND;

    }
}

