/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;

final class MappingMultiPostingsEnum
extends PostingsEnum {
    private MultiPostingsEnum.EnumWithSlice[] subs;
    int numSubs;
    int upto;
    MergeState.DocMap currentMap;
    PostingsEnum current;
    int currentBase;
    int doc = -1;
    private MergeState mergeState;
    MultiPostingsEnum multiDocsAndPositionsEnum;
    final String field;

    public MappingMultiPostingsEnum(String string, MergeState mergeState) {
        this.field = string;
        this.mergeState = mergeState;
    }

    MappingMultiPostingsEnum reset(MultiPostingsEnum multiPostingsEnum) {
        this.numSubs = multiPostingsEnum.getNumSubs();
        this.subs = multiPostingsEnum.getSubs();
        this.upto = -1;
        this.doc = -1;
        this.current = null;
        this.multiDocsAndPositionsEnum = multiPostingsEnum;
        return this;
    }

    @Override
    public int freq() throws IOException {
        return this.current.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int n2;
            if (this.current == null) {
                if (this.upto == this.numSubs - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.upto;
                n2 = this.subs[this.upto].slice.readerIndex;
                this.current = this.subs[this.upto].postingsEnum;
                this.currentBase = this.mergeState.docBase[n2];
                this.currentMap = this.mergeState.docMaps[n2];
            }
            if ((n2 = this.current.nextDoc()) != Integer.MAX_VALUE) {
                if ((n2 = this.currentMap.get(n2)) == -1) continue;
                this.doc = this.currentBase + n2;
                return this.doc;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        int n2 = this.current.nextPosition();
        if (n2 < 0) {
            throw new CorruptIndexException("position=" + n2 + " is negative, field=\"" + this.field + " doc=" + this.doc, this.mergeState.fieldsProducers[this.upto].toString());
        }
        if (n2 > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + n2 + " is too large (> IndexWriter.MAX_POSITION=" + 0x7FFFFF7F + "), field=\"" + this.field + "\" doc=" + this.doc, this.mergeState.fieldsProducers[this.upto].toString());
        }
        return n2;
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.getPayload();
    }

    @Override
    public long cost() {
        long l2 = 0L;
        for (MultiPostingsEnum.EnumWithSlice enumWithSlice : this.subs) {
            l2 += enumWithSlice.postingsEnum.cost();
        }
        return l2;
    }
}

