/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.b;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.packed.PackedLongValues;

public class MergeState {
    public final SegmentInfo segmentInfo;
    public FieldInfos mergeFieldInfos;
    public final n[] storedFieldsReaders;
    public final p[] termVectorsReaders;
    public final i[] normsProducers;
    public final b[] docValuesProducers;
    public final FieldInfos[] fieldInfos;
    public final Bits[] liveDocs;
    public final DocMap[] docMaps;
    public final e[] fieldsProducers;
    public final int[] docBase;
    public final int[] maxDocs;
    public final InfoStream infoStream;

    MergeState(List<CodecReader> list, SegmentInfo segmentInfo, InfoStream infoStream) throws IOException {
        int n2 = list.size();
        this.docMaps = new DocMap[n2];
        this.docBase = new int[n2];
        this.maxDocs = new int[n2];
        this.fieldsProducers = new e[n2];
        this.normsProducers = new i[n2];
        this.storedFieldsReaders = new n[n2];
        this.termVectorsReaders = new p[n2];
        this.docValuesProducers = new b[n2];
        this.fieldInfos = new FieldInfos[n2];
        this.liveDocs = new Bits[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            CodecReader codecReader = list.get(i2);
            this.maxDocs[i2] = codecReader.maxDoc();
            this.liveDocs[i2] = codecReader.getLiveDocs();
            this.fieldInfos[i2] = codecReader.getFieldInfos();
            this.normsProducers[i2] = codecReader.getNormsReader();
            if (this.normsProducers[i2] != null) {
                this.normsProducers[i2] = this.normsProducers[i2].getMergeInstance();
            }
            this.docValuesProducers[i2] = codecReader.getDocValuesReader();
            if (this.docValuesProducers[i2] != null) {
                this.docValuesProducers[i2] = this.docValuesProducers[i2].getMergeInstance();
            }
            this.storedFieldsReaders[i2] = codecReader.getFieldsReader();
            if (this.storedFieldsReaders[i2] != null) {
                this.storedFieldsReaders[i2] = this.storedFieldsReaders[i2].getMergeInstance();
            }
            this.termVectorsReaders[i2] = codecReader.getTermVectorsReader();
            if (this.termVectorsReaders[i2] != null) {
                this.termVectorsReaders[i2] = this.termVectorsReaders[i2].getMergeInstance();
            }
            this.fieldsProducers[i2] = codecReader.getPostingsReader().getMergeInstance();
        }
        this.segmentInfo = segmentInfo;
        this.infoStream = infoStream;
        this.setDocMaps(list);
    }

    private void setDocMaps(List<CodecReader> list) throws IOException {
        int n2 = this.maxDocs.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            DocMap docMap;
            CodecReader codecReader = list.get(i2);
            this.docBase[i2] = n3;
            this.docMaps[i2] = docMap = DocMap.build(codecReader);
            n3 += docMap.numDocs();
        }
        this.segmentInfo.setMaxDoc(n3);
    }

    private static final class NoDelDocMap
    extends DocMap {
        private final int maxDoc;

        NoDelDocMap(int n2) {
            this.maxDoc = n2;
        }

        @Override
        public int get(int n2) {
            return n2;
        }

        @Override
        public int maxDoc() {
            return this.maxDoc;
        }

        @Override
        public int numDeletedDocs() {
            return 0;
        }
    }

    public static abstract class DocMap {
        DocMap() {
        }

        public abstract int get(int var1);

        public abstract int maxDoc();

        public final int numDocs() {
            return this.maxDoc() - this.numDeletedDocs();
        }

        public abstract int numDeletedDocs();

        public static DocMap build(CodecReader codecReader) {
            int n2 = codecReader.maxDoc();
            if (!codecReader.hasDeletions()) {
                return new NoDelDocMap(n2);
            }
            Bits bits = codecReader.getLiveDocs();
            return DocMap.build(n2, bits);
        }

        static DocMap build(final int n2, final Bits bits) {
            assert (bits != null);
            PackedLongValues.Builder builder = PackedLongValues.monotonicBuilder(0.0f);
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.add(i2 - n3);
                if (bits.get(i2)) continue;
                ++n3;
            }
            final PackedLongValues packedLongValues = builder.build();
            final int n4 = n3;
            assert (packedLongValues.size() == (long)n2);
            return new DocMap(){

                @Override
                public int get(int n22) {
                    if (!bits.get(n22)) {
                        return -1;
                    }
                    return (int)packedLongValues.get(n22);
                }

                @Override
                public int maxDoc() {
                    return n2;
                }

                @Override
                public int numDeletedDocs() {
                    return n4;
                }
            };
        }
    }
}

