/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.util.BytesRef;

public final class MultiPostingsEnum
extends PostingsEnum {
    private final MultiTermsEnum parent;
    final PostingsEnum[] subPostingsEnums;
    private final EnumWithSlice[] subs;
    int numSubs;
    int upto;
    PostingsEnum current;
    int currentBase;
    int doc = -1;

    public MultiPostingsEnum(MultiTermsEnum multiTermsEnum, int n2) {
        this.parent = multiTermsEnum;
        this.subPostingsEnums = new PostingsEnum[n2];
        this.subs = new EnumWithSlice[n2];
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            this.subs[i2] = new EnumWithSlice();
        }
    }

    public boolean canReuse(MultiTermsEnum multiTermsEnum) {
        return this.parent == multiTermsEnum;
    }

    public MultiPostingsEnum reset(EnumWithSlice[] enumWithSliceArray, int n2) {
        this.numSubs = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.subs[i2].postingsEnum = enumWithSliceArray[i2].postingsEnum;
            this.subs[i2].slice = enumWithSliceArray[i2].slice;
        }
        this.upto = -1;
        this.doc = -1;
        this.current = null;
        return this;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public EnumWithSlice[] getSubs() {
        return this.subs;
    }

    @Override
    public int freq() throws IOException {
        assert (this.current != null);
        return this.current.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int n2) throws IOException {
        assert (n2 > this.doc);
        while (true) {
            if (this.current != null) {
                int n3 = n2 < this.currentBase ? this.current.nextDoc() : this.current.advance(n2 - this.currentBase);
                if (n3 == Integer.MAX_VALUE) {
                    this.current = null;
                    continue;
                }
                this.doc = n3 + this.currentBase;
                return this.doc;
            }
            if (this.upto == this.numSubs - 1) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            ++this.upto;
            this.current = this.subs[this.upto].postingsEnum;
            this.currentBase = this.subs[this.upto].slice.start;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int n2;
            if (this.current == null) {
                if (this.upto == this.numSubs - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.upto;
                this.current = this.subs[this.upto].postingsEnum;
                this.currentBase = this.subs[this.upto].slice.start;
            }
            if ((n2 = this.current.nextDoc()) != Integer.MAX_VALUE) {
                this.doc = this.currentBase + n2;
                return this.doc;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        return this.current.nextPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.getPayload();
    }

    @Override
    public long cost() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.numSubs; ++i2) {
            l2 += this.subs[i2].postingsEnum.cost();
        }
        return l2;
    }

    public String toString() {
        return "MultiDocsAndPositionsEnum(" + Arrays.toString(this.getSubs()) + ")";
    }

    public static final class EnumWithSlice {
        public PostingsEnum postingsEnum;
        public ReaderSlice slice;

        EnumWithSlice() {
        }

        public String toString() {
            return this.slice.toString() + ":" + this.postingsEnum;
        }
    }
}

