/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.p;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.b;

class SegmentDocValuesProducer
extends org.apache.lucene.codecs.b {
    private static final long LONG_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Long.class);
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentDocValuesProducer.class);
    final Map<String, org.apache.lucene.codecs.b> dvProducersByField = new HashMap<String, org.apache.lucene.codecs.b>();
    final Set<org.apache.lucene.codecs.b> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final List<Long> dvGens = new ArrayList<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentDocValuesProducer(SegmentCommitInfo segmentCommitInfo, c c2, FieldInfos fieldInfos, FieldInfos fieldInfos2, SegmentDocValues segmentDocValues) throws IOException {
        boolean bl = false;
        try {
            Version version = segmentCommitInfo.info.getVersion();
            if (version != null && version.onOrAfter(Version.LUCENE_4_9_0)) {
                org.apache.lucene.codecs.b b2 = null;
                for (FieldInfo fieldInfo : fieldInfos2) {
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    long l3 = fieldInfo.getDocValuesGen();
                    if (l3 == -1L) {
                        if (b2 == null) {
                            b2 = segmentDocValues.getDocValuesProducer(l3, segmentCommitInfo, c2, fieldInfos);
                            this.dvGens.add(l3);
                            this.dvProducers.add(b2);
                        }
                        this.dvProducersByField.put(fieldInfo.name, b2);
                        continue;
                    }
                    assert (!this.dvGens.contains(l3));
                    org.apache.lucene.codecs.b b3 = segmentDocValues.getDocValuesProducer(l3, segmentCommitInfo, c2, new FieldInfos(new FieldInfo[]{fieldInfo}));
                    this.dvGens.add(l3);
                    this.dvProducers.add(b3);
                    this.dvProducersByField.put(fieldInfo.name, b3);
                }
            } else {
                HashMap<Long, ArrayList<FieldInfo>> hashMap = new HashMap<Long, ArrayList<FieldInfo>>();
                for (FieldInfo object : fieldInfos2) {
                    if (object.getDocValuesType() == DocValuesType.NONE) continue;
                    ArrayList<FieldInfo> arrayList = (ArrayList<FieldInfo>)hashMap.get(object.getDocValuesGen());
                    if (arrayList == null) {
                        arrayList = new ArrayList<FieldInfo>();
                        hashMap.put(object.getDocValuesGen(), arrayList);
                    }
                    arrayList.add(object);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    long l2 = (Long)entry.getKey();
                    List list = (List)entry.getValue();
                    org.apache.lucene.codecs.b b4 = l2 == -1L ? segmentDocValues.getDocValuesProducer(l2, segmentCommitInfo, c2, fieldInfos) : segmentDocValues.getDocValuesProducer(l2, segmentCommitInfo, c2, new FieldInfos(list.toArray(new FieldInfo[list.size()])));
                    this.dvGens.add(l2);
                    this.dvProducers.add(b4);
                    for (FieldInfo fieldInfo : list) {
                        this.dvProducersByField.put(fieldInfo.name, b4);
                    }
                }
            }
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    segmentDocValues.decRef(this.dvGens);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public m getNumeric(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getNumeric(fieldInfo);
    }

    @Override
    public a getBinary(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getBinary(fieldInfo);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSorted(fieldInfo);
    }

    @Override
    public p getSortedNumeric(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSortedNumeric(fieldInfo);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSortedSet(fieldInfo);
    }

    @Override
    public Bits getDocsWithField(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getDocsWithField(fieldInfo);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (org.apache.lucene.codecs.b b2 : this.dvProducers) {
            b2.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        long l2 = BASE_RAM_BYTES_USED;
        l2 += (long)this.dvGens.size() * LONG_RAM_BYTES_USED;
        l2 += (long)(this.dvProducers.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        l2 += (long)(this.dvProducersByField.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (org.apache.lucene.codecs.b b2 : this.dvProducers) {
            l2 += b2.ramBytesUsed();
        }
        return l2;
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        for (org.apache.lucene.util.a a2 : this.dvProducers) {
            arrayList.add(b.a("delegate", a2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

