/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.c;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedDocValuesWriter
extends c {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;

    public SortedDocValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = counter;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(counter)), 16, new BytesRefHash.DirectBytesStartArray(16, counter));
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed();
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, BytesRef bytesRef) {
        if ((long)n2 < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (bytesRef == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (bytesRef.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + 32766);
        }
        while (this.pending.size() < (long)n2) {
            this.pending.add(-1L);
        }
        this.addOneValue(bytesRef);
    }

    @Override
    public void finish(int n2) {
        while (this.pending.size() < (long)n2) {
            this.pending.add(-1L);
        }
        this.updateBytesUsed();
    }

    private void addOneValue(BytesRef bytesRef) {
        int n2 = this.hash.add(bytesRef);
        if (n2 < 0) {
            n2 = -n2 - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        this.pending.add(n2);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long l2 = this.pending.ramBytesUsed();
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState, DocValuesConsumer docValuesConsumer) throws IOException {
        final int n2 = segmentWriteState.segmentInfo.maxDoc();
        assert (this.pending.size() == (long)n2);
        final int n3 = this.hash.size();
        final PackedLongValues packedLongValues = this.pending.build();
        final int[] nArray = this.hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        final int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray2[nArray[i2]] = i2;
        }
        docValuesConsumer.addSortedField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new ValuesIterator(nArray, n3, SortedDocValuesWriter.this.hash);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new OrdsIterator(nArray2, n2, packedLongValues);
            }
        });
    }

    private static class OrdsIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final int[] ordMap;
        final int maxDoc;
        int docUpto;

        OrdsIterator(int[] nArray, int n2, PackedLongValues packedLongValues) {
            this.ordMap = nArray;
            this.maxDoc = n2;
            assert (packedLongValues.size() == (long)n2);
            this.iter = packedLongValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = (int)this.iter.next();
            ++this.docUpto;
            return n2 == -1 ? n2 : this.ordMap[n2];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<BytesRef> {
        final int[] sortedValues;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int valueCount;
        int ordUpto;

        ValuesIterator(int[] nArray, int n2, BytesRefHash bytesRefHash) {
            this.sortedValues = nArray;
            this.valueCount = n2;
            this.hash = bytesRefHash;
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.valueCount;
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hash.get(this.sortedValues[this.ordUpto], this.scratch);
            ++this.ordUpto;
            return this.scratch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

