/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedNumericDocValuesWriter
extends c {
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc;
    private long[] currentValues = new long[8];
    private int currentUpto = 0;

    public SortedNumericDocValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = counter;
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, long l2) {
        if (n2 != this.currentDoc) {
            this.finishCurrentDoc();
        }
        while (this.currentDoc < n2) {
            this.pendingCounts.add(0L);
            ++this.currentDoc;
        }
        this.addOneValue(l2);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        for (int i2 = 0; i2 < this.currentUpto; ++i2) {
            this.pending.add(this.currentValues[i2]);
        }
        this.pendingCounts.add(this.currentUpto);
        this.currentUpto = 0;
        ++this.currentDoc;
    }

    @Override
    public void finish(int n2) {
        this.finishCurrentDoc();
        for (int i2 = this.currentDoc; i2 < n2; ++i2) {
            this.pendingCounts.add(0L);
        }
    }

    private void addOneValue(long l2) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = l2;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long l2 = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState, DocValuesConsumer docValuesConsumer) throws IOException {
        int n2 = segmentWriteState.segmentInfo.maxDoc();
        assert (this.pendingCounts.size() == (long)n2);
        final PackedLongValues packedLongValues = this.pending.build();
        final PackedLongValues packedLongValues2 = this.pendingCounts.build();
        docValuesConsumer.addSortedNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new CountIterator(packedLongValues2);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new ValuesIterator(packedLongValues);
            }
        });
    }

    private static class CountIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        CountIterator(PackedLongValues packedLongValues) {
            this.iter = packedLongValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        ValuesIterator(PackedLongValues packedLongValues) {
            this.iter = packedLongValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

