/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.SortedSetDocValuesTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public abstract class SortedSetDocValues {
    public static final long NO_MORE_ORDS = -1L;

    protected SortedSetDocValues() {
    }

    public abstract long nextOrd();

    public abstract void setDocument(int var1);

    public abstract BytesRef lookupOrd(long var1);

    public abstract long getValueCount();

    public long lookupTerm(BytesRef bytesRef) {
        long l2 = 0L;
        long l3 = this.getValueCount() - 1L;
        while (l2 <= l3) {
            long l4 = l2 + l3 >>> 1;
            BytesRef bytesRef2 = this.lookupOrd(l4);
            int n2 = bytesRef2.compareTo(bytesRef);
            if (n2 < 0) {
                l2 = l4 + 1L;
                continue;
            }
            if (n2 > 0) {
                l3 = l4 - 1L;
                continue;
            }
            return l4;
        }
        return -(l2 + 1L);
    }

    public TermsEnum termsEnum() {
        return new SortedSetDocValuesTermsEnum(this);
    }
}

