/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class SortedSetDocValuesTermsEnum
extends TermsEnum {
    private final SortedSetDocValues values;
    private long currentOrd = -1L;
    private final BytesRefBuilder scratch;

    public SortedSetDocValuesTermsEnum(SortedSetDocValues sortedSetDocValues) {
        this.values = sortedSetDocValues;
        this.scratch = new BytesRefBuilder();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
        long l2 = this.values.lookupTerm(bytesRef);
        if (l2 >= 0L) {
            this.currentOrd = l2;
            this.scratch.copyBytes(bytesRef);
            return TermsEnum.SeekStatus.FOUND;
        }
        this.currentOrd = -l2 - 1L;
        if (this.currentOrd == this.values.getValueCount()) {
            return TermsEnum.SeekStatus.END;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public boolean seekExact(BytesRef bytesRef) throws IOException {
        long l2 = this.values.lookupTerm(bytesRef);
        if (l2 >= 0L) {
            this.currentOrd = l2;
            this.scratch.copyBytes(bytesRef);
            return true;
        }
        return false;
    }

    @Override
    public void seekExact(long l2) throws IOException {
        assert (l2 >= 0L && l2 < this.values.getValueCount());
        this.currentOrd = (int)l2;
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
    }

    @Override
    public BytesRef next() throws IOException {
        ++this.currentOrd;
        if (this.currentOrd >= this.values.getValueCount()) {
            return null;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return this.scratch.get();
    }

    @Override
    public BytesRef term() throws IOException {
        return this.scratch.get();
    }

    @Override
    public long ord() throws IOException {
        return this.currentOrd;
    }

    @Override
    public int docFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalTermFreq() {
        return -1L;
    }

    @Override
    public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(BytesRef bytesRef, q q2) throws IOException {
        assert (q2 != null && q2 instanceof OrdTermState);
        this.seekExact(((OrdTermState)q2).ord);
    }

    @Override
    public q termState() throws IOException {
        OrdTermState ordTermState = new OrdTermState();
        ordTermState.ord = this.currentOrd;
        return ordTermState;
    }
}

