/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.g;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.IOUtils;

final class StandardDirectoryReader
extends DirectoryReader {
    final IndexWriter writer;
    final SegmentInfos segmentInfos;
    private final boolean applyAllDeletes;

    StandardDirectoryReader(c c2, LeafReader[] leafReaderArray, IndexWriter indexWriter, SegmentInfos segmentInfos, boolean bl) throws IOException {
        super(c2, leafReaderArray);
        this.writer = indexWriter;
        this.segmentInfos = segmentInfos;
        this.applyAllDeletes = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryReader open(IndexWriter indexWriter, SegmentInfos segmentInfos, boolean bl) throws IOException {
        int n2 = segmentInfos.size();
        ArrayList<SegmentReader> arrayList = new ArrayList<SegmentReader>();
        c c2 = indexWriter.getDirectory();
        SegmentInfos segmentInfos2 = segmentInfos.clone();
        int n3 = 0;
        boolean bl2 = false;
        try {
            Object object;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = segmentInfos.info(i2);
                assert (((SegmentCommitInfo)object).info.dir == c2);
                ReadersAndUpdates readersAndUpdates = indexWriter.readerPool.get((SegmentCommitInfo)object, true);
                try {
                    SegmentReader segmentReader = readersAndUpdates.getReadOnlyClone(IOContext.READ);
                    if (segmentReader.numDocs() > 0 || indexWriter.getKeepFullyDeletedSegments()) {
                        arrayList.add(segmentReader);
                        ++n3;
                        continue;
                    }
                    segmentReader.decRef();
                    segmentInfos2.remove(n3);
                    continue;
                }
                finally {
                    indexWriter.readerPool.release(readersAndUpdates);
                }
            }
            indexWriter.incRefDeleter(segmentInfos2);
            StandardDirectoryReader standardDirectoryReader = new StandardDirectoryReader(c2, arrayList.toArray(new SegmentReader[arrayList.size()]), indexWriter, segmentInfos2, bl);
            bl2 = true;
            object = standardDirectoryReader;
            return object;
        }
        finally {
            if (!bl2) {
                for (SegmentReader segmentReader : arrayList) {
                    try {
                        segmentReader.decRef();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryReader open(c c2, SegmentInfos segmentInfos, List<? extends LeafReader> list) throws IOException {
        Object object;
        int n2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list != null) {
            n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = (SegmentReader)list.get(i2);
                hashMap.put(((SegmentReader)object).getSegmentName(), i2);
            }
        }
        LeafReader[] leafReaderArray = new SegmentReader[segmentInfos.size()];
        for (n2 = segmentInfos.size() - 1; n2 >= 0; --n2) {
            object = segmentInfos.info(n2);
            Integer n3 = (Integer)hashMap.get(((SegmentCommitInfo)object).info.name);
            SegmentReader segmentReader = n3 == null ? null : (SegmentReader)list.get(n3);
            boolean bl = false;
            try {
                if (segmentReader == null || ((SegmentCommitInfo)object).info.getUseCompoundFile() != segmentReader.getSegmentInfo().info.getUseCompoundFile()) {
                    SegmentReader segmentReader2 = new SegmentReader((SegmentCommitInfo)object, IOContext.READ);
                    leafReaderArray[n2] = segmentReader2;
                } else if (segmentReader.getSegmentInfo().getDelGen() == ((SegmentCommitInfo)object).getDelGen() && segmentReader.getSegmentInfo().getFieldInfosGen() == ((SegmentCommitInfo)object).getFieldInfosGen()) {
                    segmentReader.incRef();
                    leafReaderArray[n2] = segmentReader;
                } else {
                    boolean bl2;
                    assert (((SegmentCommitInfo)object).info.dir == segmentReader.getSegmentInfo().info.dir);
                    boolean bl3 = ((SegmentCommitInfo)object).info.maxDoc() != segmentReader.getSegmentInfo().info.maxDoc();
                    boolean bl4 = !((SegmentCommitInfo)object).hasDeletions() && !((SegmentCommitInfo)object).hasFieldUpdates();
                    boolean bl5 = bl2 = ((SegmentCommitInfo)object).getDelGen() == -1L && segmentReader.getSegmentInfo().getDelGen() != -1L;
                    if (bl3 || bl4 || bl2) {
                        throw new IllegalStateException("same segment " + ((SegmentCommitInfo)object).info.name + " has invalid changes; likely you are re-opening a reader after illegally removing index files yourself and building a new index in their place.  Use IndexWriter.deleteAll or OpenMode.CREATE instead");
                    }
                    leafReaderArray[n2] = segmentReader.getSegmentInfo().getDelGen() == ((SegmentCommitInfo)object).getDelGen() ? new SegmentReader((SegmentCommitInfo)object, segmentReader, segmentReader.getLiveDocs(), segmentReader.numDocs()) : new SegmentReader((SegmentCommitInfo)object, segmentReader);
                }
                bl = true;
                continue;
            }
            finally {
                if (!bl) {
                    StandardDirectoryReader.decRefWhileHandlingException((SegmentReader[])leafReaderArray);
                }
            }
        }
        return new StandardDirectoryReader(c2, leafReaderArray, null, segmentInfos, false);
    }

    private static void decRefWhileHandlingException(SegmentReader[] segmentReaderArray) {
        for (SegmentReader segmentReader : segmentReaderArray) {
            if (segmentReader == null) continue;
            try {
                segmentReader.decRef();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('(');
        String string = this.segmentInfos.getSegmentsFileName();
        if (string != null) {
            stringBuilder.append(string).append(":").append(this.segmentInfos.getVersion());
        }
        if (this.writer != null) {
            stringBuilder.append(":nrt");
        }
        for (LeafReader leafReader : this.getSequentialSubReaders()) {
            stringBuilder.append(' ');
            stringBuilder.append(leafReader);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    protected DirectoryReader doOpenIfChanged() throws IOException {
        return this.doOpenIfChanged((g)null);
    }

    @Override
    protected DirectoryReader doOpenIfChanged(g g2) throws IOException {
        this.ensureOpen();
        if (this.writer != null) {
            return this.doOpenFromWriter(g2);
        }
        return this.doOpenNoWriter(g2);
    }

    private DirectoryReader doOpenFromWriter(g g2) throws IOException {
        if (g2 != null) {
            return this.doOpenFromCommit(g2);
        }
        if (this.writer.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        DirectoryReader directoryReader = this.writer.getReader(this.applyAllDeletes);
        if (directoryReader.getVersion() == this.segmentInfos.getVersion()) {
            directoryReader.decRef();
            return null;
        }
        return directoryReader;
    }

    private DirectoryReader doOpenNoWriter(g g2) throws IOException {
        if (g2 == null) {
            if (this.isCurrent()) {
                return null;
            }
        } else {
            if (this.directory != g2.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && g2.getSegmentsFileName().equals(this.segmentInfos.getSegmentsFileName())) {
                return null;
            }
        }
        return this.doOpenFromCommit(g2);
    }

    private DirectoryReader doOpenFromCommit(g g2) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(this.directory){

            @Override
            protected DirectoryReader doBody(String string) throws IOException {
                SegmentInfos segmentInfos = SegmentInfos.readCommit(this.directory, string);
                return StandardDirectoryReader.this.doOpenIfChanged(segmentInfos);
            }
        }.run(g2);
    }

    DirectoryReader doOpenIfChanged(SegmentInfos segmentInfos) throws IOException {
        return StandardDirectoryReader.open(this.directory, segmentInfos, this.getSequentialSubReaders());
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public boolean isCurrent() throws IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            SegmentInfos segmentInfos = SegmentInfos.readLatestCommit(this.directory);
            return segmentInfos.getVersion() == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    @Override
    protected void doClose() throws IOException {
        Throwable throwable = null;
        for (LeafReader leafReader : this.getSequentialSubReaders()) {
            try {
                leafReader.decRef();
            }
            catch (Throwable throwable2) {
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (this.writer != null) {
            try {
                this.writer.decRefDeleter(this.segmentInfos);
            }
            catch (a a2) {
                // empty catch block
            }
        }
        IOUtils.reThrow(throwable);
    }
}

