/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.lucene.portmobile.charset.StandardCharsets;
import org.apache.lucene.util.BytesRef;

public final class Term
implements Comparable<Term> {
    String field;
    BytesRef bytes;

    public Term(String string, BytesRef bytesRef) {
        this.field = string;
        this.bytes = bytesRef;
    }

    public Term(String string, String string2) {
        this(string, new BytesRef(string2));
    }

    public Term(String string) {
        this(string, new BytesRef());
    }

    public final String field() {
        return this.field;
    }

    public final String text() {
        return Term.toString(this.bytes);
    }

    public static final String toString(BytesRef bytesRef) {
        CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            return charsetDecoder.decode(ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            return bytesRef.toString();
        }
    }

    public final BytesRef bytes() {
        return this.bytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Term term = (Term)object;
        if (this.field == null ? term.field != null : !this.field.equals(term.field)) {
            return false;
        }
        return !(this.bytes == null ? term.bytes != null : !this.bytes.equals(term.bytes));
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.field == null ? 0 : this.field.hashCode());
        n3 = 31 * n3 + (this.bytes == null ? 0 : this.bytes.hashCode());
        return n3;
    }

    @Override
    public final int compareTo(Term term) {
        if (this.field.equals(term.field)) {
            return this.bytes.compareTo(term.bytes);
        }
        return this.field.compareTo(term.field);
    }

    public final String toString() {
        return this.field + ":" + this.text();
    }
}

