/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.util.BytesRef;

public final class TermContext {
    public final IndexReaderContext topReaderContext;
    private final q[] states;
    private int docFreq;
    private long totalTermFreq;

    public TermContext(IndexReaderContext indexReaderContext) {
        assert (indexReaderContext != null && indexReaderContext.isTopLevel);
        this.topReaderContext = indexReaderContext;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        int n2 = indexReaderContext.leaves() == null ? 1 : indexReaderContext.leaves().size();
        this.states = new q[n2];
    }

    public TermContext(IndexReaderContext indexReaderContext, q q2, int n2, int n3, long l2) {
        this(indexReaderContext);
        this.register(q2, n2, n3, l2);
    }

    public static TermContext build(IndexReaderContext indexReaderContext, Term term) throws IOException {
        assert (indexReaderContext != null && indexReaderContext.isTopLevel);
        String string = term.field();
        BytesRef bytesRef = term.bytes();
        TermContext termContext = new TermContext(indexReaderContext);
        for (LeafReaderContext leafReaderContext : indexReaderContext.leaves()) {
            TermsEnum termsEnum;
            Terms terms = leafReaderContext.reader().terms(string);
            if (terms == null || !(termsEnum = terms.iterator()).seekExact(bytesRef)) continue;
            q q2 = termsEnum.termState();
            termContext.register(q2, leafReaderContext.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
        }
        return termContext;
    }

    public void register(q q2, int n2, int n3, long l2) {
        this.register(q2, n2);
        this.accumulateStatistics(n3, l2);
    }

    public void register(q q2, int n2) {
        assert (q2 != null) : "state must not be null";
        assert (n2 >= 0 && n2 < this.states.length);
        assert (this.states[n2] == null) : "state for ord: " + n2 + " already registered";
        this.states[n2] = q2;
    }

    public void accumulateStatistics(int n2, long l2) {
        this.docFreq += n2;
        this.totalTermFreq = this.totalTermFreq >= 0L && l2 >= 0L ? (this.totalTermFreq += l2) : -1L;
    }

    public q get(int n2) {
        assert (n2 >= 0 && n2 < this.states.length);
        return this.states[n2];
    }

    public int docFreq() {
        return this.docFreq;
    }

    public long totalTermFreq() {
        return this.totalTermFreq;
    }

    public boolean hasOnlyRealTerms() {
        for (q q2 : this.states) {
            if (q2 == null || q2.isRealTerm()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TermContext\n");
        for (q q2 : this.states) {
            stringBuilder.append("  state=");
            stringBuilder.append(q2.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

