/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.j;
import org.apache.lucene.util.BytesRef;

final class TermVectorsConsumerPerField
extends TermsHashPerField {
    private TermVectorsPostingsArray termVectorsPostingsArray;
    final TermVectorsConsumer termsWriter;
    boolean doVectors;
    boolean doVectorPositions;
    boolean doVectorOffsets;
    boolean doVectorPayloads;
    OffsetAttribute offsetAttribute;
    PayloadAttribute payloadAttribute;
    boolean hasPayloads;

    public TermVectorsConsumerPerField(FieldInvertState fieldInvertState, TermVectorsConsumer termVectorsConsumer, FieldInfo fieldInfo) {
        super(2, fieldInvertState, termVectorsConsumer, null, fieldInfo);
        this.termsWriter = termVectorsConsumer;
    }

    @Override
    void finish() {
        if (!this.doVectors || this.bytesHash.size() == 0) {
            return;
        }
        this.termsWriter.addFieldToFlush(this);
    }

    void finishDocument() throws IOException {
        if (!this.doVectors) {
            return;
        }
        this.doVectors = false;
        int n2 = this.bytesHash.size();
        BytesRef bytesRef = this.termsWriter.flushTerm;
        assert (n2 >= 0);
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        TermVectorsWriter termVectorsWriter = this.termsWriter.writer;
        int[] nArray = this.sortPostings();
        termVectorsWriter.startField(this.fieldInfo, n2, this.doVectorPositions, this.doVectorOffsets, this.hasPayloads);
        ByteSliceReader byteSliceReader = this.doVectorPositions ? this.termsWriter.vectorSliceReaderPos : null;
        ByteSliceReader byteSliceReader2 = this.doVectorOffsets ? this.termsWriter.vectorSliceReaderOff : null;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = termVectorsPostingsArray.freqs[n3];
            this.termBytePool.setBytesRef(bytesRef, termVectorsPostingsArray.textStarts[n3]);
            termVectorsWriter.startTerm(bytesRef, n4);
            if (this.doVectorPositions || this.doVectorOffsets) {
                if (byteSliceReader != null) {
                    this.initReader(byteSliceReader, n3, 0);
                }
                if (byteSliceReader2 != null) {
                    this.initReader(byteSliceReader2, n3, 1);
                }
                termVectorsWriter.addProx(n4, byteSliceReader, byteSliceReader2);
            }
            termVectorsWriter.finishTerm();
        }
        termVectorsWriter.finishField();
        this.reset();
        this.fieldInfo.setStoreTermVectors();
    }

    @Override
    boolean start(j j2, boolean bl) {
        assert (j2.fieldType().indexOptions() != IndexOptions.NONE);
        if (bl) {
            if (this.bytesHash.size() != 0) {
                this.reset();
            }
            this.bytesHash.reinit();
            this.hasPayloads = false;
            this.doVectors = j2.fieldType().storeTermVectors();
            if (this.doVectors) {
                this.termsWriter.hasVectors = true;
                this.doVectorPositions = j2.fieldType().storeTermVectorPositions();
                this.doVectorOffsets = j2.fieldType().storeTermVectorOffsets();
                if (this.doVectorPositions) {
                    this.doVectorPayloads = j2.fieldType().storeTermVectorPayloads();
                } else {
                    this.doVectorPayloads = false;
                    if (j2.fieldType().storeTermVectorPayloads()) {
                        throw new IllegalArgumentException("cannot index term vector payloads without term vector positions (field=\"" + j2.name() + "\")");
                    }
                }
            } else {
                if (j2.fieldType().storeTermVectorOffsets()) {
                    throw new IllegalArgumentException("cannot index term vector offsets when term vectors are not indexed (field=\"" + j2.name() + "\")");
                }
                if (j2.fieldType().storeTermVectorPositions()) {
                    throw new IllegalArgumentException("cannot index term vector positions when term vectors are not indexed (field=\"" + j2.name() + "\")");
                }
                if (j2.fieldType().storeTermVectorPayloads()) {
                    throw new IllegalArgumentException("cannot index term vector payloads when term vectors are not indexed (field=\"" + j2.name() + "\")");
                }
            }
        } else {
            if (this.doVectors != j2.fieldType().storeTermVectors()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectors changed for field=\"" + j2.name() + "\")");
            }
            if (this.doVectorPositions != j2.fieldType().storeTermVectorPositions()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPositions changed for field=\"" + j2.name() + "\")");
            }
            if (this.doVectorOffsets != j2.fieldType().storeTermVectorOffsets()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorOffsets changed for field=\"" + j2.name() + "\")");
            }
            if (this.doVectorPayloads != j2.fieldType().storeTermVectorPayloads()) {
                throw new IllegalArgumentException("all instances of a given field name must have the same term vectors settings (storeTermVectorPayloads changed for field=\"" + j2.name() + "\")");
            }
        }
        if (this.doVectors) {
            if (this.doVectorOffsets) {
                this.offsetAttribute = this.fieldState.offsetAttribute;
                assert (this.offsetAttribute != null);
            }
            this.payloadAttribute = this.doVectorPayloads ? this.fieldState.payloadAttribute : null;
        }
        return this.doVectors;
    }

    void writeProx(TermVectorsPostingsArray termVectorsPostingsArray, int n2) {
        int n3;
        if (this.doVectorOffsets) {
            int n4 = this.fieldState.offset + this.offsetAttribute.startOffset();
            n3 = this.fieldState.offset + this.offsetAttribute.endOffset();
            this.writeVInt(1, n4 - termVectorsPostingsArray.lastOffsets[n2]);
            this.writeVInt(1, n3 - n4);
            termVectorsPostingsArray.lastOffsets[n2] = n3;
        }
        if (this.doVectorPositions) {
            BytesRef bytesRef = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
            n3 = this.fieldState.position - termVectorsPostingsArray.lastPositions[n2];
            if (bytesRef != null && bytesRef.length > 0) {
                this.writeVInt(0, n3 << 1 | 1);
                this.writeVInt(0, bytesRef.length);
                this.writeBytes(0, bytesRef.bytes, bytesRef.offset, bytesRef.length);
                this.hasPayloads = true;
            } else {
                this.writeVInt(0, n3 << 1);
            }
            termVectorsPostingsArray.lastPositions[n2] = this.fieldState.position;
        }
    }

    @Override
    void newTerm(int n2) {
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        termVectorsPostingsArray.freqs[n2] = 1;
        termVectorsPostingsArray.lastOffsets[n2] = 0;
        termVectorsPostingsArray.lastPositions[n2] = 0;
        this.writeProx(termVectorsPostingsArray, n2);
    }

    @Override
    void addTerm(int n2) {
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        int n3 = n2;
        termVectorsPostingsArray.freqs[n3] = termVectorsPostingsArray.freqs[n3] + 1;
        this.writeProx(termVectorsPostingsArray, n2);
    }

    @Override
    public void newPostingsArray() {
        this.termVectorsPostingsArray = (TermVectorsPostingsArray)this.postingsArray;
    }

    @Override
    ParallelPostingsArray createPostingsArray(int n2) {
        return new TermVectorsPostingsArray(n2);
    }

    static final class TermVectorsPostingsArray
    extends ParallelPostingsArray {
        int[] freqs;
        int[] lastOffsets;
        int[] lastPositions;

        public TermVectorsPostingsArray(int n2) {
            super(n2);
            this.freqs = new int[n2];
            this.lastOffsets = new int[n2];
            this.lastPositions = new int[n2];
        }

        @Override
        ParallelPostingsArray newInstance(int n2) {
            return new TermVectorsPostingsArray(n2);
        }

        @Override
        void copyTo(ParallelPostingsArray parallelPostingsArray, int n2) {
            assert (parallelPostingsArray instanceof TermVectorsPostingsArray);
            TermVectorsPostingsArray termVectorsPostingsArray = (TermVectorsPostingsArray)parallelPostingsArray;
            super.copyTo(parallelPostingsArray, n2);
            System.arraycopy(this.freqs, 0, termVectorsPostingsArray.freqs, 0, this.size);
            System.arraycopy(this.lastOffsets, 0, termVectorsPostingsArray.lastOffsets, 0, this.size);
            System.arraycopy(this.lastPositions, 0, termVectorsPostingsArray.lastPositions, 0, this.size);
        }

        @Override
        int bytesPerPosting() {
            return super.bytesPerPosting() + 12;
        }
    }
}

