/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.j;
import org.apache.lucene.search.Query;

public class TrackingIndexWriter {
    private final IndexWriter writer;
    private final AtomicLong indexingGen = new AtomicLong(1L);

    public TrackingIndexWriter(IndexWriter indexWriter) {
        this.writer = indexWriter;
    }

    public long deleteDocuments(Term term) throws IOException {
        this.writer.deleteDocuments(term);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query query) throws IOException {
        this.writer.deleteDocuments(query);
        return this.indexingGen.get();
    }

    public long deleteAll() throws IOException {
        this.writer.deleteAll();
        return this.indexingGen.get();
    }

    public long addDocument(Iterable<? extends j> iterable) throws IOException {
        this.writer.addDocument(iterable);
        return this.indexingGen.get();
    }
}

