/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.portmobile.file;

import java.io.File;
import java.io.IOException;

public class Path {
    File file;

    Path(String string) {
        this.file = new File(string);
    }

    Path(File file) {
        this.file = file;
    }

    public File toFile() {
        return this.file;
    }

    public Path toRealPath() throws IOException {
        return this;
    }

    public Path getFileName() {
        return new Path(this.file.getName());
    }

    public String toString() {
        return this.file.toString();
    }

    public Path resolve(String string) {
        if (string.isEmpty()) {
            return this;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return new Path(file);
        }
        return new Path(new File(this.file, string));
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public Path toAbsolutePath() {
        return new Path(this.file.getAbsoluteFile());
    }

    public Path getParent() {
        return new Path(this.file.getParent());
    }
}

