/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.portmobile.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.portmobile.file.Files;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;

public class FileChannelUtils {
    public static FileChannel open(Path path, StandardOpenOption ... standardOpenOptionArray) throws IOException {
        List<StandardOpenOption> list = Arrays.asList(standardOpenOptionArray);
        if (list.size() == 1 && list.contains((Object)StandardOpenOption.READ)) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "r");
            return randomAccessFile.getChannel();
        }
        if (list.contains((Object)StandardOpenOption.WRITE)) {
            if (Files.notExists(path) && list.contains((Object)StandardOpenOption.CREATE)) {
                Files.createFile(path);
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "rw");
            return randomAccessFile.getChannel();
        }
        throw new IOException("Unknown options: " + standardOpenOptionArray);
    }
}

