/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AutomatonQuery
extends MultiTermQuery {
    protected final Automaton automaton;
    protected final CompiledAutomaton compiled;
    protected final Term term;

    public AutomatonQuery(Term term, Automaton automaton, int n2, boolean bl) {
        super(term.field());
        this.term = term;
        this.automaton = automaton;
        this.compiled = new CompiledAutomaton(automaton, null, true, n2, bl);
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource attributeSource) throws IOException {
        return this.compiled.getTermsEnum(terms);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.compiled.hashCode();
        n3 = 31 * n3 + (this.term == null ? 0 : this.term.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AutomatonQuery automatonQuery = (AutomatonQuery)object;
        if (!this.compiled.equals(automatonQuery.compiled)) {
            return false;
        }
        return !(this.term == null ? automatonQuery.term != null : !this.term.equals(automatonQuery.term));
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append('\n');
        stringBuilder.append(this.automaton.toString());
        stringBuilder.append("}");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }
}

