/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class ConjunctionScorer
extends Scorer {
    private final ConjunctionDISI disi;
    private final Scorer[] scorers;
    private final float coord;

    ConjunctionScorer(Weight weight, List<? extends DocIdSetIterator> list, List<Scorer> list2) {
        this(weight, list, list2, 1.0f);
    }

    ConjunctionScorer(Weight weight, List<? extends DocIdSetIterator> list, List<Scorer> list2, float f2) {
        super(weight);
        assert (list.containsAll(list2));
        this.coord = f2;
        this.disi = ConjunctionDISI.intersect(list);
        this.scorers = list2.toArray(new Scorer[list2.size()]);
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return this.disi.asTwoPhaseIterator();
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.disi.advance(n2);
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.disi.nextDoc();
    }

    @Override
    public float score() throws IOException {
        double d2 = 0.0;
        for (Scorer scorer : this.scorers) {
            d2 += (double)scorer.score();
        }
        return this.coord * (float)d2;
    }

    @Override
    public int freq() {
        return this.scorers.length;
    }

    @Override
    public long cost() {
        return this.disi.cost();
    }
}

