/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.f;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class ConstantScoreQuery
extends Query {
    protected final Query query;

    public ConstantScoreQuery(Query query) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Query query = this.query.rewrite(indexReader);
        if (query.getClass() == this.getClass()) {
            if (this.getBoost() != query.getBoost()) {
                query = query.clone();
                query.setBoost(this.getBoost());
            }
            return query;
        }
        if (query != this.query) {
            query = new ConstantScoreQuery(query);
            query.setBoost(this.getBoost());
            return query;
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        final Weight weight = indexSearcher.createWeight(this.query, false);
        if (bl) {
            return new ConstantScoreWeight(this){

                @Override
                public BulkScorer bulkScorer(LeafReaderContext leafReaderContext) throws IOException {
                    BulkScorer bulkScorer = weight.bulkScorer(leafReaderContext);
                    if (bulkScorer == null) {
                        return null;
                    }
                    return new ConstantBulkScorer(bulkScorer, this, this.score());
                }

                @Override
                public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                    final Scorer scorer = weight.scorer(leafReaderContext);
                    if (scorer == null) {
                        return null;
                    }
                    final float f2 = this.score();
                    return new FilterScorer(scorer){

                        @Override
                        public float score() throws IOException {
                            return f2;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }
                    };
                }
            };
        }
        return weight;
    }

    @Override
    public String toString(String string) {
        return "ConstantScore(" + this.query.toString(string) + ')' + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)object;
            return this.query.equals(constantScoreQuery.query);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    protected class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float f2) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = f2;
        }

        @Override
        public int score(f f2, Bits bits, int n2, int n3) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(f2), bits, n2, n3);
        }

        private f wrapCollector(f f2) {
            return new FilterLeafCollector(f2){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.in.setScorer(new FilterScorer(scorer){

                        @Override
                        public float score() throws IOException {
                            return ConstantBulkScorer.this.theScore;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

