/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;

public final class DisiPriorityQueue<Iter extends DocIdSetIterator>
implements Iterable<DisiWrapper<Iter>> {
    private final DisiWrapper<Iter>[] heap;
    private int size;

    static int leftNode(int n2) {
        return (n2 + 1 << 1) - 1;
    }

    static int rightNode(int n2) {
        return n2 + 1;
    }

    static int parentNode(int n2) {
        return (n2 + 1 >>> 1) - 1;
    }

    public DisiPriorityQueue(int n2) {
        this.heap = new DisiWrapper[n2];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public DisiWrapper<Iter> top() {
        return this.heap[0];
    }

    public DisiWrapper<Iter> topList() {
        DisiWrapper<Iter>[] disiWrapperArray = this.heap;
        int n2 = this.size;
        DisiWrapper<Iter> disiWrapper = disiWrapperArray[0];
        disiWrapper.next = null;
        if (n2 >= 3) {
            disiWrapper = this.topList(disiWrapper, disiWrapperArray, n2, 1);
            disiWrapper = this.topList(disiWrapper, disiWrapperArray, n2, 2);
        } else if (n2 == 2 && disiWrapperArray[1].doc == disiWrapper.doc) {
            disiWrapper = this.prepend(disiWrapperArray[1], disiWrapper);
        }
        return disiWrapper;
    }

    private DisiWrapper<Iter> prepend(DisiWrapper<Iter> disiWrapper, DisiWrapper<Iter> disiWrapper2) {
        disiWrapper.next = disiWrapper2;
        return disiWrapper;
    }

    private DisiWrapper<Iter> topList(DisiWrapper<Iter> disiWrapper, DisiWrapper<Iter>[] disiWrapperArray, int n2, int n3) {
        DisiWrapper<Iter> disiWrapper2 = disiWrapperArray[n3];
        if (disiWrapper2.doc == disiWrapper.doc) {
            disiWrapper = this.prepend(disiWrapper2, disiWrapper);
            int n4 = DisiPriorityQueue.leftNode(n3);
            int n5 = n4 + 1;
            if (n5 < n2) {
                disiWrapper = this.topList(disiWrapper, disiWrapperArray, n2, n4);
                disiWrapper = this.topList(disiWrapper, disiWrapperArray, n2, n5);
            } else if (n4 < n2 && disiWrapperArray[n4].doc == disiWrapper.doc) {
                disiWrapper = this.prepend(disiWrapperArray[n4], disiWrapper);
            }
        }
        return disiWrapper;
    }

    public DisiWrapper<Iter> add(DisiWrapper<Iter> disiWrapper) {
        DisiWrapper<Iter>[] disiWrapperArray = this.heap;
        int n2 = this.size;
        disiWrapperArray[n2] = disiWrapper;
        this.upHeap(n2);
        this.size = n2 + 1;
        return disiWrapperArray[0];
    }

    public DisiWrapper<Iter> pop() {
        DisiWrapper<Iter>[] disiWrapperArray = this.heap;
        DisiWrapper<Iter> disiWrapper = disiWrapperArray[0];
        int n2 = --this.size;
        disiWrapperArray[0] = disiWrapperArray[n2];
        disiWrapperArray[n2] = null;
        this.downHeap(n2);
        return disiWrapper;
    }

    public DisiWrapper<Iter> updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    DisiWrapper<Iter> updateTop(DisiWrapper<Iter> disiWrapper) {
        this.heap[0] = disiWrapper;
        return this.updateTop();
    }

    void upHeap(int n2) {
        DisiWrapper<Iter> disiWrapper = this.heap[n2];
        int n3 = disiWrapper.doc;
        int n4 = DisiPriorityQueue.parentNode(n2);
        while (n4 >= 0 && n3 < this.heap[n4].doc) {
            this.heap[n2] = this.heap[n4];
            n2 = n4;
            n4 = DisiPriorityQueue.parentNode(n4);
        }
        this.heap[n2] = disiWrapper;
    }

    void downHeap(int n2) {
        int n3 = 0;
        DisiWrapper<Iter> disiWrapper = this.heap[0];
        int n4 = DisiPriorityQueue.leftNode(n3);
        if (n4 < n2) {
            int n5 = DisiPriorityQueue.rightNode(n4);
            if (n5 < n2 && this.heap[n5].doc < this.heap[n4].doc) {
                n4 = n5;
            }
            if (this.heap[n4].doc < disiWrapper.doc) {
                do {
                    this.heap[n3] = this.heap[n4];
                    n3 = n4;
                    n5 = DisiPriorityQueue.rightNode(n4 = DisiPriorityQueue.leftNode(n3));
                    if (n5 >= n2 || this.heap[n5].doc >= this.heap[n4].doc) continue;
                    n4 = n5;
                } while (n4 < n2 && this.heap[n4].doc < disiWrapper.doc);
                this.heap[n3] = disiWrapper;
            }
        }
    }

    @Override
    public Iterator<DisiWrapper<Iter>> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

