/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

abstract class DisjunctionScorer
extends Scorer {
    private final boolean needsScores;
    private final DisiPriorityQueue<Scorer> subScorers;
    private final long cost;
    private DisiWrapper<Scorer> topScorers;

    protected DisjunctionScorer(Weight weight, List<Scorer> list, boolean bl) {
        super(weight);
        if (list.size() <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.subScorers = new DisiPriorityQueue(list.size());
        long l2 = 0L;
        for (Scorer scorer : list) {
            DisiWrapper<Scorer> disiWrapper = new DisiWrapper<Scorer>(scorer);
            l2 += disiWrapper.cost;
            this.subScorers.add(disiWrapper);
        }
        this.cost = l2;
        this.needsScores = bl;
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        boolean bl = false;
        for (DisiWrapper<Scorer> disiWrapper : this.subScorers) {
            if (disiWrapper.twoPhaseView == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        return new TwoPhaseIterator(new DisjunctionDISIApproximation<Scorer>(this.subScorers)){

            @Override
            public boolean matches() throws IOException {
                DisiWrapper disiWrapper = DisjunctionScorer.this.subScorers.topList();
                while (disiWrapper.twoPhaseView != null && !disiWrapper.twoPhaseView.matches()) {
                    disiWrapper = disiWrapper.next;
                    if (disiWrapper != null) continue;
                    return false;
                }
                if (DisjunctionScorer.this.needsScores) {
                    DisiWrapper disiWrapper2 = disiWrapper;
                    DisiWrapper disiWrapper3 = disiWrapper.next;
                    while (disiWrapper3 != null) {
                        if (disiWrapper3.twoPhaseView != null && !disiWrapper3.twoPhaseView.matches()) {
                            disiWrapper2.next = disiWrapper3.next;
                        } else {
                            disiWrapper2 = disiWrapper3;
                        }
                        disiWrapper3 = disiWrapper3.next;
                    }
                } else {
                    disiWrapper.next = null;
                }
                DisjunctionScorer.this.topScorers = disiWrapper;
                return true;
            }
        };
    }

    @Override
    public final long cost() {
        return this.cost;
    }

    @Override
    public final int docID() {
        return this.subScorers.top().doc;
    }

    @Override
    public final int nextDoc() throws IOException {
        this.topScorers = null;
        DisiWrapper<Scorer> disiWrapper = this.subScorers.top();
        int n2 = disiWrapper.doc;
        do {
            disiWrapper.doc = ((Scorer)disiWrapper.iterator).nextDoc();
            disiWrapper = this.subScorers.updateTop();
        } while (disiWrapper.doc == n2);
        return disiWrapper.doc;
    }

    @Override
    public final int advance(int n2) throws IOException {
        this.topScorers = null;
        DisiWrapper<Scorer> disiWrapper = this.subScorers.top();
        do {
            disiWrapper.doc = ((Scorer)disiWrapper.iterator).advance(n2);
            disiWrapper = this.subScorers.updateTop();
        } while (disiWrapper.doc < n2);
        return disiWrapper.doc;
    }

    @Override
    public final int freq() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        int n2 = 1;
        DisiWrapper disiWrapper = this.topScorers.next;
        while (disiWrapper != null) {
            ++n2;
            disiWrapper = disiWrapper.next;
        }
        return n2;
    }

    @Override
    public final float score() throws IOException {
        if (this.topScorers == null) {
            this.topScorers = this.subScorers.topList();
        }
        return this.score(this.topScorers);
    }

    protected abstract float score(DisiWrapper<Scorer> var1) throws IOException;
}

