/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.a;

final class ExactPhraseScorer
extends Scorer {
    private final ConjunctionDISI conjunction;
    private final PostingsAndPosition[] postings;
    private int freq;
    private final a.a docScorer;
    private final boolean needsScores;

    ExactPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postingsAndFreqArray, a.a a2, boolean bl) throws IOException {
        super(weight);
        this.docScorer = a2;
        this.needsScores = bl;
        ArrayList<PostingsEnum> arrayList = new ArrayList<PostingsEnum>();
        ArrayList<PostingsAndPosition> arrayList2 = new ArrayList<PostingsAndPosition>();
        for (PhraseQuery.PostingsAndFreq postingsAndFreq : postingsAndFreqArray) {
            arrayList.add(postingsAndFreq.postings);
            arrayList2.add(new PostingsAndPosition(postingsAndFreq.postings, postingsAndFreq.position));
        }
        this.conjunction = ConjunctionDISI.intersect(arrayList);
        this.postings = arrayList2.toArray(new PostingsAndPosition[arrayList2.size()]);
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return new TwoPhaseIterator(this.conjunction){

            @Override
            public boolean matches() throws IOException {
                return ExactPhraseScorer.this.phraseFreq() > 0;
            }
        };
    }

    private int doNext(int n2) throws IOException {
        while (n2 != Integer.MAX_VALUE && this.phraseFreq() <= 0) {
            n2 = this.conjunction.nextDoc();
        }
        return n2;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.conjunction.nextDoc());
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.doNext(this.conjunction.advance(n2));
    }

    public String toString() {
        return "ExactPhraseScorer(" + this.weight + ")";
    }

    @Override
    public int freq() {
        return this.freq;
    }

    @Override
    public int docID() {
        return this.conjunction.docID();
    }

    @Override
    public float score() {
        return this.docScorer.score(this.docID(), this.freq);
    }

    private static boolean advancePosition(PostingsAndPosition postingsAndPosition, int n2) throws IOException {
        while (postingsAndPosition.pos < n2) {
            if (postingsAndPosition.upTo == postingsAndPosition.freq) {
                return false;
            }
            postingsAndPosition.pos = postingsAndPosition.postings.nextPosition();
            PostingsAndPosition postingsAndPosition2 = postingsAndPosition;
            postingsAndPosition2.upTo = postingsAndPosition2.upTo + 1;
        }
        return true;
    }

    private int phraseFreq() throws IOException {
        PostingsAndPosition[] postingsAndPositionArray;
        for (PostingsAndPosition postingsAndPosition : postingsAndPositionArray = this.postings) {
            postingsAndPosition.freq = postingsAndPosition.postings.freq();
            postingsAndPosition.pos = postingsAndPosition.postings.nextPosition();
            postingsAndPosition.upTo = 1;
        }
        int n2 = 0;
        PostingsAndPosition postingsAndPosition = postingsAndPositionArray[0];
        block1: while (true) {
            int n3 = postingsAndPosition.pos - postingsAndPosition.offset;
            for (int i2 = 1; i2 < postingsAndPositionArray.length; ++i2) {
                PostingsAndPosition postingsAndPosition2 = postingsAndPositionArray[i2];
                int n4 = n3 + postingsAndPosition2.offset;
                if (!ExactPhraseScorer.advancePosition(postingsAndPosition2, n4)) break block1;
                if (postingsAndPosition2.pos == n4) continue;
                if (!ExactPhraseScorer.advancePosition(postingsAndPosition, postingsAndPosition2.pos - postingsAndPosition2.offset + postingsAndPosition.offset)) break block1;
                continue block1;
            }
            ++n2;
            if (!this.needsScores || postingsAndPosition.upTo == postingsAndPosition.freq) break;
            postingsAndPosition.pos = postingsAndPosition.postings.nextPosition();
            postingsAndPosition.upTo = postingsAndPosition.upTo + 1;
        }
        this.freq = n2;
        return this.freq;
    }

    @Override
    public long cost() {
        return this.conjunction.cost();
    }

    private static class PostingsAndPosition {
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(PostingsEnum postingsEnum, int n2) {
            this.postings = postingsEnum;
            this.offset = n2;
        }
    }
}

