/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.g;
import org.apache.lucene.search.o;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setTopValue(T var1);

    public abstract T value(int var1);

    public abstract g getLeafComparator(LeafReaderContext var1) throws IOException;

    public int compareValues(T t2, T t3) {
        if (t2 == null) {
            if (t3 == null) {
                return 0;
            }
            return -1;
        }
        if (t3 == null) {
            return 1;
        }
        return ((Comparable)t2).compareTo(t3);
    }

    public static class TermValComparator
    extends FieldComparator<BytesRef>
    implements g {
        private final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        private a docTerms;
        private Bits docsWithField;
        private final String field;
        private BytesRef bottom;
        private BytesRef topValue;
        private final int missingSortCmp;

        public TermValComparator(int n2, String string, boolean bl) {
            this.values = new BytesRef[n2];
            this.tempBRs = new BytesRefBuilder[n2];
            this.field = string;
            this.missingSortCmp = bl ? 1 : -1;
        }

        @Override
        public int compare(int n2, int n3) {
            BytesRef bytesRef = this.values[n2];
            BytesRef bytesRef2 = this.values[n3];
            return this.compareValues(bytesRef, bytesRef2);
        }

        @Override
        public int compareBottom(int n2) {
            BytesRef bytesRef = this.getComparableBytes(n2, this.docTerms.get(n2));
            return this.compareValues(this.bottom, bytesRef);
        }

        @Override
        public void copy(int n2, int n3) {
            BytesRef bytesRef = this.getComparableBytes(n3, this.docTerms.get(n3));
            if (bytesRef == null) {
                this.values[n2] = null;
            } else {
                if (this.tempBRs[n2] == null) {
                    this.tempBRs[n2] = new BytesRefBuilder();
                }
                this.tempBRs[n2].copyBytes(bytesRef);
                this.values[n2] = this.tempBRs[n2].get();
            }
        }

        protected a getBinaryDocValues(LeafReaderContext leafReaderContext, String string) throws IOException {
            return DocValues.getBinary(leafReaderContext.reader(), string);
        }

        protected Bits getDocsWithField(LeafReaderContext leafReaderContext, String string) throws IOException {
            return DocValues.getDocsWithField(leafReaderContext.reader(), string);
        }

        protected boolean isNull(int n2, BytesRef bytesRef) {
            return this.docsWithField != null && !this.docsWithField.get(n2);
        }

        @Override
        public g getLeafComparator(LeafReaderContext leafReaderContext) throws IOException {
            this.docTerms = this.getBinaryDocValues(leafReaderContext, this.field);
            this.docsWithField = this.getDocsWithField(leafReaderContext, this.field);
            if (this.docsWithField instanceof Bits.MatchAllBits) {
                this.docsWithField = null;
            }
            return this;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.values[n2];
        }

        @Override
        public void setTopValue(BytesRef bytesRef) {
            this.topValue = bytesRef;
        }

        @Override
        public BytesRef value(int n2) {
            return this.values[n2];
        }

        @Override
        public int compareValues(BytesRef bytesRef, BytesRef bytesRef2) {
            if (bytesRef == null) {
                if (bytesRef2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (bytesRef2 == null) {
                return -this.missingSortCmp;
            }
            return bytesRef.compareTo(bytesRef2);
        }

        @Override
        public int compareTop(int n2) {
            BytesRef bytesRef = this.getComparableBytes(n2, this.docTerms.get(n2));
            return this.compareValues(this.topValue, bytesRef);
        }

        private BytesRef getComparableBytes(int n2, BytesRef bytesRef) {
            if (bytesRef.length == 0 && this.isNull(n2, bytesRef)) {
                return null;
            }
            return bytesRef;
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static class TermOrdValComparator
    extends FieldComparator<BytesRef>
    implements g {
        final int[] ords;
        final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        final int[] readerGen;
        int currentReaderGen = -1;
        SortedDocValues termsIndex;
        private final String field;
        int bottomSlot = -1;
        int bottomOrd;
        boolean bottomSameReader;
        BytesRef bottomValue;
        BytesRef topValue;
        boolean topSameReader;
        int topOrd;
        final int missingSortCmp;
        final int missingOrd;

        public TermOrdValComparator(int n2, String string, boolean bl) {
            this.ords = new int[n2];
            this.values = new BytesRef[n2];
            this.tempBRs = new BytesRefBuilder[n2];
            this.readerGen = new int[n2];
            this.field = string;
            if (bl) {
                this.missingSortCmp = 1;
                this.missingOrd = Integer.MAX_VALUE;
            } else {
                this.missingSortCmp = -1;
                this.missingOrd = -1;
            }
        }

        @Override
        public int compare(int n2, int n3) {
            if (this.readerGen[n2] == this.readerGen[n3]) {
                return this.ords[n2] - this.ords[n3];
            }
            BytesRef bytesRef = this.values[n2];
            BytesRef bytesRef2 = this.values[n3];
            if (bytesRef == null) {
                if (bytesRef2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (bytesRef2 == null) {
                return -this.missingSortCmp;
            }
            return bytesRef.compareTo(bytesRef2);
        }

        @Override
        public int compareBottom(int n2) {
            assert (this.bottomSlot != -1);
            int n3 = this.termsIndex.getOrd(n2);
            if (n3 == -1) {
                n3 = this.missingOrd;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - n3;
            }
            if (this.bottomOrd >= n3) {
                return 1;
            }
            return -1;
        }

        @Override
        public void copy(int n2, int n3) {
            int n4 = this.termsIndex.getOrd(n3);
            if (n4 == -1) {
                n4 = this.missingOrd;
                this.values[n2] = null;
            } else {
                assert (n4 >= 0);
                if (this.tempBRs[n2] == null) {
                    this.tempBRs[n2] = new BytesRefBuilder();
                }
                this.tempBRs[n2].copyBytes(this.termsIndex.lookupOrd(n4));
                this.values[n2] = this.tempBRs[n2].get();
            }
            this.ords[n2] = n4;
            this.readerGen[n2] = this.currentReaderGen;
        }

        protected SortedDocValues getSortedDocValues(LeafReaderContext leafReaderContext, String string) throws IOException {
            return DocValues.getSorted(leafReaderContext.reader(), string);
        }

        @Override
        public g getLeafComparator(LeafReaderContext leafReaderContext) throws IOException {
            this.termsIndex = this.getSortedDocValues(leafReaderContext, this.field);
            ++this.currentReaderGen;
            if (this.topValue != null) {
                int n2 = this.termsIndex.lookupTerm(this.topValue);
                if (n2 >= 0) {
                    this.topSameReader = true;
                    this.topOrd = n2;
                } else {
                    this.topSameReader = false;
                    this.topOrd = -n2 - 2;
                }
            } else {
                this.topOrd = this.missingOrd;
                this.topSameReader = true;
            }
            if (this.bottomSlot != -1) {
                this.setBottom(this.bottomSlot);
            }
            return this;
        }

        @Override
        public void setBottom(int n2) {
            this.bottomSlot = n2;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == this.missingOrd);
                this.bottomOrd = this.missingOrd;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int n3 = this.termsIndex.lookupTerm(this.bottomValue);
                if (n3 < 0) {
                    this.bottomOrd = -n3 - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = n3;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public void setTopValue(BytesRef bytesRef) {
            this.topValue = bytesRef;
        }

        @Override
        public BytesRef value(int n2) {
            return this.values[n2];
        }

        @Override
        public int compareTop(int n2) {
            int n3 = this.termsIndex.getOrd(n2);
            if (n3 == -1) {
                n3 = this.missingOrd;
            }
            if (this.topSameReader) {
                return this.topOrd - n3;
            }
            if (n3 <= this.topOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compareValues(BytesRef bytesRef, BytesRef bytesRef2) {
            if (bytesRef == null) {
                if (bytesRef2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (bytesRef2 == null) {
                return -this.missingSortCmp;
            }
            return bytesRef.compareTo(bytesRef2);
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static final class DocComparator
    extends FieldComparator<Integer>
    implements g {
        private final int[] docIDs;
        private int docBase;
        private int bottom;
        private int topValue;

        public DocComparator(int n2) {
            this.docIDs = new int[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return this.docIDs[n2] - this.docIDs[n3];
        }

        @Override
        public int compareBottom(int n2) {
            return this.bottom - (this.docBase + n2);
        }

        @Override
        public void copy(int n2, int n3) {
            this.docIDs[n2] = this.docBase + n3;
        }

        @Override
        public g getLeafComparator(LeafReaderContext leafReaderContext) {
            this.docBase = leafReaderContext.docBase;
            return this;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.docIDs[n2];
        }

        @Override
        public void setTopValue(Integer n2) {
            this.topValue = n2;
        }

        @Override
        public Integer value(int n2) {
            return this.docIDs[n2];
        }

        @Override
        public int compareTop(int n2) {
            int n3 = this.docBase + n2;
            return Integer.compare(this.topValue, n3);
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float>
    implements g {
        private final float[] scores;
        private float bottom;
        private Scorer scorer;
        private float topValue;

        public RelevanceComparator(int n2) {
            this.scores = new float[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return Float.compare(this.scores[n3], this.scores[n2]);
        }

        @Override
        public int compareBottom(int n2) throws IOException {
            float f2 = this.scorer.score();
            assert (!Float.isNaN(f2));
            return Float.compare(f2, this.bottom);
        }

        @Override
        public void copy(int n2, int n3) throws IOException {
            this.scores[n2] = this.scorer.score();
            assert (!Float.isNaN(this.scores[n2]));
        }

        @Override
        public g getLeafComparator(LeafReaderContext leafReaderContext) {
            return this;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.scores[n2];
        }

        @Override
        public void setTopValue(Float f2) {
            this.topValue = f2.floatValue();
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = !(scorer instanceof ScoreCachingWrappingScorer) ? new ScoreCachingWrappingScorer(scorer) : scorer;
        }

        @Override
        public Float value(int n2) {
            return Float.valueOf(this.scores[n2]);
        }

        @Override
        public int compareValues(Float f2, Float f3) {
            return f3.compareTo(f2);
        }

        @Override
        public int compareTop(int n2) throws IOException {
            float f2 = this.scorer.score();
            assert (!Float.isNaN(f2));
            return Float.compare(f2, this.topValue);
        }
    }

    public static class LongComparator
    extends NumericComparator<Long> {
        private final long[] values;
        private long bottom;
        private long topValue;

        public LongComparator(int n2, String string, Long l2) {
            super(string, l2);
            this.values = new long[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return Long.compare(this.values[n2], this.values[n3]);
        }

        @Override
        public int compareBottom(int n2) {
            long l2 = this.currentReaderValues.get(n2);
            if (this.docsWithField != null && l2 == 0L && !this.docsWithField.get(n2)) {
                l2 = (Long)this.missingValue;
            }
            return Long.compare(this.bottom, l2);
        }

        @Override
        public void copy(int n2, int n3) {
            long l2 = this.currentReaderValues.get(n3);
            if (this.docsWithField != null && l2 == 0L && !this.docsWithField.get(n3)) {
                l2 = (Long)this.missingValue;
            }
            this.values[n2] = l2;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.values[n2];
        }

        @Override
        public void setTopValue(Long l2) {
            this.topValue = l2;
        }

        @Override
        public Long value(int n2) {
            return this.values[n2];
        }

        @Override
        public int compareTop(int n2) {
            long l2 = this.currentReaderValues.get(n2);
            if (this.docsWithField != null && l2 == 0L && !this.docsWithField.get(n2)) {
                l2 = (Long)this.missingValue;
            }
            return Long.compare(this.topValue, l2);
        }
    }

    public static class IntComparator
    extends NumericComparator<Integer> {
        private final int[] values;
        private int bottom;
        private int topValue;

        public IntComparator(int n2, String string, Integer n3) {
            super(string, n3);
            this.values = new int[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return Integer.compare(this.values[n2], this.values[n3]);
        }

        @Override
        public int compareBottom(int n2) {
            int n3 = (int)this.currentReaderValues.get(n2);
            if (this.docsWithField != null && n3 == 0 && !this.docsWithField.get(n2)) {
                n3 = (Integer)this.missingValue;
            }
            return Integer.compare(this.bottom, n3);
        }

        @Override
        public void copy(int n2, int n3) {
            int n4 = (int)this.currentReaderValues.get(n3);
            if (this.docsWithField != null && n4 == 0 && !this.docsWithField.get(n3)) {
                n4 = (Integer)this.missingValue;
            }
            this.values[n2] = n4;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.values[n2];
        }

        @Override
        public void setTopValue(Integer n2) {
            this.topValue = n2;
        }

        @Override
        public Integer value(int n2) {
            return this.values[n2];
        }

        @Override
        public int compareTop(int n2) {
            int n3 = (int)this.currentReaderValues.get(n2);
            if (this.docsWithField != null && n3 == 0 && !this.docsWithField.get(n2)) {
                n3 = (Integer)this.missingValue;
            }
            return Integer.compare(this.topValue, n3);
        }
    }

    public static class FloatComparator
    extends NumericComparator<Float> {
        private final float[] values;
        private float bottom;
        private float topValue;

        public FloatComparator(int n2, String string, Float f2) {
            super(string, f2);
            this.values = new float[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return Float.compare(this.values[n2], this.values[n3]);
        }

        @Override
        public int compareBottom(int n2) {
            float f2 = Float.intBitsToFloat((int)this.currentReaderValues.get(n2));
            if (this.docsWithField != null && f2 == 0.0f && !this.docsWithField.get(n2)) {
                f2 = ((Float)this.missingValue).floatValue();
            }
            return Float.compare(this.bottom, f2);
        }

        @Override
        public void copy(int n2, int n3) {
            float f2 = Float.intBitsToFloat((int)this.currentReaderValues.get(n3));
            if (this.docsWithField != null && f2 == 0.0f && !this.docsWithField.get(n3)) {
                f2 = ((Float)this.missingValue).floatValue();
            }
            this.values[n2] = f2;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.values[n2];
        }

        @Override
        public void setTopValue(Float f2) {
            this.topValue = f2.floatValue();
        }

        @Override
        public Float value(int n2) {
            return Float.valueOf(this.values[n2]);
        }

        @Override
        public int compareTop(int n2) {
            float f2 = Float.intBitsToFloat((int)this.currentReaderValues.get(n2));
            if (this.docsWithField != null && f2 == 0.0f && !this.docsWithField.get(n2)) {
                f2 = ((Float)this.missingValue).floatValue();
            }
            return Float.compare(this.topValue, f2);
        }
    }

    public static class DoubleComparator
    extends NumericComparator<Double> {
        private final double[] values;
        private double bottom;
        private double topValue;

        public DoubleComparator(int n2, String string, Double d2) {
            super(string, d2);
            this.values = new double[n2];
        }

        @Override
        public int compare(int n2, int n3) {
            return Double.compare(this.values[n2], this.values[n3]);
        }

        @Override
        public int compareBottom(int n2) {
            double d2 = Double.longBitsToDouble(this.currentReaderValues.get(n2));
            if (this.docsWithField != null && d2 == 0.0 && !this.docsWithField.get(n2)) {
                d2 = (Double)this.missingValue;
            }
            return Double.compare(this.bottom, d2);
        }

        @Override
        public void copy(int n2, int n3) {
            double d2 = Double.longBitsToDouble(this.currentReaderValues.get(n3));
            if (this.docsWithField != null && d2 == 0.0 && !this.docsWithField.get(n3)) {
                d2 = (Double)this.missingValue;
            }
            this.values[n2] = d2;
        }

        @Override
        public void setBottom(int n2) {
            this.bottom = this.values[n2];
        }

        @Override
        public void setTopValue(Double d2) {
            this.topValue = d2;
        }

        @Override
        public Double value(int n2) {
            return this.values[n2];
        }

        @Override
        public int compareTop(int n2) {
            double d2 = Double.longBitsToDouble(this.currentReaderValues.get(n2));
            if (this.docsWithField != null && d2 == 0.0 && !this.docsWithField.get(n2)) {
                d2 = (Double)this.missingValue;
            }
            return Double.compare(this.topValue, d2);
        }
    }

    public static abstract class NumericComparator<T extends Number>
    extends o<T> {
        protected final T missingValue;
        protected final String field;
        protected Bits docsWithField;
        protected m currentReaderValues;

        public NumericComparator(String string, T t2) {
            this.field = string;
            this.missingValue = t2;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
            this.currentReaderValues = this.getNumericDocValues(leafReaderContext, this.field);
            if (this.missingValue != null) {
                this.docsWithField = this.getDocsWithValue(leafReaderContext, this.field);
                if (this.docsWithField instanceof Bits.MatchAllBits) {
                    this.docsWithField = null;
                }
            } else {
                this.docsWithField = null;
            }
        }

        protected m getNumericDocValues(LeafReaderContext leafReaderContext, String string) throws IOException {
            return DocValues.getNumeric(leafReaderContext.reader(), string);
        }

        protected Bits getDocsWithValue(LeafReaderContext leafReaderContext, String string) throws IOException {
            return DocValues.getDocsWithField(leafReaderContext.reader(), string);
        }
    }
}

