/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.b;
import org.apache.lucene.search.c;
import org.apache.lucene.search.f;
import org.apache.lucene.search.k;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.a;

public class IndexSearcher {
    private static final a NON_SCORING_SIMILARITY = new a(){

        @Override
        public long computeNorm(FieldInvertState fieldInvertState) {
            throw new UnsupportedOperationException("This Similarity may only be used for searching, not indexing");
        }

        @Override
        public a.b computeWeight(float f2, CollectionStatistics collectionStatistics, TermStatistics ... termStatisticsArray) {
            return new a.b(){

                @Override
                public float getValueForNormalization() {
                    return 1.0f;
                }

                @Override
                public void normalize(float f2, float f3) {
                }
            };
        }

        @Override
        public a.a simScorer(a.b b2, LeafReaderContext leafReaderContext) throws IOException {
            return new a.a(){

                @Override
                public float score(int n2, float f2) {
                    return 0.0f;
                }

                @Override
                public float computeSlopFactor(int n2) {
                    return 1.0f;
                }
            };
        }
    };
    private static k DEFAULT_QUERY_CACHE = null;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    protected final LeafSlice[] leafSlices;
    private final ExecutorService executor;
    private static final a defaultSimilarity = new DefaultSimilarity();
    private k queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private a similarity = defaultSimilarity;

    public static a getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public IndexSearcher(IndexReader indexReader) {
        this(indexReader, null);
    }

    public IndexSearcher(IndexReader indexReader, ExecutorService executorService) {
        this(indexReader.getContext(), executorService);
    }

    public IndexSearcher(IndexReaderContext indexReaderContext, ExecutorService executorService) {
        assert (indexReaderContext.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader" + indexReaderContext.reader();
        this.reader = indexReaderContext.reader();
        this.executor = executorService;
        this.readerContext = indexReaderContext;
        this.leafContexts = indexReaderContext.leaves();
        this.leafSlices = executorService == null ? null : this.slices(this.leafContexts);
    }

    public void setQueryCache(k k2) {
        this.queryCache = k2;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> list) {
        LeafSlice[] leafSliceArray = new LeafSlice[list.size()];
        for (int i2 = 0; i2 < leafSliceArray.length; ++i2) {
            leafSliceArray[i2] = new LeafSlice(list.get(i2));
        }
        return leafSliceArray;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Document doc(int n2) throws IOException {
        return this.reader.document(n2);
    }

    public a getSimilarity(boolean bl) {
        return bl ? this.similarity : NON_SCORING_SIMILARITY;
    }

    public TopDocs searchAfter(final ScoreDoc scoreDoc, Query query, int n2) throws IOException {
        int n3 = Math.max(1, this.reader.maxDoc());
        if (scoreDoc != null && scoreDoc.doc >= n3) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + scoreDoc.doc + " limit=" + n3);
        }
        n2 = Math.min(n2, n3);
        final int n4 = Math.min(n2, n3);
        c<TopScoreDocCollector, TopDocs> c2 = new c<TopScoreDocCollector, TopDocs>(){

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(n4, scoreDoc);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> collection) throws IOException {
                TopDocs[] topDocsArray = new TopDocs[collection.size()];
                int n2 = 0;
                for (TopScoreDocCollector topScoreDocCollector : collection) {
                    topDocsArray[n2++] = topScoreDocCollector.topDocs();
                }
                return TopDocs.merge(n4, topDocsArray);
            }
        };
        return this.search(query, c2);
    }

    public TopDocs search(Query query, int n2) throws IOException {
        return this.searchAfter(null, query, n2);
    }

    public void search(Query query, b b2) throws IOException {
        this.search(this.leafContexts, this.createNormalizedWeight(query, b2.needsScores()), b2);
    }

    public final TopFieldDocs search(Query query, int n2, Sort sort, boolean bl, boolean bl2) throws IOException {
        return this.searchAfter(null, query, n2, sort, bl, bl2);
    }

    public final TopFieldDocs searchAfter(ScoreDoc scoreDoc, Query query, int n2, Sort sort, boolean bl, boolean bl2) throws IOException {
        if (scoreDoc != null && !(scoreDoc instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + scoreDoc);
        }
        return this.searchAfter((FieldDoc)scoreDoc, query, n2, sort, bl, bl2);
    }

    private TopFieldDocs searchAfter(final FieldDoc fieldDoc, Query query, int n2, final Sort sort, final boolean bl, final boolean bl2) throws IOException {
        int n3 = Math.max(1, this.reader.maxDoc());
        if (fieldDoc != null && fieldDoc.doc >= n3) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + fieldDoc.doc + " limit=" + n3);
        }
        final int n4 = Math.min(n2, n3);
        c<TopFieldCollector, TopFieldDocs> c2 = new c<TopFieldCollector, TopFieldDocs>(){

            @Override
            public TopFieldCollector newCollector() throws IOException {
                boolean bl3 = true;
                return TopFieldCollector.create(sort, n4, fieldDoc, true, bl, bl2);
            }

            @Override
            public TopFieldDocs reduce(Collection<TopFieldCollector> collection) throws IOException {
                TopFieldDocs[] topFieldDocsArray = new TopFieldDocs[collection.size()];
                int n2 = 0;
                for (TopFieldCollector topFieldCollector : collection) {
                    topFieldDocsArray[n2++] = topFieldCollector.topDocs();
                }
                return TopDocs.merge(sort, n4, topFieldDocsArray);
            }
        };
        return this.search(query, c2);
    }

    public <C extends b, T> T search(Query query, c<C, T> c2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.executor == null) {
            C c3 = c2.newCollector();
            this.search(query, (b)c3);
            return c2.reduce(Collections.singletonList(c3));
        }
        ArrayList<C> arrayList = new ArrayList<C>(this.leafSlices.length);
        boolean bl = false;
        for (int i2 = 0; i2 < this.leafSlices.length; ++i2) {
            object3 = c2.newCollector();
            arrayList.add(object3);
            bl |= object3.needsScores();
        }
        Weight weight = this.createNormalizedWeight(query, bl);
        object3 = new ArrayList(this.leafSlices.length);
        for (int i3 = 0; i3 < this.leafSlices.length; ++i3) {
            object2 = this.leafSlices[i3].leaves;
            object = (b)arrayList.get(i3);
            object3.add(this.executor.submit(new Callable<C>((LeafReaderContext[])object2, weight, (b)object){
                final /* synthetic */ LeafReaderContext[] val$leaves;
                final /* synthetic */ Weight val$weight;
                final /* synthetic */ b val$collector;
                {
                    this.val$leaves = leafReaderContextArray;
                    this.val$weight = weight;
                    this.val$collector = b2;
                }

                @Override
                public C call() throws Exception {
                    IndexSearcher.this.search(Arrays.asList(this.val$leaves), this.val$weight, this.val$collector);
                    return this.val$collector;
                }
            }));
        }
        ArrayList arrayList2 = new ArrayList();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Future)object2.next();
            try {
                arrayList2.add(object.get());
            }
            catch (InterruptedException interruptedException) {
                throw new org.apache.lucene.util.k(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        return c2.reduce(arrayList);
    }

    protected void search(List<LeafReaderContext> list, Weight weight, b b2) throws IOException {
        for (LeafReaderContext leafReaderContext : list) {
            f f2;
            try {
                f2 = b2.getLeafCollector(leafReaderContext);
            }
            catch (org.apache.lucene.search.a a2) {
                continue;
            }
            BulkScorer bulkScorer = weight.bulkScorer(leafReaderContext);
            if (bulkScorer == null) continue;
            try {
                bulkScorer.score(f2, leafReaderContext.reader().getLiveDocs());
            }
            catch (org.apache.lucene.search.a a3) {}
        }
    }

    public Query rewrite(Query query) throws IOException {
        Query query2 = query;
        Query query3 = query2.rewrite(this.reader);
        while (query3 != query2) {
            query2 = query3;
            query3 = query2.rewrite(this.reader);
        }
        return query2;
    }

    public Weight createNormalizedWeight(Query query, boolean bl) throws IOException {
        query = this.rewrite(query);
        Weight weight = this.createWeight(query, bl);
        float f2 = weight.getValueForNormalization();
        float f3 = this.getSimilarity(bl).queryNorm(f2);
        if (Float.isInfinite(f3) || Float.isNaN(f3)) {
            f3 = 1.0f;
        }
        weight.normalize(f3, 1.0f);
        return weight;
    }

    public Weight createWeight(Query query, boolean bl) throws IOException {
        k k2 = this.queryCache;
        Weight weight = query.createWeight(this, bl);
        if (!bl && k2 != null) {
            weight = k2.a(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + "; executor=" + this.executor + ")";
    }

    public TermStatistics termStatistics(Term term, TermContext termContext) throws IOException {
        return new TermStatistics(term.bytes(), termContext.docFreq(), termContext.totalTermFreq());
    }

    public CollectionStatistics collectionStatistics(String string) throws IOException {
        long l2;
        long l3;
        int n2;
        assert (string != null);
        Terms terms = MultiFields.getTerms(this.reader, string);
        if (terms == null) {
            n2 = 0;
            l3 = 0L;
            l2 = 0L;
        } else {
            n2 = terms.getDocCount();
            l3 = terms.getSumTotalTermFreq();
            l2 = terms.getSumDocFreq();
        }
        return new CollectionStatistics(string, this.reader.maxDoc(), n2, l3, l2);
    }

    public static class LeafSlice {
        final LeafReaderContext[] leaves;

        public LeafSlice(LeafReaderContext ... leafReaderContextArray) {
            this.leaves = leafReaderContextArray;
        }
    }
}

